/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierListCopier;
import software.amazon.awssdk.services.ec2.model.GroupNameStringListCopier;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.InstanceListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Reservation
implements ToCopyableBuilder<Builder, Reservation> {
    private final List<GroupIdentifier> groups;
    private final List<Instance> instances;
    private final String ownerId;
    private final String requesterId;
    private final String reservationId;
    private final List<String> groupNames;

    private Reservation(BuilderImpl builder) {
        this.groups = builder.groups;
        this.instances = builder.instances;
        this.ownerId = builder.ownerId;
        this.requesterId = builder.requesterId;
        this.reservationId = builder.reservationId;
        this.groupNames = builder.groupNames;
    }

    public List<GroupIdentifier> groups() {
        return this.groups;
    }

    public List<Instance> instances() {
        return this.instances;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String requesterId() {
        return this.requesterId;
    }

    public String reservationId() {
        return this.reservationId;
    }

    public List<String> groupNames() {
        return this.groupNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.groups() == null ? 0 : this.groups().hashCode());
        hashCode = 31 * hashCode + (this.instances() == null ? 0 : this.instances().hashCode());
        hashCode = 31 * hashCode + (this.ownerId() == null ? 0 : this.ownerId().hashCode());
        hashCode = 31 * hashCode + (this.requesterId() == null ? 0 : this.requesterId().hashCode());
        hashCode = 31 * hashCode + (this.reservationId() == null ? 0 : this.reservationId().hashCode());
        hashCode = 31 * hashCode + (this.groupNames() == null ? 0 : this.groupNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Reservation)) {
            return false;
        }
        Reservation other = (Reservation)obj;
        if (other.groups() == null ^ this.groups() == null) {
            return false;
        }
        if (other.groups() != null && !other.groups().equals(this.groups())) {
            return false;
        }
        if (other.instances() == null ^ this.instances() == null) {
            return false;
        }
        if (other.instances() != null && !other.instances().equals(this.instances())) {
            return false;
        }
        if (other.ownerId() == null ^ this.ownerId() == null) {
            return false;
        }
        if (other.ownerId() != null && !other.ownerId().equals(this.ownerId())) {
            return false;
        }
        if (other.requesterId() == null ^ this.requesterId() == null) {
            return false;
        }
        if (other.requesterId() != null && !other.requesterId().equals(this.requesterId())) {
            return false;
        }
        if (other.reservationId() == null ^ this.reservationId() == null) {
            return false;
        }
        if (other.reservationId() != null && !other.reservationId().equals(this.reservationId())) {
            return false;
        }
        if (other.groupNames() == null ^ this.groupNames() == null) {
            return false;
        }
        return other.groupNames() == null || other.groupNames().equals(this.groupNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.groups() != null) {
            sb.append("Groups: ").append(this.groups()).append(",");
        }
        if (this.instances() != null) {
            sb.append("Instances: ").append(this.instances()).append(",");
        }
        if (this.ownerId() != null) {
            sb.append("OwnerId: ").append(this.ownerId()).append(",");
        }
        if (this.requesterId() != null) {
            sb.append("RequesterId: ").append(this.requesterId()).append(",");
        }
        if (this.reservationId() != null) {
            sb.append("ReservationId: ").append(this.reservationId()).append(",");
        }
        if (this.groupNames() != null) {
            sb.append("GroupNames: ").append(this.groupNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<GroupIdentifier> groups = new SdkInternalList();
        private List<Instance> instances = new SdkInternalList();
        private String ownerId;
        private String requesterId;
        private String reservationId;
        private List<String> groupNames = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(Reservation model) {
            this.setGroups(model.groups);
            this.setInstances(model.instances);
            this.setOwnerId(model.ownerId);
            this.setRequesterId(model.requesterId);
            this.setReservationId(model.reservationId);
            this.setGroupNames(model.groupNames);
        }

        public final Collection<GroupIdentifier> getGroups() {
            return this.groups;
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier ... groups) {
            if (this.groups == null) {
                this.groups = new SdkInternalList(groups.length);
            }
            for (GroupIdentifier e : groups) {
                this.groups.add(e);
            }
            return this;
        }

        public final void setGroups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
        }

        @SafeVarargs
        public final void setGroups(GroupIdentifier ... groups) {
            if (this.groups == null) {
                this.groups = new SdkInternalList(groups.length);
            }
            for (GroupIdentifier e : groups) {
                this.groups.add(e);
            }
        }

        public final Collection<Instance> getInstances() {
            return this.instances;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance ... instances) {
            if (this.instances == null) {
                this.instances = new SdkInternalList(instances.length);
            }
            for (Instance e : instances) {
                this.instances.add(e);
            }
            return this;
        }

        public final void setInstances(Collection<Instance> instances) {
            this.instances = InstanceListCopier.copy(instances);
        }

        @SafeVarargs
        public final void setInstances(Instance ... instances) {
            if (this.instances == null) {
                this.instances = new SdkInternalList(instances.length);
            }
            for (Instance e : instances) {
                this.instances.add(e);
            }
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getRequesterId() {
            return this.requesterId;
        }

        @Override
        public final Builder requesterId(String requesterId) {
            this.requesterId = requesterId;
            return this;
        }

        public final void setRequesterId(String requesterId) {
            this.requesterId = requesterId;
        }

        public final String getReservationId() {
            return this.reservationId;
        }

        @Override
        public final Builder reservationId(String reservationId) {
            this.reservationId = reservationId;
            return this;
        }

        public final void setReservationId(String reservationId) {
            this.reservationId = reservationId;
        }

        public final Collection<String> getGroupNames() {
            return this.groupNames;
        }

        @Override
        public final Builder groupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupNames(String ... groupNames) {
            if (this.groupNames == null) {
                this.groupNames = new SdkInternalList(groupNames.length);
            }
            for (String e : groupNames) {
                this.groupNames.add(e);
            }
            return this;
        }

        public final void setGroupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
        }

        @SafeVarargs
        public final void setGroupNames(String ... groupNames) {
            if (this.groupNames == null) {
                this.groupNames = new SdkInternalList(groupNames.length);
            }
            for (String e : groupNames) {
                this.groupNames.add(e);
            }
        }

        public Reservation build() {
            return new Reservation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Reservation> {
        public Builder groups(Collection<GroupIdentifier> var1);

        public Builder groups(GroupIdentifier ... var1);

        public Builder instances(Collection<Instance> var1);

        public Builder instances(Instance ... var1);

        public Builder ownerId(String var1);

        public Builder requesterId(String var1);

        public Builder reservationId(String var1);

        public Builder groupNames(Collection<String> var1);

        public Builder groupNames(String ... var1);
    }
}

