/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.PurchaseRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseRequestSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PurchaseScheduledInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PurchaseScheduledInstancesRequest> {
    private final String clientToken;
    private final List<PurchaseRequest> purchaseRequests;

    private PurchaseScheduledInstancesRequest(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.purchaseRequests = builder.purchaseRequests;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public List<PurchaseRequest> purchaseRequests() {
        return this.purchaseRequests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        hashCode = 31 * hashCode + (this.purchaseRequests() == null ? 0 : this.purchaseRequests().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseScheduledInstancesRequest)) {
            return false;
        }
        PurchaseScheduledInstancesRequest other = (PurchaseScheduledInstancesRequest)((Object)obj);
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.purchaseRequests() == null ^ this.purchaseRequests() == null) {
            return false;
        }
        return other.purchaseRequests() == null || other.purchaseRequests().equals(this.purchaseRequests());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.purchaseRequests() != null) {
            sb.append("PurchaseRequests: ").append(this.purchaseRequests()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clientToken;
        private List<PurchaseRequest> purchaseRequests = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseScheduledInstancesRequest model) {
            this.setClientToken(model.clientToken);
            this.setPurchaseRequests(model.purchaseRequests);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<PurchaseRequest> getPurchaseRequests() {
            return this.purchaseRequests;
        }

        @Override
        public final Builder purchaseRequests(Collection<PurchaseRequest> purchaseRequests) {
            this.purchaseRequests = PurchaseRequestSetCopier.copy(purchaseRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchaseRequests(PurchaseRequest ... purchaseRequests) {
            if (this.purchaseRequests == null) {
                this.purchaseRequests = new SdkInternalList(purchaseRequests.length);
            }
            for (PurchaseRequest e : purchaseRequests) {
                this.purchaseRequests.add(e);
            }
            return this;
        }

        public final void setPurchaseRequests(Collection<PurchaseRequest> purchaseRequests) {
            this.purchaseRequests = PurchaseRequestSetCopier.copy(purchaseRequests);
        }

        @SafeVarargs
        public final void setPurchaseRequests(PurchaseRequest ... purchaseRequests) {
            if (this.purchaseRequests == null) {
                this.purchaseRequests = new SdkInternalList(purchaseRequests.length);
            }
            for (PurchaseRequest e : purchaseRequests) {
                this.purchaseRequests.add(e);
            }
        }

        public PurchaseScheduledInstancesRequest build() {
            return new PurchaseScheduledInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PurchaseScheduledInstancesRequest> {
        public Builder clientToken(String var1);

        public Builder purchaseRequests(Collection<PurchaseRequest> var1);

        public Builder purchaseRequests(PurchaseRequest ... var1);
    }
}

