/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PrefixList
implements ToCopyableBuilder<Builder, PrefixList> {
    private final List<String> cidrs;
    private final String prefixListId;
    private final String prefixListName;

    private PrefixList(BuilderImpl builder) {
        this.cidrs = builder.cidrs;
        this.prefixListId = builder.prefixListId;
        this.prefixListName = builder.prefixListName;
    }

    public List<String> cidrs() {
        return this.cidrs;
    }

    public String prefixListId() {
        return this.prefixListId;
    }

    public String prefixListName() {
        return this.prefixListName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.cidrs() == null ? 0 : this.cidrs().hashCode());
        hashCode = 31 * hashCode + (this.prefixListId() == null ? 0 : this.prefixListId().hashCode());
        hashCode = 31 * hashCode + (this.prefixListName() == null ? 0 : this.prefixListName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrefixList)) {
            return false;
        }
        PrefixList other = (PrefixList)obj;
        if (other.cidrs() == null ^ this.cidrs() == null) {
            return false;
        }
        if (other.cidrs() != null && !other.cidrs().equals(this.cidrs())) {
            return false;
        }
        if (other.prefixListId() == null ^ this.prefixListId() == null) {
            return false;
        }
        if (other.prefixListId() != null && !other.prefixListId().equals(this.prefixListId())) {
            return false;
        }
        if (other.prefixListName() == null ^ this.prefixListName() == null) {
            return false;
        }
        return other.prefixListName() == null || other.prefixListName().equals(this.prefixListName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cidrs() != null) {
            sb.append("Cidrs: ").append(this.cidrs()).append(",");
        }
        if (this.prefixListId() != null) {
            sb.append("PrefixListId: ").append(this.prefixListId()).append(",");
        }
        if (this.prefixListName() != null) {
            sb.append("PrefixListName: ").append(this.prefixListName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> cidrs = new SdkInternalList();
        private String prefixListId;
        private String prefixListName;

        private BuilderImpl() {
        }

        private BuilderImpl(PrefixList model) {
            this.setCidrs(model.cidrs);
            this.setPrefixListId(model.prefixListId);
            this.setPrefixListName(model.prefixListName);
        }

        public final Collection<String> getCidrs() {
            return this.cidrs;
        }

        @Override
        public final Builder cidrs(Collection<String> cidrs) {
            this.cidrs = ValueStringListCopier.copy(cidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrs(String ... cidrs) {
            if (this.cidrs == null) {
                this.cidrs = new SdkInternalList(cidrs.length);
            }
            for (String e : cidrs) {
                this.cidrs.add(e);
            }
            return this;
        }

        public final void setCidrs(Collection<String> cidrs) {
            this.cidrs = ValueStringListCopier.copy(cidrs);
        }

        @SafeVarargs
        public final void setCidrs(String ... cidrs) {
            if (this.cidrs == null) {
                this.cidrs = new SdkInternalList(cidrs.length);
            }
            for (String e : cidrs) {
                this.cidrs.add(e);
            }
        }

        public final String getPrefixListId() {
            return this.prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        public final String getPrefixListName() {
            return this.prefixListName;
        }

        @Override
        public final Builder prefixListName(String prefixListName) {
            this.prefixListName = prefixListName;
            return this;
        }

        public final void setPrefixListName(String prefixListName) {
            this.prefixListName = prefixListName;
        }

        public PrefixList build() {
            return new PrefixList(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PrefixList> {
        public Builder cidrs(Collection<String> var1);

        public Builder cidrs(String ... var1);

        public Builder prefixListId(String var1);

        public Builder prefixListName(String var1);
    }
}

