/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyVpcEndpointRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyVpcEndpointRequest> {
    private final List<String> addRouteTableIds;
    private final String policyDocument;
    private final List<String> removeRouteTableIds;
    private final Boolean resetPolicy;
    private final String vpcEndpointId;

    private ModifyVpcEndpointRequest(BuilderImpl builder) {
        this.addRouteTableIds = builder.addRouteTableIds;
        this.policyDocument = builder.policyDocument;
        this.removeRouteTableIds = builder.removeRouteTableIds;
        this.resetPolicy = builder.resetPolicy;
        this.vpcEndpointId = builder.vpcEndpointId;
    }

    public List<String> addRouteTableIds() {
        return this.addRouteTableIds;
    }

    public String policyDocument() {
        return this.policyDocument;
    }

    public List<String> removeRouteTableIds() {
        return this.removeRouteTableIds;
    }

    public Boolean resetPolicy() {
        return this.resetPolicy;
    }

    public String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.addRouteTableIds() == null ? 0 : this.addRouteTableIds().hashCode());
        hashCode = 31 * hashCode + (this.policyDocument() == null ? 0 : this.policyDocument().hashCode());
        hashCode = 31 * hashCode + (this.removeRouteTableIds() == null ? 0 : this.removeRouteTableIds().hashCode());
        hashCode = 31 * hashCode + (this.resetPolicy() == null ? 0 : this.resetPolicy().hashCode());
        hashCode = 31 * hashCode + (this.vpcEndpointId() == null ? 0 : this.vpcEndpointId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEndpointRequest)) {
            return false;
        }
        ModifyVpcEndpointRequest other = (ModifyVpcEndpointRequest)((Object)obj);
        if (other.addRouteTableIds() == null ^ this.addRouteTableIds() == null) {
            return false;
        }
        if (other.addRouteTableIds() != null && !other.addRouteTableIds().equals(this.addRouteTableIds())) {
            return false;
        }
        if (other.policyDocument() == null ^ this.policyDocument() == null) {
            return false;
        }
        if (other.policyDocument() != null && !other.policyDocument().equals(this.policyDocument())) {
            return false;
        }
        if (other.removeRouteTableIds() == null ^ this.removeRouteTableIds() == null) {
            return false;
        }
        if (other.removeRouteTableIds() != null && !other.removeRouteTableIds().equals(this.removeRouteTableIds())) {
            return false;
        }
        if (other.resetPolicy() == null ^ this.resetPolicy() == null) {
            return false;
        }
        if (other.resetPolicy() != null && !other.resetPolicy().equals(this.resetPolicy())) {
            return false;
        }
        if (other.vpcEndpointId() == null ^ this.vpcEndpointId() == null) {
            return false;
        }
        return other.vpcEndpointId() == null || other.vpcEndpointId().equals(this.vpcEndpointId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addRouteTableIds() != null) {
            sb.append("AddRouteTableIds: ").append(this.addRouteTableIds()).append(",");
        }
        if (this.policyDocument() != null) {
            sb.append("PolicyDocument: ").append(this.policyDocument()).append(",");
        }
        if (this.removeRouteTableIds() != null) {
            sb.append("RemoveRouteTableIds: ").append(this.removeRouteTableIds()).append(",");
        }
        if (this.resetPolicy() != null) {
            sb.append("ResetPolicy: ").append(this.resetPolicy()).append(",");
        }
        if (this.vpcEndpointId() != null) {
            sb.append("VpcEndpointId: ").append(this.vpcEndpointId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> addRouteTableIds = new SdkInternalList();
        private String policyDocument;
        private List<String> removeRouteTableIds = new SdkInternalList();
        private Boolean resetPolicy;
        private String vpcEndpointId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcEndpointRequest model) {
            this.setAddRouteTableIds(model.addRouteTableIds);
            this.setPolicyDocument(model.policyDocument);
            this.setRemoveRouteTableIds(model.removeRouteTableIds);
            this.setResetPolicy(model.resetPolicy);
            this.setVpcEndpointId(model.vpcEndpointId);
        }

        public final Collection<String> getAddRouteTableIds() {
            return this.addRouteTableIds;
        }

        @Override
        public final Builder addRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = ValueStringListCopier.copy(addRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addRouteTableIds(String ... addRouteTableIds) {
            if (this.addRouteTableIds == null) {
                this.addRouteTableIds = new SdkInternalList(addRouteTableIds.length);
            }
            for (String e : addRouteTableIds) {
                this.addRouteTableIds.add(e);
            }
            return this;
        }

        public final void setAddRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = ValueStringListCopier.copy(addRouteTableIds);
        }

        @SafeVarargs
        public final void setAddRouteTableIds(String ... addRouteTableIds) {
            if (this.addRouteTableIds == null) {
                this.addRouteTableIds = new SdkInternalList(addRouteTableIds.length);
            }
            for (String e : addRouteTableIds) {
                this.addRouteTableIds.add(e);
            }
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final Collection<String> getRemoveRouteTableIds() {
            return this.removeRouteTableIds;
        }

        @Override
        public final Builder removeRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = ValueStringListCopier.copy(removeRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeRouteTableIds(String ... removeRouteTableIds) {
            if (this.removeRouteTableIds == null) {
                this.removeRouteTableIds = new SdkInternalList(removeRouteTableIds.length);
            }
            for (String e : removeRouteTableIds) {
                this.removeRouteTableIds.add(e);
            }
            return this;
        }

        public final void setRemoveRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = ValueStringListCopier.copy(removeRouteTableIds);
        }

        @SafeVarargs
        public final void setRemoveRouteTableIds(String ... removeRouteTableIds) {
            if (this.removeRouteTableIds == null) {
                this.removeRouteTableIds = new SdkInternalList(removeRouteTableIds.length);
            }
            for (String e : removeRouteTableIds) {
                this.removeRouteTableIds.add(e);
            }
        }

        public final Boolean getResetPolicy() {
            return this.resetPolicy;
        }

        @Override
        public final Builder resetPolicy(Boolean resetPolicy) {
            this.resetPolicy = resetPolicy;
            return this;
        }

        public final void setResetPolicy(Boolean resetPolicy) {
            this.resetPolicy = resetPolicy;
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        public ModifyVpcEndpointRequest build() {
            return new ModifyVpcEndpointRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyVpcEndpointRequest> {
        public Builder addRouteTableIds(Collection<String> var1);

        public Builder addRouteTableIds(String ... var1);

        public Builder policyDocument(String var1);

        public Builder removeRouteTableIds(Collection<String> var1);

        public Builder removeRouteTableIds(String ... var1);

        public Builder resetPolicy(Boolean var1);

        public Builder vpcEndpointId(String var1);
    }
}

