/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.ResponseHostIdListCopier;
import software.amazon.awssdk.services.ec2.model.UnsuccessfulItem;
import software.amazon.awssdk.services.ec2.model.UnsuccessfulItemListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyHostsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ModifyHostsResponse> {
    private final List<String> successful;
    private final List<UnsuccessfulItem> unsuccessful;

    private ModifyHostsResponse(BuilderImpl builder) {
        this.successful = builder.successful;
        this.unsuccessful = builder.unsuccessful;
    }

    public List<String> successful() {
        return this.successful;
    }

    public List<UnsuccessfulItem> unsuccessful() {
        return this.unsuccessful;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.successful() == null ? 0 : this.successful().hashCode());
        hashCode = 31 * hashCode + (this.unsuccessful() == null ? 0 : this.unsuccessful().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyHostsResponse)) {
            return false;
        }
        ModifyHostsResponse other = (ModifyHostsResponse)((Object)obj);
        if (other.successful() == null ^ this.successful() == null) {
            return false;
        }
        if (other.successful() != null && !other.successful().equals(this.successful())) {
            return false;
        }
        if (other.unsuccessful() == null ^ this.unsuccessful() == null) {
            return false;
        }
        return other.unsuccessful() == null || other.unsuccessful().equals(this.unsuccessful());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.successful() != null) {
            sb.append("Successful: ").append(this.successful()).append(",");
        }
        if (this.unsuccessful() != null) {
            sb.append("Unsuccessful: ").append(this.unsuccessful()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> successful = new SdkInternalList();
        private List<UnsuccessfulItem> unsuccessful = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyHostsResponse model) {
            this.setSuccessful(model.successful);
            this.setUnsuccessful(model.unsuccessful);
        }

        public final Collection<String> getSuccessful() {
            return this.successful;
        }

        @Override
        public final Builder successful(Collection<String> successful) {
            this.successful = ResponseHostIdListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(String ... successful) {
            if (this.successful == null) {
                this.successful = new SdkInternalList(successful.length);
            }
            for (String e : successful) {
                this.successful.add(e);
            }
            return this;
        }

        public final void setSuccessful(Collection<String> successful) {
            this.successful = ResponseHostIdListCopier.copy(successful);
        }

        @SafeVarargs
        public final void setSuccessful(String ... successful) {
            if (this.successful == null) {
                this.successful = new SdkInternalList(successful.length);
            }
            for (String e : successful) {
                this.successful.add(e);
            }
        }

        public final Collection<UnsuccessfulItem> getUnsuccessful() {
            return this.unsuccessful;
        }

        @Override
        public final Builder unsuccessful(Collection<UnsuccessfulItem> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemListCopier.copy(unsuccessful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(UnsuccessfulItem ... unsuccessful) {
            if (this.unsuccessful == null) {
                this.unsuccessful = new SdkInternalList(unsuccessful.length);
            }
            for (UnsuccessfulItem e : unsuccessful) {
                this.unsuccessful.add(e);
            }
            return this;
        }

        public final void setUnsuccessful(Collection<UnsuccessfulItem> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemListCopier.copy(unsuccessful);
        }

        @SafeVarargs
        public final void setUnsuccessful(UnsuccessfulItem ... unsuccessful) {
            if (this.unsuccessful == null) {
                this.unsuccessful = new SdkInternalList(unsuccessful.length);
            }
            for (UnsuccessfulItem e : unsuccessful) {
                this.unsuccessful.add(e);
            }
        }

        public ModifyHostsResponse build() {
            return new ModifyHostsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyHostsResponse> {
        public Builder successful(Collection<String> var1);

        public Builder successful(String ... var1);

        public Builder unsuccessful(Collection<UnsuccessfulItem> var1);

        public Builder unsuccessful(UnsuccessfulItem ... var1);
    }
}

