/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.ClientData;
import software.amazon.awssdk.services.ec2.model.SnapshotDiskContainer;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportSnapshotRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ImportSnapshotRequest> {
    private final ClientData clientData;
    private final String clientToken;
    private final String description;
    private final SnapshotDiskContainer diskContainer;
    private final String roleName;

    private ImportSnapshotRequest(BuilderImpl builder) {
        this.clientData = builder.clientData;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.diskContainer = builder.diskContainer;
        this.roleName = builder.roleName;
    }

    public ClientData clientData() {
        return this.clientData;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String description() {
        return this.description;
    }

    public SnapshotDiskContainer diskContainer() {
        return this.diskContainer;
    }

    public String roleName() {
        return this.roleName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clientData() == null ? 0 : this.clientData().hashCode());
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.diskContainer() == null ? 0 : this.diskContainer().hashCode());
        hashCode = 31 * hashCode + (this.roleName() == null ? 0 : this.roleName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSnapshotRequest)) {
            return false;
        }
        ImportSnapshotRequest other = (ImportSnapshotRequest)((Object)obj);
        if (other.clientData() == null ^ this.clientData() == null) {
            return false;
        }
        if (other.clientData() != null && !other.clientData().equals(this.clientData())) {
            return false;
        }
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.diskContainer() == null ^ this.diskContainer() == null) {
            return false;
        }
        if (other.diskContainer() != null && !other.diskContainer().equals(this.diskContainer())) {
            return false;
        }
        if (other.roleName() == null ^ this.roleName() == null) {
            return false;
        }
        return other.roleName() == null || other.roleName().equals(this.roleName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientData() != null) {
            sb.append("ClientData: ").append(this.clientData()).append(",");
        }
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.diskContainer() != null) {
            sb.append("DiskContainer: ").append(this.diskContainer()).append(",");
        }
        if (this.roleName() != null) {
            sb.append("RoleName: ").append(this.roleName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private ClientData clientData;
        private String clientToken;
        private String description;
        private SnapshotDiskContainer diskContainer;
        private String roleName;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportSnapshotRequest model) {
            this.setClientData(model.clientData);
            this.setClientToken(model.clientToken);
            this.setDescription(model.description);
            this.setDiskContainer(model.diskContainer);
            this.setRoleName(model.roleName);
        }

        public final ClientData getClientData() {
            return this.clientData;
        }

        @Override
        public final Builder clientData(ClientData clientData) {
            this.clientData = clientData;
            return this;
        }

        public final void setClientData(ClientData clientData) {
            this.clientData = clientData;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final SnapshotDiskContainer getDiskContainer() {
            return this.diskContainer;
        }

        @Override
        public final Builder diskContainer(SnapshotDiskContainer diskContainer) {
            this.diskContainer = diskContainer;
            return this;
        }

        public final void setDiskContainer(SnapshotDiskContainer diskContainer) {
            this.diskContainer = diskContainer;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public ImportSnapshotRequest build() {
            return new ImportSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImportSnapshotRequest> {
        public Builder clientData(ClientData var1);

        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder diskContainer(SnapshotDiskContainer var1);

        public Builder roleName(String var1);
    }
}

