/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.ClientData;
import software.amazon.awssdk.services.ec2.model.ImageDiskContainer;
import software.amazon.awssdk.services.ec2.model.ImageDiskContainerListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportImageRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ImportImageRequest> {
    private final String architecture;
    private final ClientData clientData;
    private final String clientToken;
    private final String description;
    private final List<ImageDiskContainer> diskContainers;
    private final String hypervisor;
    private final String licenseType;
    private final String platform;
    private final String roleName;

    private ImportImageRequest(BuilderImpl builder) {
        this.architecture = builder.architecture;
        this.clientData = builder.clientData;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.diskContainers = builder.diskContainers;
        this.hypervisor = builder.hypervisor;
        this.licenseType = builder.licenseType;
        this.platform = builder.platform;
        this.roleName = builder.roleName;
    }

    public String architecture() {
        return this.architecture;
    }

    public ClientData clientData() {
        return this.clientData;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String description() {
        return this.description;
    }

    public List<ImageDiskContainer> diskContainers() {
        return this.diskContainers;
    }

    public String hypervisor() {
        return this.hypervisor;
    }

    public String licenseType() {
        return this.licenseType;
    }

    public String platform() {
        return this.platform;
    }

    public String roleName() {
        return this.roleName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.architecture() == null ? 0 : this.architecture().hashCode());
        hashCode = 31 * hashCode + (this.clientData() == null ? 0 : this.clientData().hashCode());
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.diskContainers() == null ? 0 : this.diskContainers().hashCode());
        hashCode = 31 * hashCode + (this.hypervisor() == null ? 0 : this.hypervisor().hashCode());
        hashCode = 31 * hashCode + (this.licenseType() == null ? 0 : this.licenseType().hashCode());
        hashCode = 31 * hashCode + (this.platform() == null ? 0 : this.platform().hashCode());
        hashCode = 31 * hashCode + (this.roleName() == null ? 0 : this.roleName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportImageRequest)) {
            return false;
        }
        ImportImageRequest other = (ImportImageRequest)((Object)obj);
        if (other.architecture() == null ^ this.architecture() == null) {
            return false;
        }
        if (other.architecture() != null && !other.architecture().equals(this.architecture())) {
            return false;
        }
        if (other.clientData() == null ^ this.clientData() == null) {
            return false;
        }
        if (other.clientData() != null && !other.clientData().equals(this.clientData())) {
            return false;
        }
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.diskContainers() == null ^ this.diskContainers() == null) {
            return false;
        }
        if (other.diskContainers() != null && !other.diskContainers().equals(this.diskContainers())) {
            return false;
        }
        if (other.hypervisor() == null ^ this.hypervisor() == null) {
            return false;
        }
        if (other.hypervisor() != null && !other.hypervisor().equals(this.hypervisor())) {
            return false;
        }
        if (other.licenseType() == null ^ this.licenseType() == null) {
            return false;
        }
        if (other.licenseType() != null && !other.licenseType().equals(this.licenseType())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        if (other.platform() != null && !other.platform().equals(this.platform())) {
            return false;
        }
        if (other.roleName() == null ^ this.roleName() == null) {
            return false;
        }
        return other.roleName() == null || other.roleName().equals(this.roleName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.architecture() != null) {
            sb.append("Architecture: ").append(this.architecture()).append(",");
        }
        if (this.clientData() != null) {
            sb.append("ClientData: ").append(this.clientData()).append(",");
        }
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.diskContainers() != null) {
            sb.append("DiskContainers: ").append(this.diskContainers()).append(",");
        }
        if (this.hypervisor() != null) {
            sb.append("Hypervisor: ").append(this.hypervisor()).append(",");
        }
        if (this.licenseType() != null) {
            sb.append("LicenseType: ").append(this.licenseType()).append(",");
        }
        if (this.platform() != null) {
            sb.append("Platform: ").append(this.platform()).append(",");
        }
        if (this.roleName() != null) {
            sb.append("RoleName: ").append(this.roleName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String architecture;
        private ClientData clientData;
        private String clientToken;
        private String description;
        private List<ImageDiskContainer> diskContainers = new SdkInternalList();
        private String hypervisor;
        private String licenseType;
        private String platform;
        private String roleName;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportImageRequest model) {
            this.setArchitecture(model.architecture);
            this.setClientData(model.clientData);
            this.setClientToken(model.clientToken);
            this.setDescription(model.description);
            this.setDiskContainers(model.diskContainers);
            this.setHypervisor(model.hypervisor);
            this.setLicenseType(model.licenseType);
            this.setPlatform(model.platform);
            this.setRoleName(model.roleName);
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final ClientData getClientData() {
            return this.clientData;
        }

        @Override
        public final Builder clientData(ClientData clientData) {
            this.clientData = clientData;
            return this;
        }

        public final void setClientData(ClientData clientData) {
            this.clientData = clientData;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<ImageDiskContainer> getDiskContainers() {
            return this.diskContainers;
        }

        @Override
        public final Builder diskContainers(Collection<ImageDiskContainer> diskContainers) {
            this.diskContainers = ImageDiskContainerListCopier.copy(diskContainers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskContainers(ImageDiskContainer ... diskContainers) {
            if (this.diskContainers == null) {
                this.diskContainers = new SdkInternalList(diskContainers.length);
            }
            for (ImageDiskContainer e : diskContainers) {
                this.diskContainers.add(e);
            }
            return this;
        }

        public final void setDiskContainers(Collection<ImageDiskContainer> diskContainers) {
            this.diskContainers = ImageDiskContainerListCopier.copy(diskContainers);
        }

        @SafeVarargs
        public final void setDiskContainers(ImageDiskContainer ... diskContainers) {
            if (this.diskContainers == null) {
                this.diskContainers = new SdkInternalList(diskContainers.length);
            }
            for (ImageDiskContainer e : diskContainers) {
                this.diskContainers.add(e);
            }
        }

        public final String getHypervisor() {
            return this.hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        public final String getLicenseType() {
            return this.licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public ImportImageRequest build() {
            return new ImportImageRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImportImageRequest> {
        public Builder architecture(String var1);

        public Builder clientData(ClientData var1);

        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder diskContainers(Collection<ImageDiskContainer> var1);

        public Builder diskContainers(ImageDiskContainer ... var1);

        public Builder hypervisor(String var1);

        public Builder licenseType(String var1);

        public Builder platform(String var1);

        public Builder roleName(String var1);
    }
}

