/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ec2.model.ReservationValue;
import software.amazon.awssdk.services.ec2.model.ReservedInstanceReservationValue;
import software.amazon.awssdk.services.ec2.model.ReservedInstanceReservationValueSetCopier;
import software.amazon.awssdk.services.ec2.model.TargetReservationValue;
import software.amazon.awssdk.services.ec2.model.TargetReservationValueSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetReservedInstancesExchangeQuoteResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetReservedInstancesExchangeQuoteResponse> {
    private final String currencyCode;
    private final Boolean isValidExchange;
    private final Date outputReservedInstancesWillExpireAt;
    private final String paymentDue;
    private final ReservationValue reservedInstanceValueRollup;
    private final List<ReservedInstanceReservationValue> reservedInstanceValueSet;
    private final ReservationValue targetConfigurationValueRollup;
    private final List<TargetReservationValue> targetConfigurationValueSet;
    private final String validationFailureReason;

    private GetReservedInstancesExchangeQuoteResponse(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.isValidExchange = builder.isValidExchange;
        this.outputReservedInstancesWillExpireAt = builder.outputReservedInstancesWillExpireAt;
        this.paymentDue = builder.paymentDue;
        this.reservedInstanceValueRollup = builder.reservedInstanceValueRollup;
        this.reservedInstanceValueSet = builder.reservedInstanceValueSet;
        this.targetConfigurationValueRollup = builder.targetConfigurationValueRollup;
        this.targetConfigurationValueSet = builder.targetConfigurationValueSet;
        this.validationFailureReason = builder.validationFailureReason;
    }

    public String currencyCode() {
        return this.currencyCode;
    }

    public Boolean isValidExchange() {
        return this.isValidExchange;
    }

    public Date outputReservedInstancesWillExpireAt() {
        return this.outputReservedInstancesWillExpireAt;
    }

    public String paymentDue() {
        return this.paymentDue;
    }

    public ReservationValue reservedInstanceValueRollup() {
        return this.reservedInstanceValueRollup;
    }

    public List<ReservedInstanceReservationValue> reservedInstanceValueSet() {
        return this.reservedInstanceValueSet;
    }

    public ReservationValue targetConfigurationValueRollup() {
        return this.targetConfigurationValueRollup;
    }

    public List<TargetReservationValue> targetConfigurationValueSet() {
        return this.targetConfigurationValueSet;
    }

    public String validationFailureReason() {
        return this.validationFailureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.currencyCode() == null ? 0 : this.currencyCode().hashCode());
        hashCode = 31 * hashCode + (this.isValidExchange() == null ? 0 : this.isValidExchange().hashCode());
        hashCode = 31 * hashCode + (this.outputReservedInstancesWillExpireAt() == null ? 0 : this.outputReservedInstancesWillExpireAt().hashCode());
        hashCode = 31 * hashCode + (this.paymentDue() == null ? 0 : this.paymentDue().hashCode());
        hashCode = 31 * hashCode + (this.reservedInstanceValueRollup() == null ? 0 : this.reservedInstanceValueRollup().hashCode());
        hashCode = 31 * hashCode + (this.reservedInstanceValueSet() == null ? 0 : this.reservedInstanceValueSet().hashCode());
        hashCode = 31 * hashCode + (this.targetConfigurationValueRollup() == null ? 0 : this.targetConfigurationValueRollup().hashCode());
        hashCode = 31 * hashCode + (this.targetConfigurationValueSet() == null ? 0 : this.targetConfigurationValueSet().hashCode());
        hashCode = 31 * hashCode + (this.validationFailureReason() == null ? 0 : this.validationFailureReason().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservedInstancesExchangeQuoteResponse)) {
            return false;
        }
        GetReservedInstancesExchangeQuoteResponse other = (GetReservedInstancesExchangeQuoteResponse)((Object)obj);
        if (other.currencyCode() == null ^ this.currencyCode() == null) {
            return false;
        }
        if (other.currencyCode() != null && !other.currencyCode().equals(this.currencyCode())) {
            return false;
        }
        if (other.isValidExchange() == null ^ this.isValidExchange() == null) {
            return false;
        }
        if (other.isValidExchange() != null && !other.isValidExchange().equals(this.isValidExchange())) {
            return false;
        }
        if (other.outputReservedInstancesWillExpireAt() == null ^ this.outputReservedInstancesWillExpireAt() == null) {
            return false;
        }
        if (other.outputReservedInstancesWillExpireAt() != null && !other.outputReservedInstancesWillExpireAt().equals(this.outputReservedInstancesWillExpireAt())) {
            return false;
        }
        if (other.paymentDue() == null ^ this.paymentDue() == null) {
            return false;
        }
        if (other.paymentDue() != null && !other.paymentDue().equals(this.paymentDue())) {
            return false;
        }
        if (other.reservedInstanceValueRollup() == null ^ this.reservedInstanceValueRollup() == null) {
            return false;
        }
        if (other.reservedInstanceValueRollup() != null && !other.reservedInstanceValueRollup().equals(this.reservedInstanceValueRollup())) {
            return false;
        }
        if (other.reservedInstanceValueSet() == null ^ this.reservedInstanceValueSet() == null) {
            return false;
        }
        if (other.reservedInstanceValueSet() != null && !other.reservedInstanceValueSet().equals(this.reservedInstanceValueSet())) {
            return false;
        }
        if (other.targetConfigurationValueRollup() == null ^ this.targetConfigurationValueRollup() == null) {
            return false;
        }
        if (other.targetConfigurationValueRollup() != null && !other.targetConfigurationValueRollup().equals(this.targetConfigurationValueRollup())) {
            return false;
        }
        if (other.targetConfigurationValueSet() == null ^ this.targetConfigurationValueSet() == null) {
            return false;
        }
        if (other.targetConfigurationValueSet() != null && !other.targetConfigurationValueSet().equals(this.targetConfigurationValueSet())) {
            return false;
        }
        if (other.validationFailureReason() == null ^ this.validationFailureReason() == null) {
            return false;
        }
        return other.validationFailureReason() == null || other.validationFailureReason().equals(this.validationFailureReason());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.currencyCode() != null) {
            sb.append("CurrencyCode: ").append(this.currencyCode()).append(",");
        }
        if (this.isValidExchange() != null) {
            sb.append("IsValidExchange: ").append(this.isValidExchange()).append(",");
        }
        if (this.outputReservedInstancesWillExpireAt() != null) {
            sb.append("OutputReservedInstancesWillExpireAt: ").append(this.outputReservedInstancesWillExpireAt()).append(",");
        }
        if (this.paymentDue() != null) {
            sb.append("PaymentDue: ").append(this.paymentDue()).append(",");
        }
        if (this.reservedInstanceValueRollup() != null) {
            sb.append("ReservedInstanceValueRollup: ").append(this.reservedInstanceValueRollup()).append(",");
        }
        if (this.reservedInstanceValueSet() != null) {
            sb.append("ReservedInstanceValueSet: ").append(this.reservedInstanceValueSet()).append(",");
        }
        if (this.targetConfigurationValueRollup() != null) {
            sb.append("TargetConfigurationValueRollup: ").append(this.targetConfigurationValueRollup()).append(",");
        }
        if (this.targetConfigurationValueSet() != null) {
            sb.append("TargetConfigurationValueSet: ").append(this.targetConfigurationValueSet()).append(",");
        }
        if (this.validationFailureReason() != null) {
            sb.append("ValidationFailureReason: ").append(this.validationFailureReason()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String currencyCode;
        private Boolean isValidExchange;
        private Date outputReservedInstancesWillExpireAt;
        private String paymentDue;
        private ReservationValue reservedInstanceValueRollup;
        private List<ReservedInstanceReservationValue> reservedInstanceValueSet = new SdkInternalList();
        private ReservationValue targetConfigurationValueRollup;
        private List<TargetReservationValue> targetConfigurationValueSet = new SdkInternalList();
        private String validationFailureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservedInstancesExchangeQuoteResponse model) {
            this.setCurrencyCode(model.currencyCode);
            this.setIsValidExchange(model.isValidExchange);
            this.setOutputReservedInstancesWillExpireAt(model.outputReservedInstancesWillExpireAt);
            this.setPaymentDue(model.paymentDue);
            this.setReservedInstanceValueRollup(model.reservedInstanceValueRollup);
            this.setReservedInstanceValueSet(model.reservedInstanceValueSet);
            this.setTargetConfigurationValueRollup(model.targetConfigurationValueRollup);
            this.setTargetConfigurationValueSet(model.targetConfigurationValueSet);
            this.setValidationFailureReason(model.validationFailureReason);
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Boolean getIsValidExchange() {
            return this.isValidExchange;
        }

        @Override
        public final Builder isValidExchange(Boolean isValidExchange) {
            this.isValidExchange = isValidExchange;
            return this;
        }

        public final void setIsValidExchange(Boolean isValidExchange) {
            this.isValidExchange = isValidExchange;
        }

        public final Date getOutputReservedInstancesWillExpireAt() {
            return this.outputReservedInstancesWillExpireAt;
        }

        @Override
        public final Builder outputReservedInstancesWillExpireAt(Date outputReservedInstancesWillExpireAt) {
            this.outputReservedInstancesWillExpireAt = StandardMemberCopier.copy((Date)outputReservedInstancesWillExpireAt);
            return this;
        }

        public final void setOutputReservedInstancesWillExpireAt(Date outputReservedInstancesWillExpireAt) {
            this.outputReservedInstancesWillExpireAt = StandardMemberCopier.copy((Date)outputReservedInstancesWillExpireAt);
        }

        public final String getPaymentDue() {
            return this.paymentDue;
        }

        @Override
        public final Builder paymentDue(String paymentDue) {
            this.paymentDue = paymentDue;
            return this;
        }

        public final void setPaymentDue(String paymentDue) {
            this.paymentDue = paymentDue;
        }

        public final ReservationValue getReservedInstanceValueRollup() {
            return this.reservedInstanceValueRollup;
        }

        @Override
        public final Builder reservedInstanceValueRollup(ReservationValue reservedInstanceValueRollup) {
            this.reservedInstanceValueRollup = reservedInstanceValueRollup;
            return this;
        }

        public final void setReservedInstanceValueRollup(ReservationValue reservedInstanceValueRollup) {
            this.reservedInstanceValueRollup = reservedInstanceValueRollup;
        }

        public final Collection<ReservedInstanceReservationValue> getReservedInstanceValueSet() {
            return this.reservedInstanceValueSet;
        }

        @Override
        public final Builder reservedInstanceValueSet(Collection<ReservedInstanceReservationValue> reservedInstanceValueSet) {
            this.reservedInstanceValueSet = ReservedInstanceReservationValueSetCopier.copy(reservedInstanceValueSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstanceValueSet(ReservedInstanceReservationValue ... reservedInstanceValueSet) {
            if (this.reservedInstanceValueSet == null) {
                this.reservedInstanceValueSet = new SdkInternalList(reservedInstanceValueSet.length);
            }
            for (ReservedInstanceReservationValue e : reservedInstanceValueSet) {
                this.reservedInstanceValueSet.add(e);
            }
            return this;
        }

        public final void setReservedInstanceValueSet(Collection<ReservedInstanceReservationValue> reservedInstanceValueSet) {
            this.reservedInstanceValueSet = ReservedInstanceReservationValueSetCopier.copy(reservedInstanceValueSet);
        }

        @SafeVarargs
        public final void setReservedInstanceValueSet(ReservedInstanceReservationValue ... reservedInstanceValueSet) {
            if (this.reservedInstanceValueSet == null) {
                this.reservedInstanceValueSet = new SdkInternalList(reservedInstanceValueSet.length);
            }
            for (ReservedInstanceReservationValue e : reservedInstanceValueSet) {
                this.reservedInstanceValueSet.add(e);
            }
        }

        public final ReservationValue getTargetConfigurationValueRollup() {
            return this.targetConfigurationValueRollup;
        }

        @Override
        public final Builder targetConfigurationValueRollup(ReservationValue targetConfigurationValueRollup) {
            this.targetConfigurationValueRollup = targetConfigurationValueRollup;
            return this;
        }

        public final void setTargetConfigurationValueRollup(ReservationValue targetConfigurationValueRollup) {
            this.targetConfigurationValueRollup = targetConfigurationValueRollup;
        }

        public final Collection<TargetReservationValue> getTargetConfigurationValueSet() {
            return this.targetConfigurationValueSet;
        }

        @Override
        public final Builder targetConfigurationValueSet(Collection<TargetReservationValue> targetConfigurationValueSet) {
            this.targetConfigurationValueSet = TargetReservationValueSetCopier.copy(targetConfigurationValueSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurationValueSet(TargetReservationValue ... targetConfigurationValueSet) {
            if (this.targetConfigurationValueSet == null) {
                this.targetConfigurationValueSet = new SdkInternalList(targetConfigurationValueSet.length);
            }
            for (TargetReservationValue e : targetConfigurationValueSet) {
                this.targetConfigurationValueSet.add(e);
            }
            return this;
        }

        public final void setTargetConfigurationValueSet(Collection<TargetReservationValue> targetConfigurationValueSet) {
            this.targetConfigurationValueSet = TargetReservationValueSetCopier.copy(targetConfigurationValueSet);
        }

        @SafeVarargs
        public final void setTargetConfigurationValueSet(TargetReservationValue ... targetConfigurationValueSet) {
            if (this.targetConfigurationValueSet == null) {
                this.targetConfigurationValueSet = new SdkInternalList(targetConfigurationValueSet.length);
            }
            for (TargetReservationValue e : targetConfigurationValueSet) {
                this.targetConfigurationValueSet.add(e);
            }
        }

        public final String getValidationFailureReason() {
            return this.validationFailureReason;
        }

        @Override
        public final Builder validationFailureReason(String validationFailureReason) {
            this.validationFailureReason = validationFailureReason;
            return this;
        }

        public final void setValidationFailureReason(String validationFailureReason) {
            this.validationFailureReason = validationFailureReason;
        }

        public GetReservedInstancesExchangeQuoteResponse build() {
            return new GetReservedInstancesExchangeQuoteResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetReservedInstancesExchangeQuoteResponse> {
        public Builder currencyCode(String var1);

        public Builder isValidExchange(Boolean var1);

        public Builder outputReservedInstancesWillExpireAt(Date var1);

        public Builder paymentDue(String var1);

        public Builder reservedInstanceValueRollup(ReservationValue var1);

        public Builder reservedInstanceValueSet(Collection<ReservedInstanceReservationValue> var1);

        public Builder reservedInstanceValueSet(ReservedInstanceReservationValue ... var1);

        public Builder targetConfigurationValueRollup(ReservationValue var1);

        public Builder targetConfigurationValueSet(Collection<TargetReservationValue> var1);

        public Builder targetConfigurationValueSet(TargetReservationValue ... var1);

        public Builder validationFailureReason(String var1);
    }
}

