/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.services.ec2.model.ContainerFormat;
import software.amazon.awssdk.services.ec2.model.DiskImageFormat;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ExportToS3Task
implements ToCopyableBuilder<Builder, ExportToS3Task> {
    private final String containerFormat;
    private final String diskImageFormat;
    private final String s3Bucket;
    private final String s3Key;

    private ExportToS3Task(BuilderImpl builder) {
        this.containerFormat = builder.containerFormat;
        this.diskImageFormat = builder.diskImageFormat;
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
    }

    public String containerFormat() {
        return this.containerFormat;
    }

    public String diskImageFormat() {
        return this.diskImageFormat;
    }

    public String s3Bucket() {
        return this.s3Bucket;
    }

    public String s3Key() {
        return this.s3Key;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.containerFormat() == null ? 0 : this.containerFormat().hashCode());
        hashCode = 31 * hashCode + (this.diskImageFormat() == null ? 0 : this.diskImageFormat().hashCode());
        hashCode = 31 * hashCode + (this.s3Bucket() == null ? 0 : this.s3Bucket().hashCode());
        hashCode = 31 * hashCode + (this.s3Key() == null ? 0 : this.s3Key().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportToS3Task)) {
            return false;
        }
        ExportToS3Task other = (ExportToS3Task)obj;
        if (other.containerFormat() == null ^ this.containerFormat() == null) {
            return false;
        }
        if (other.containerFormat() != null && !other.containerFormat().equals(this.containerFormat())) {
            return false;
        }
        if (other.diskImageFormat() == null ^ this.diskImageFormat() == null) {
            return false;
        }
        if (other.diskImageFormat() != null && !other.diskImageFormat().equals(this.diskImageFormat())) {
            return false;
        }
        if (other.s3Bucket() == null ^ this.s3Bucket() == null) {
            return false;
        }
        if (other.s3Bucket() != null && !other.s3Bucket().equals(this.s3Bucket())) {
            return false;
        }
        if (other.s3Key() == null ^ this.s3Key() == null) {
            return false;
        }
        return other.s3Key() == null || other.s3Key().equals(this.s3Key());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.containerFormat() != null) {
            sb.append("ContainerFormat: ").append(this.containerFormat()).append(",");
        }
        if (this.diskImageFormat() != null) {
            sb.append("DiskImageFormat: ").append(this.diskImageFormat()).append(",");
        }
        if (this.s3Bucket() != null) {
            sb.append("S3Bucket: ").append(this.s3Bucket()).append(",");
        }
        if (this.s3Key() != null) {
            sb.append("S3Key: ").append(this.s3Key()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String containerFormat;
        private String diskImageFormat;
        private String s3Bucket;
        private String s3Key;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportToS3Task model) {
            this.setContainerFormat(model.containerFormat);
            this.setDiskImageFormat(model.diskImageFormat);
            this.setS3Bucket(model.s3Bucket);
            this.setS3Key(model.s3Key);
        }

        public final String getContainerFormat() {
            return this.containerFormat;
        }

        @Override
        public final Builder containerFormat(String containerFormat) {
            this.containerFormat = containerFormat;
            return this;
        }

        @Override
        public final Builder containerFormat(ContainerFormat containerFormat) {
            this.containerFormat(containerFormat.toString());
            return this;
        }

        public final void setContainerFormat(String containerFormat) {
            this.containerFormat = containerFormat;
        }

        public final void setContainerFormat(ContainerFormat containerFormat) {
            this.containerFormat(containerFormat.toString());
        }

        public final String getDiskImageFormat() {
            return this.diskImageFormat;
        }

        @Override
        public final Builder diskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
            return this;
        }

        @Override
        public final Builder diskImageFormat(DiskImageFormat diskImageFormat) {
            this.diskImageFormat(diskImageFormat.toString());
            return this;
        }

        public final void setDiskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
        }

        public final void setDiskImageFormat(DiskImageFormat diskImageFormat) {
            this.diskImageFormat(diskImageFormat.toString());
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Key() {
            return this.s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        public ExportToS3Task build() {
            return new ExportToS3Task(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExportToS3Task> {
        public Builder containerFormat(String var1);

        public Builder containerFormat(ContainerFormat var1);

        public Builder diskImageFormat(String var1);

        public Builder diskImageFormat(DiskImageFormat var1);

        public Builder s3Bucket(String var1);

        public Builder s3Key(String var1);
    }
}

