/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVpcEndpointServicesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeVpcEndpointServicesResponse> {
    private final String nextToken;
    private final List<String> serviceNames;

    private DescribeVpcEndpointServicesResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.serviceNames = builder.serviceNames;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<String> serviceNames() {
        return this.serviceNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.serviceNames() == null ? 0 : this.serviceNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointServicesResponse)) {
            return false;
        }
        DescribeVpcEndpointServicesResponse other = (DescribeVpcEndpointServicesResponse)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.serviceNames() == null ^ this.serviceNames() == null) {
            return false;
        }
        return other.serviceNames() == null || other.serviceNames().equals(this.serviceNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.serviceNames() != null) {
            sb.append("ServiceNames: ").append(this.serviceNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private List<String> serviceNames = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointServicesResponse model) {
            this.setNextToken(model.nextToken);
            this.setServiceNames(model.serviceNames);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getServiceNames() {
            return this.serviceNames;
        }

        @Override
        public final Builder serviceNames(Collection<String> serviceNames) {
            this.serviceNames = ValueStringListCopier.copy(serviceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceNames(String ... serviceNames) {
            if (this.serviceNames == null) {
                this.serviceNames = new SdkInternalList(serviceNames.length);
            }
            for (String e : serviceNames) {
                this.serviceNames.add(e);
            }
            return this;
        }

        public final void setServiceNames(Collection<String> serviceNames) {
            this.serviceNames = ValueStringListCopier.copy(serviceNames);
        }

        @SafeVarargs
        public final void setServiceNames(String ... serviceNames) {
            if (this.serviceNames == null) {
                this.serviceNames = new SdkInternalList(serviceNames.length);
            }
            for (String e : serviceNames) {
                this.serviceNames.add(e);
            }
        }

        public DescribeVpcEndpointServicesResponse build() {
            return new DescribeVpcEndpointServicesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVpcEndpointServicesResponse> {
        public Builder nextToken(String var1);

        public Builder serviceNames(Collection<String> var1);

        public Builder serviceNames(String ... var1);
    }
}

