/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.VolumeStatusItem;
import software.amazon.awssdk.services.ec2.model.VolumeStatusListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVolumeStatusResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeVolumeStatusResponse> {
    private final String nextToken;
    private final List<VolumeStatusItem> volumeStatuses;

    private DescribeVolumeStatusResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.volumeStatuses = builder.volumeStatuses;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<VolumeStatusItem> volumeStatuses() {
        return this.volumeStatuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.volumeStatuses() == null ? 0 : this.volumeStatuses().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumeStatusResponse)) {
            return false;
        }
        DescribeVolumeStatusResponse other = (DescribeVolumeStatusResponse)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.volumeStatuses() == null ^ this.volumeStatuses() == null) {
            return false;
        }
        return other.volumeStatuses() == null || other.volumeStatuses().equals(this.volumeStatuses());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.volumeStatuses() != null) {
            sb.append("VolumeStatuses: ").append(this.volumeStatuses()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private List<VolumeStatusItem> volumeStatuses = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumeStatusResponse model) {
            this.setNextToken(model.nextToken);
            this.setVolumeStatuses(model.volumeStatuses);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VolumeStatusItem> getVolumeStatuses() {
            return this.volumeStatuses;
        }

        @Override
        public final Builder volumeStatuses(Collection<VolumeStatusItem> volumeStatuses) {
            this.volumeStatuses = VolumeStatusListCopier.copy(volumeStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeStatuses(VolumeStatusItem ... volumeStatuses) {
            if (this.volumeStatuses == null) {
                this.volumeStatuses = new SdkInternalList(volumeStatuses.length);
            }
            for (VolumeStatusItem e : volumeStatuses) {
                this.volumeStatuses.add(e);
            }
            return this;
        }

        public final void setVolumeStatuses(Collection<VolumeStatusItem> volumeStatuses) {
            this.volumeStatuses = VolumeStatusListCopier.copy(volumeStatuses);
        }

        @SafeVarargs
        public final void setVolumeStatuses(VolumeStatusItem ... volumeStatuses) {
            if (this.volumeStatuses == null) {
                this.volumeStatuses = new SdkInternalList(volumeStatuses.length);
            }
            for (VolumeStatusItem e : volumeStatuses) {
                this.volumeStatuses.add(e);
            }
        }

        public DescribeVolumeStatusResponse build() {
            return new DescribeVolumeStatusResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVolumeStatusResponse> {
        public Builder nextToken(String var1);

        public Builder volumeStatuses(Collection<VolumeStatusItem> var1);

        public Builder volumeStatuses(VolumeStatusItem ... var1);
    }
}

