/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.Subnet;
import software.amazon.awssdk.services.ec2.model.SubnetListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSubnetsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeSubnetsResponse> {
    private final List<Subnet> subnets;

    private DescribeSubnetsResponse(BuilderImpl builder) {
        this.subnets = builder.subnets;
    }

    public List<Subnet> subnets() {
        return this.subnets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.subnets() == null ? 0 : this.subnets().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubnetsResponse)) {
            return false;
        }
        DescribeSubnetsResponse other = (DescribeSubnetsResponse)((Object)obj);
        if (other.subnets() == null ^ this.subnets() == null) {
            return false;
        }
        return other.subnets() == null || other.subnets().equals(this.subnets());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.subnets() != null) {
            sb.append("Subnets: ").append(this.subnets()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Subnet> subnets = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubnetsResponse model) {
            this.setSubnets(model.subnets);
        }

        public final Collection<Subnet> getSubnets() {
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Subnet ... subnets) {
            if (this.subnets == null) {
                this.subnets = new SdkInternalList(subnets.length);
            }
            for (Subnet e : subnets) {
                this.subnets.add(e);
            }
            return this;
        }

        public final void setSubnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
        }

        @SafeVarargs
        public final void setSubnets(Subnet ... subnets) {
            if (this.subnets == null) {
                this.subnets = new SdkInternalList(subnets.length);
            }
            for (Subnet e : subnets) {
                this.subnets.add(e);
            }
        }

        public DescribeSubnetsResponse build() {
            return new DescribeSubnetsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSubnetsResponse> {
        public Builder subnets(Collection<Subnet> var1);

        public Builder subnets(Subnet ... var1);
    }
}

