/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.SpotPrice;
import software.amazon.awssdk.services.ec2.model.SpotPriceHistoryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSpotPriceHistoryResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeSpotPriceHistoryResponse> {
    private final String nextToken;
    private final List<SpotPrice> spotPriceHistory;

    private DescribeSpotPriceHistoryResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.spotPriceHistory = builder.spotPriceHistory;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<SpotPrice> spotPriceHistory() {
        return this.spotPriceHistory;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.spotPriceHistory() == null ? 0 : this.spotPriceHistory().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotPriceHistoryResponse)) {
            return false;
        }
        DescribeSpotPriceHistoryResponse other = (DescribeSpotPriceHistoryResponse)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.spotPriceHistory() == null ^ this.spotPriceHistory() == null) {
            return false;
        }
        return other.spotPriceHistory() == null || other.spotPriceHistory().equals(this.spotPriceHistory());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.spotPriceHistory() != null) {
            sb.append("SpotPriceHistory: ").append(this.spotPriceHistory()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SpotPrice> spotPriceHistory = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotPriceHistoryResponse model) {
            this.setNextToken(model.nextToken);
            this.setSpotPriceHistory(model.spotPriceHistory);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<SpotPrice> getSpotPriceHistory() {
            return this.spotPriceHistory;
        }

        @Override
        public final Builder spotPriceHistory(Collection<SpotPrice> spotPriceHistory) {
            this.spotPriceHistory = SpotPriceHistoryListCopier.copy(spotPriceHistory);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotPriceHistory(SpotPrice ... spotPriceHistory) {
            if (this.spotPriceHistory == null) {
                this.spotPriceHistory = new SdkInternalList(spotPriceHistory.length);
            }
            for (SpotPrice e : spotPriceHistory) {
                this.spotPriceHistory.add(e);
            }
            return this;
        }

        public final void setSpotPriceHistory(Collection<SpotPrice> spotPriceHistory) {
            this.spotPriceHistory = SpotPriceHistoryListCopier.copy(spotPriceHistory);
        }

        @SafeVarargs
        public final void setSpotPriceHistory(SpotPrice ... spotPriceHistory) {
            if (this.spotPriceHistory == null) {
                this.spotPriceHistory = new SdkInternalList(spotPriceHistory.length);
            }
            for (SpotPrice e : spotPriceHistory) {
                this.spotPriceHistory.add(e);
            }
        }

        public DescribeSpotPriceHistoryResponse build() {
            return new DescribeSpotPriceHistoryResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSpotPriceHistoryResponse> {
        public Builder nextToken(String var1);

        public Builder spotPriceHistory(Collection<SpotPrice> var1);

        public Builder spotPriceHistory(SpotPrice ... var1);
    }
}

