/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.InstanceTypeListCopier;
import software.amazon.awssdk.services.ec2.model.ProductDescriptionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSpotPriceHistoryRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeSpotPriceHistoryRequest> {
    private final List<Filter> filters;
    private final String availabilityZone;
    private final Date endTime;
    private final List<String> instanceTypes;
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> productDescriptions;
    private final Date startTime;

    private DescribeSpotPriceHistoryRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.availabilityZone = builder.availabilityZone;
        this.endTime = builder.endTime;
        this.instanceTypes = builder.instanceTypes;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.productDescriptions = builder.productDescriptions;
        this.startTime = builder.startTime;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Date endTime() {
        return this.endTime;
    }

    public List<String> instanceTypes() {
        return this.instanceTypes;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<String> productDescriptions() {
        return this.productDescriptions;
    }

    public Date startTime() {
        return this.startTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.instanceTypes() == null ? 0 : this.instanceTypes().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.productDescriptions() == null ? 0 : this.productDescriptions().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotPriceHistoryRequest)) {
            return false;
        }
        DescribeSpotPriceHistoryRequest other = (DescribeSpotPriceHistoryRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.instanceTypes() == null ^ this.instanceTypes() == null) {
            return false;
        }
        if (other.instanceTypes() != null && !other.instanceTypes().equals(this.instanceTypes())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.productDescriptions() == null ^ this.productDescriptions() == null) {
            return false;
        }
        if (other.productDescriptions() != null && !other.productDescriptions().equals(this.productDescriptions())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        return other.startTime() == null || other.startTime().equals(this.startTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.instanceTypes() != null) {
            sb.append("InstanceTypes: ").append(this.instanceTypes()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.productDescriptions() != null) {
            sb.append("ProductDescriptions: ").append(this.productDescriptions()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Filter> filters = new SdkInternalList();
        private String availabilityZone;
        private Date endTime;
        private List<String> instanceTypes = new SdkInternalList();
        private Integer maxResults;
        private String nextToken;
        private List<String> productDescriptions = new SdkInternalList();
        private Date startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotPriceHistoryRequest model) {
            this.setFilters(model.filters);
            this.setAvailabilityZone(model.availabilityZone);
            this.setEndTime(model.endTime);
            this.setInstanceTypes(model.instanceTypes);
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
            this.setProductDescriptions(model.productDescriptions);
            this.setStartTime(model.startTime);
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            if (this.filters == null) {
                this.filters = new SdkInternalList(filters.length);
            }
            for (Filter e : filters) {
                this.filters.add(e);
            }
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter ... filters) {
            if (this.filters == null) {
                this.filters = new SdkInternalList(filters.length);
            }
            for (Filter e : filters) {
                this.filters.add(e);
            }
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Date getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy((Date)endTime);
            return this;
        }

        public final void setEndTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy((Date)endTime);
        }

        public final Collection<String> getInstanceTypes() {
            return this.instanceTypes;
        }

        @Override
        public final Builder instanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = InstanceTypeListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(String ... instanceTypes) {
            if (this.instanceTypes == null) {
                this.instanceTypes = new SdkInternalList(instanceTypes.length);
            }
            for (String e : instanceTypes) {
                this.instanceTypes.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(InstanceType ... instanceTypes) {
            if (this.instanceTypes == null) {
                this.instanceTypes = new SdkInternalList(instanceTypes.length);
            }
            for (InstanceType ele : instanceTypes) {
                this.instanceTypes.add(ele.toString());
            }
            return this;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = InstanceTypeListCopier.copy(instanceTypes);
        }

        @SafeVarargs
        public final void setInstanceTypes(String ... instanceTypes) {
            if (this.instanceTypes == null) {
                this.instanceTypes = new SdkInternalList(instanceTypes.length);
            }
            for (String e : instanceTypes) {
                this.instanceTypes.add(e);
            }
        }

        @SafeVarargs
        public final void setInstanceTypes(InstanceType ... instanceTypes) {
            if (this.instanceTypes == null) {
                this.instanceTypes = new SdkInternalList(instanceTypes.length);
            }
            for (InstanceType ele : instanceTypes) {
                this.instanceTypes.add(ele.toString());
            }
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getProductDescriptions() {
            return this.productDescriptions;
        }

        @Override
        public final Builder productDescriptions(Collection<String> productDescriptions) {
            this.productDescriptions = ProductDescriptionListCopier.copy(productDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productDescriptions(String ... productDescriptions) {
            if (this.productDescriptions == null) {
                this.productDescriptions = new SdkInternalList(productDescriptions.length);
            }
            for (String e : productDescriptions) {
                this.productDescriptions.add(e);
            }
            return this;
        }

        public final void setProductDescriptions(Collection<String> productDescriptions) {
            this.productDescriptions = ProductDescriptionListCopier.copy(productDescriptions);
        }

        @SafeVarargs
        public final void setProductDescriptions(String ... productDescriptions) {
            if (this.productDescriptions == null) {
                this.productDescriptions = new SdkInternalList(productDescriptions.length);
            }
            for (String e : productDescriptions) {
                this.productDescriptions.add(e);
            }
        }

        public final Date getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy((Date)startTime);
            return this;
        }

        public final void setStartTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy((Date)startTime);
        }

        public DescribeSpotPriceHistoryRequest build() {
            return new DescribeSpotPriceHistoryRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSpotPriceHistoryRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder availabilityZone(String var1);

        public Builder endTime(Date var1);

        public Builder instanceTypes(Collection<String> var1);

        public Builder instanceTypes(String ... var1);

        public Builder instanceTypes(InstanceType ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder productDescriptions(Collection<String> var1);

        public Builder productDescriptions(String ... var1);

        public Builder startTime(Date var1);
    }
}

