/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.SecurityGroup;
import software.amazon.awssdk.services.ec2.model.SecurityGroupListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSecurityGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeSecurityGroupsResponse> {
    private final List<SecurityGroup> securityGroups;

    private DescribeSecurityGroupsResponse(BuilderImpl builder) {
        this.securityGroups = builder.securityGroups;
    }

    public List<SecurityGroup> securityGroups() {
        return this.securityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.securityGroups() == null ? 0 : this.securityGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityGroupsResponse)) {
            return false;
        }
        DescribeSecurityGroupsResponse other = (DescribeSecurityGroupsResponse)((Object)obj);
        if (other.securityGroups() == null ^ this.securityGroups() == null) {
            return false;
        }
        return other.securityGroups() == null || other.securityGroups().equals(this.securityGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.securityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.securityGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<SecurityGroup> securityGroups = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecurityGroupsResponse model) {
            this.setSecurityGroups(model.securityGroups);
        }

        public final Collection<SecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<SecurityGroup> securityGroups) {
            this.securityGroups = SecurityGroupListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(SecurityGroup ... securityGroups) {
            if (this.securityGroups == null) {
                this.securityGroups = new SdkInternalList(securityGroups.length);
            }
            for (SecurityGroup e : securityGroups) {
                this.securityGroups.add(e);
            }
            return this;
        }

        public final void setSecurityGroups(Collection<SecurityGroup> securityGroups) {
            this.securityGroups = SecurityGroupListCopier.copy(securityGroups);
        }

        @SafeVarargs
        public final void setSecurityGroups(SecurityGroup ... securityGroups) {
            if (this.securityGroups == null) {
                this.securityGroups = new SdkInternalList(securityGroups.length);
            }
            for (SecurityGroup e : securityGroups) {
                this.securityGroups.add(e);
            }
        }

        public DescribeSecurityGroupsResponse build() {
            return new DescribeSecurityGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSecurityGroupsResponse> {
        public Builder securityGroups(Collection<SecurityGroup> var1);

        public Builder securityGroups(SecurityGroup ... var1);
    }
}

