/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesOffering;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesOfferingListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedInstancesOfferingsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeReservedInstancesOfferingsResponse> {
    private final List<ReservedInstancesOffering> reservedInstancesOfferings;
    private final String nextToken;

    private DescribeReservedInstancesOfferingsResponse(BuilderImpl builder) {
        this.reservedInstancesOfferings = builder.reservedInstancesOfferings;
        this.nextToken = builder.nextToken;
    }

    public List<ReservedInstancesOffering> reservedInstancesOfferings() {
        return this.reservedInstancesOfferings;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.reservedInstancesOfferings() == null ? 0 : this.reservedInstancesOfferings().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesOfferingsResponse)) {
            return false;
        }
        DescribeReservedInstancesOfferingsResponse other = (DescribeReservedInstancesOfferingsResponse)((Object)obj);
        if (other.reservedInstancesOfferings() == null ^ this.reservedInstancesOfferings() == null) {
            return false;
        }
        if (other.reservedInstancesOfferings() != null && !other.reservedInstancesOfferings().equals(this.reservedInstancesOfferings())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.reservedInstancesOfferings() != null) {
            sb.append("ReservedInstancesOfferings: ").append(this.reservedInstancesOfferings()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ReservedInstancesOffering> reservedInstancesOfferings = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesOfferingsResponse model) {
            this.setReservedInstancesOfferings(model.reservedInstancesOfferings);
            this.setNextToken(model.nextToken);
        }

        public final Collection<ReservedInstancesOffering> getReservedInstancesOfferings() {
            return this.reservedInstancesOfferings;
        }

        @Override
        public final Builder reservedInstancesOfferings(Collection<ReservedInstancesOffering> reservedInstancesOfferings) {
            this.reservedInstancesOfferings = ReservedInstancesOfferingListCopier.copy(reservedInstancesOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesOfferings(ReservedInstancesOffering ... reservedInstancesOfferings) {
            if (this.reservedInstancesOfferings == null) {
                this.reservedInstancesOfferings = new SdkInternalList(reservedInstancesOfferings.length);
            }
            for (ReservedInstancesOffering e : reservedInstancesOfferings) {
                this.reservedInstancesOfferings.add(e);
            }
            return this;
        }

        public final void setReservedInstancesOfferings(Collection<ReservedInstancesOffering> reservedInstancesOfferings) {
            this.reservedInstancesOfferings = ReservedInstancesOfferingListCopier.copy(reservedInstancesOfferings);
        }

        @SafeVarargs
        public final void setReservedInstancesOfferings(ReservedInstancesOffering ... reservedInstancesOfferings) {
            if (this.reservedInstancesOfferings == null) {
                this.reservedInstancesOfferings = new SdkInternalList(reservedInstancesOfferings.length);
            }
            for (ReservedInstancesOffering e : reservedInstancesOfferings) {
                this.reservedInstancesOfferings.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeReservedInstancesOfferingsResponse build() {
            return new DescribeReservedInstancesOfferingsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeReservedInstancesOfferingsResponse> {
        public Builder reservedInstancesOfferings(Collection<ReservedInstancesOffering> var1);

        public Builder reservedInstancesOfferings(ReservedInstancesOffering ... var1);

        public Builder nextToken(String var1);
    }
}

