/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePrefixListsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribePrefixListsRequest> {
    private final List<Filter> filters;
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> prefixListIds;

    private DescribePrefixListsRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.prefixListIds = builder.prefixListIds;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<String> prefixListIds() {
        return this.prefixListIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.prefixListIds() == null ? 0 : this.prefixListIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePrefixListsRequest)) {
            return false;
        }
        DescribePrefixListsRequest other = (DescribePrefixListsRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.prefixListIds() == null ^ this.prefixListIds() == null) {
            return false;
        }
        return other.prefixListIds() == null || other.prefixListIds().equals(this.prefixListIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.prefixListIds() != null) {
            sb.append("PrefixListIds: ").append(this.prefixListIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Filter> filters = new SdkInternalList();
        private Integer maxResults;
        private String nextToken;
        private List<String> prefixListIds = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePrefixListsRequest model) {
            this.setFilters(model.filters);
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
            this.setPrefixListIds(model.prefixListIds);
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            if (this.filters == null) {
                this.filters = new SdkInternalList(filters.length);
            }
            for (Filter e : filters) {
                this.filters.add(e);
            }
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter ... filters) {
            if (this.filters == null) {
                this.filters = new SdkInternalList(filters.length);
            }
            for (Filter e : filters) {
                this.filters.add(e);
            }
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getPrefixListIds() {
            return this.prefixListIds;
        }

        @Override
        public final Builder prefixListIds(Collection<String> prefixListIds) {
            this.prefixListIds = ValueStringListCopier.copy(prefixListIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixListIds(String ... prefixListIds) {
            if (this.prefixListIds == null) {
                this.prefixListIds = new SdkInternalList(prefixListIds.length);
            }
            for (String e : prefixListIds) {
                this.prefixListIds.add(e);
            }
            return this;
        }

        public final void setPrefixListIds(Collection<String> prefixListIds) {
            this.prefixListIds = ValueStringListCopier.copy(prefixListIds);
        }

        @SafeVarargs
        public final void setPrefixListIds(String ... prefixListIds) {
            if (this.prefixListIds == null) {
                this.prefixListIds = new SdkInternalList(prefixListIds.length);
            }
            for (String e : prefixListIds) {
                this.prefixListIds.add(e);
            }
        }

        public DescribePrefixListsRequest build() {
            return new DescribePrefixListsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribePrefixListsRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder prefixListIds(Collection<String> var1);

        public Builder prefixListIds(String ... var1);
    }
}

