/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeNetworkInterfacesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeNetworkInterfacesRequest> {
    private final List<Filter> filters;
    private final List<String> networkInterfaceIds;

    private DescribeNetworkInterfacesRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.networkInterfaceIds = builder.networkInterfaceIds;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public List<String> networkInterfaceIds() {
        return this.networkInterfaceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.networkInterfaceIds() == null ? 0 : this.networkInterfaceIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInterfacesRequest)) {
            return false;
        }
        DescribeNetworkInterfacesRequest other = (DescribeNetworkInterfacesRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.networkInterfaceIds() == null ^ this.networkInterfaceIds() == null) {
            return false;
        }
        return other.networkInterfaceIds() == null || other.networkInterfaceIds().equals(this.networkInterfaceIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.networkInterfaceIds() != null) {
            sb.append("NetworkInterfaceIds: ").append(this.networkInterfaceIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Filter> filters = new SdkInternalList();
        private List<String> networkInterfaceIds = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInterfacesRequest model) {
            this.setFilters(model.filters);
            this.setNetworkInterfaceIds(model.networkInterfaceIds);
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            if (this.filters == null) {
                this.filters = new SdkInternalList(filters.length);
            }
            for (Filter e : filters) {
                this.filters.add(e);
            }
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter ... filters) {
            if (this.filters == null) {
                this.filters = new SdkInternalList(filters.length);
            }
            for (Filter e : filters) {
                this.filters.add(e);
            }
        }

        public final Collection<String> getNetworkInterfaceIds() {
            return this.networkInterfaceIds;
        }

        @Override
        public final Builder networkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = NetworkInterfaceIdListCopier.copy(networkInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaceIds(String ... networkInterfaceIds) {
            if (this.networkInterfaceIds == null) {
                this.networkInterfaceIds = new SdkInternalList(networkInterfaceIds.length);
            }
            for (String e : networkInterfaceIds) {
                this.networkInterfaceIds.add(e);
            }
            return this;
        }

        public final void setNetworkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = NetworkInterfaceIdListCopier.copy(networkInterfaceIds);
        }

        @SafeVarargs
        public final void setNetworkInterfaceIds(String ... networkInterfaceIds) {
            if (this.networkInterfaceIds == null) {
                this.networkInterfaceIds = new SdkInternalList(networkInterfaceIds.length);
            }
            for (String e : networkInterfaceIds) {
                this.networkInterfaceIds.add(e);
            }
        }

        public DescribeNetworkInterfacesRequest build() {
            return new DescribeNetworkInterfacesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeNetworkInterfacesRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder networkInterfaceIds(Collection<String> var1);

        public Builder networkInterfaceIds(String ... var1);
    }
}

