/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.Reservation;
import software.amazon.awssdk.services.ec2.model.ReservationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstancesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeInstancesResponse> {
    private final List<Reservation> reservations;
    private final String nextToken;

    private DescribeInstancesResponse(BuilderImpl builder) {
        this.reservations = builder.reservations;
        this.nextToken = builder.nextToken;
    }

    public List<Reservation> reservations() {
        return this.reservations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.reservations() == null ? 0 : this.reservations().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesResponse)) {
            return false;
        }
        DescribeInstancesResponse other = (DescribeInstancesResponse)((Object)obj);
        if (other.reservations() == null ^ this.reservations() == null) {
            return false;
        }
        if (other.reservations() != null && !other.reservations().equals(this.reservations())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.reservations() != null) {
            sb.append("Reservations: ").append(this.reservations()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Reservation> reservations = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancesResponse model) {
            this.setReservations(model.reservations);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Reservation> getReservations() {
            return this.reservations;
        }

        @Override
        public final Builder reservations(Collection<Reservation> reservations) {
            this.reservations = ReservationListCopier.copy(reservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservations(Reservation ... reservations) {
            if (this.reservations == null) {
                this.reservations = new SdkInternalList(reservations.length);
            }
            for (Reservation e : reservations) {
                this.reservations.add(e);
            }
            return this;
        }

        public final void setReservations(Collection<Reservation> reservations) {
            this.reservations = ReservationListCopier.copy(reservations);
        }

        @SafeVarargs
        public final void setReservations(Reservation ... reservations) {
            if (this.reservations == null) {
                this.reservations = new SdkInternalList(reservations.length);
            }
            for (Reservation e : reservations) {
                this.reservations.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeInstancesResponse build() {
            return new DescribeInstancesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeInstancesResponse> {
        public Builder reservations(Collection<Reservation> var1);

        public Builder reservations(Reservation ... var1);

        public Builder nextToken(String var1);
    }
}

