/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.FpgaImage;
import software.amazon.awssdk.services.ec2.model.FpgaImageListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeFpgaImagesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeFpgaImagesResponse> {
    private final List<FpgaImage> fpgaImages;
    private final String nextToken;

    private DescribeFpgaImagesResponse(BuilderImpl builder) {
        this.fpgaImages = builder.fpgaImages;
        this.nextToken = builder.nextToken;
    }

    public List<FpgaImage> fpgaImages() {
        return this.fpgaImages;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fpgaImages() == null ? 0 : this.fpgaImages().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFpgaImagesResponse)) {
            return false;
        }
        DescribeFpgaImagesResponse other = (DescribeFpgaImagesResponse)((Object)obj);
        if (other.fpgaImages() == null ^ this.fpgaImages() == null) {
            return false;
        }
        if (other.fpgaImages() != null && !other.fpgaImages().equals(this.fpgaImages())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fpgaImages() != null) {
            sb.append("FpgaImages: ").append(this.fpgaImages()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<FpgaImage> fpgaImages = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFpgaImagesResponse model) {
            this.setFpgaImages(model.fpgaImages);
            this.setNextToken(model.nextToken);
        }

        public final Collection<FpgaImage> getFpgaImages() {
            return this.fpgaImages;
        }

        @Override
        public final Builder fpgaImages(Collection<FpgaImage> fpgaImages) {
            this.fpgaImages = FpgaImageListCopier.copy(fpgaImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fpgaImages(FpgaImage ... fpgaImages) {
            if (this.fpgaImages == null) {
                this.fpgaImages = new SdkInternalList(fpgaImages.length);
            }
            for (FpgaImage e : fpgaImages) {
                this.fpgaImages.add(e);
            }
            return this;
        }

        public final void setFpgaImages(Collection<FpgaImage> fpgaImages) {
            this.fpgaImages = FpgaImageListCopier.copy(fpgaImages);
        }

        @SafeVarargs
        public final void setFpgaImages(FpgaImage ... fpgaImages) {
            if (this.fpgaImages == null) {
                this.fpgaImages = new SdkInternalList(fpgaImages.length);
            }
            for (FpgaImage e : fpgaImages) {
                this.fpgaImages.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeFpgaImagesResponse build() {
            return new DescribeFpgaImagesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeFpgaImagesResponse> {
        public Builder fpgaImages(Collection<FpgaImage> var1);

        public Builder fpgaImages(FpgaImage ... var1);

        public Builder nextToken(String var1);
    }
}

