/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.FpgaImageIdListCopier;
import software.amazon.awssdk.services.ec2.model.OwnerStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeFpgaImagesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeFpgaImagesRequest> {
    private final List<String> fpgaImageIds;
    private final List<String> owners;
    private final List<Filter> filters;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeFpgaImagesRequest(BuilderImpl builder) {
        this.fpgaImageIds = builder.fpgaImageIds;
        this.owners = builder.owners;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public List<String> fpgaImageIds() {
        return this.fpgaImageIds;
    }

    public List<String> owners() {
        return this.owners;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fpgaImageIds() == null ? 0 : this.fpgaImageIds().hashCode());
        hashCode = 31 * hashCode + (this.owners() == null ? 0 : this.owners().hashCode());
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFpgaImagesRequest)) {
            return false;
        }
        DescribeFpgaImagesRequest other = (DescribeFpgaImagesRequest)((Object)obj);
        if (other.fpgaImageIds() == null ^ this.fpgaImageIds() == null) {
            return false;
        }
        if (other.fpgaImageIds() != null && !other.fpgaImageIds().equals(this.fpgaImageIds())) {
            return false;
        }
        if (other.owners() == null ^ this.owners() == null) {
            return false;
        }
        if (other.owners() != null && !other.owners().equals(this.owners())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        return other.maxResults() == null || other.maxResults().equals(this.maxResults());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fpgaImageIds() != null) {
            sb.append("FpgaImageIds: ").append(this.fpgaImageIds()).append(",");
        }
        if (this.owners() != null) {
            sb.append("Owners: ").append(this.owners()).append(",");
        }
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> fpgaImageIds = new SdkInternalList();
        private List<String> owners = new SdkInternalList();
        private List<Filter> filters = new SdkInternalList();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFpgaImagesRequest model) {
            this.setFpgaImageIds(model.fpgaImageIds);
            this.setOwners(model.owners);
            this.setFilters(model.filters);
            this.setNextToken(model.nextToken);
            this.setMaxResults(model.maxResults);
        }

        public final Collection<String> getFpgaImageIds() {
            return this.fpgaImageIds;
        }

        @Override
        public final Builder fpgaImageIds(Collection<String> fpgaImageIds) {
            this.fpgaImageIds = FpgaImageIdListCopier.copy(fpgaImageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fpgaImageIds(String ... fpgaImageIds) {
            if (this.fpgaImageIds == null) {
                this.fpgaImageIds = new SdkInternalList(fpgaImageIds.length);
            }
            for (String e : fpgaImageIds) {
                this.fpgaImageIds.add(e);
            }
            return this;
        }

        public final void setFpgaImageIds(Collection<String> fpgaImageIds) {
            this.fpgaImageIds = FpgaImageIdListCopier.copy(fpgaImageIds);
        }

        @SafeVarargs
        public final void setFpgaImageIds(String ... fpgaImageIds) {
            if (this.fpgaImageIds == null) {
                this.fpgaImageIds = new SdkInternalList(fpgaImageIds.length);
            }
            for (String e : fpgaImageIds) {
                this.fpgaImageIds.add(e);
            }
        }

        public final Collection<String> getOwners() {
            return this.owners;
        }

        @Override
        public final Builder owners(Collection<String> owners) {
            this.owners = OwnerStringListCopier.copy(owners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder owners(String ... owners) {
            if (this.owners == null) {
                this.owners = new SdkInternalList(owners.length);
            }
            for (String e : owners) {
                this.owners.add(e);
            }
            return this;
        }

        public final void setOwners(Collection<String> owners) {
            this.owners = OwnerStringListCopier.copy(owners);
        }

        @SafeVarargs
        public final void setOwners(String ... owners) {
            if (this.owners == null) {
                this.owners = new SdkInternalList(owners.length);
            }
            for (String e : owners) {
                this.owners.add(e);
            }
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            if (this.filters == null) {
                this.filters = new SdkInternalList(filters.length);
            }
            for (Filter e : filters) {
                this.filters.add(e);
            }
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter ... filters) {
            if (this.filters == null) {
                this.filters = new SdkInternalList(filters.length);
            }
            for (Filter e : filters) {
                this.filters.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public DescribeFpgaImagesRequest build() {
            return new DescribeFpgaImagesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeFpgaImagesRequest> {
        public Builder fpgaImageIds(Collection<String> var1);

        public Builder fpgaImageIds(String ... var1);

        public Builder owners(Collection<String> var1);

        public Builder owners(String ... var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);
    }
}

