/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.FlowLog;
import software.amazon.awssdk.services.ec2.model.FlowLogSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeFlowLogsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeFlowLogsResponse> {
    private final List<FlowLog> flowLogs;
    private final String nextToken;

    private DescribeFlowLogsResponse(BuilderImpl builder) {
        this.flowLogs = builder.flowLogs;
        this.nextToken = builder.nextToken;
    }

    public List<FlowLog> flowLogs() {
        return this.flowLogs;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.flowLogs() == null ? 0 : this.flowLogs().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFlowLogsResponse)) {
            return false;
        }
        DescribeFlowLogsResponse other = (DescribeFlowLogsResponse)((Object)obj);
        if (other.flowLogs() == null ^ this.flowLogs() == null) {
            return false;
        }
        if (other.flowLogs() != null && !other.flowLogs().equals(this.flowLogs())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.flowLogs() != null) {
            sb.append("FlowLogs: ").append(this.flowLogs()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<FlowLog> flowLogs = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFlowLogsResponse model) {
            this.setFlowLogs(model.flowLogs);
            this.setNextToken(model.nextToken);
        }

        public final Collection<FlowLog> getFlowLogs() {
            return this.flowLogs;
        }

        @Override
        public final Builder flowLogs(Collection<FlowLog> flowLogs) {
            this.flowLogs = FlowLogSetCopier.copy(flowLogs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowLogs(FlowLog ... flowLogs) {
            if (this.flowLogs == null) {
                this.flowLogs = new SdkInternalList(flowLogs.length);
            }
            for (FlowLog e : flowLogs) {
                this.flowLogs.add(e);
            }
            return this;
        }

        public final void setFlowLogs(Collection<FlowLog> flowLogs) {
            this.flowLogs = FlowLogSetCopier.copy(flowLogs);
        }

        @SafeVarargs
        public final void setFlowLogs(FlowLog ... flowLogs) {
            if (this.flowLogs == null) {
                this.flowLogs = new SdkInternalList(flowLogs.length);
            }
            for (FlowLog e : flowLogs) {
                this.flowLogs.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeFlowLogsResponse build() {
            return new DescribeFlowLogsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeFlowLogsResponse> {
        public Builder flowLogs(Collection<FlowLog> var1);

        public Builder flowLogs(FlowLog ... var1);

        public Builder nextToken(String var1);
    }
}

