/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.EgressOnlyInternetGatewayIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEgressOnlyInternetGatewaysRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeEgressOnlyInternetGatewaysRequest> {
    private final List<String> egressOnlyInternetGatewayIds;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeEgressOnlyInternetGatewaysRequest(BuilderImpl builder) {
        this.egressOnlyInternetGatewayIds = builder.egressOnlyInternetGatewayIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<String> egressOnlyInternetGatewayIds() {
        return this.egressOnlyInternetGatewayIds;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.egressOnlyInternetGatewayIds() == null ? 0 : this.egressOnlyInternetGatewayIds().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEgressOnlyInternetGatewaysRequest)) {
            return false;
        }
        DescribeEgressOnlyInternetGatewaysRequest other = (DescribeEgressOnlyInternetGatewaysRequest)((Object)obj);
        if (other.egressOnlyInternetGatewayIds() == null ^ this.egressOnlyInternetGatewayIds() == null) {
            return false;
        }
        if (other.egressOnlyInternetGatewayIds() != null && !other.egressOnlyInternetGatewayIds().equals(this.egressOnlyInternetGatewayIds())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.egressOnlyInternetGatewayIds() != null) {
            sb.append("EgressOnlyInternetGatewayIds: ").append(this.egressOnlyInternetGatewayIds()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> egressOnlyInternetGatewayIds = new SdkInternalList();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEgressOnlyInternetGatewaysRequest model) {
            this.setEgressOnlyInternetGatewayIds(model.egressOnlyInternetGatewayIds);
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getEgressOnlyInternetGatewayIds() {
            return this.egressOnlyInternetGatewayIds;
        }

        @Override
        public final Builder egressOnlyInternetGatewayIds(Collection<String> egressOnlyInternetGatewayIds) {
            this.egressOnlyInternetGatewayIds = EgressOnlyInternetGatewayIdListCopier.copy(egressOnlyInternetGatewayIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressOnlyInternetGatewayIds(String ... egressOnlyInternetGatewayIds) {
            if (this.egressOnlyInternetGatewayIds == null) {
                this.egressOnlyInternetGatewayIds = new SdkInternalList(egressOnlyInternetGatewayIds.length);
            }
            for (String e : egressOnlyInternetGatewayIds) {
                this.egressOnlyInternetGatewayIds.add(e);
            }
            return this;
        }

        public final void setEgressOnlyInternetGatewayIds(Collection<String> egressOnlyInternetGatewayIds) {
            this.egressOnlyInternetGatewayIds = EgressOnlyInternetGatewayIdListCopier.copy(egressOnlyInternetGatewayIds);
        }

        @SafeVarargs
        public final void setEgressOnlyInternetGatewayIds(String ... egressOnlyInternetGatewayIds) {
            if (this.egressOnlyInternetGatewayIds == null) {
                this.egressOnlyInternetGatewayIds = new SdkInternalList(egressOnlyInternetGatewayIds.length);
            }
            for (String e : egressOnlyInternetGatewayIds) {
                this.egressOnlyInternetGatewayIds.add(e);
            }
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeEgressOnlyInternetGatewaysRequest build() {
            return new DescribeEgressOnlyInternetGatewaysRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEgressOnlyInternetGatewaysRequest> {
        public Builder egressOnlyInternetGatewayIds(Collection<String> var1);

        public Builder egressOnlyInternetGatewayIds(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

