/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.ConversionIdStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeConversionTasksRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeConversionTasksRequest> {
    private final List<String> conversionTaskIds;

    private DescribeConversionTasksRequest(BuilderImpl builder) {
        this.conversionTaskIds = builder.conversionTaskIds;
    }

    public List<String> conversionTaskIds() {
        return this.conversionTaskIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.conversionTaskIds() == null ? 0 : this.conversionTaskIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConversionTasksRequest)) {
            return false;
        }
        DescribeConversionTasksRequest other = (DescribeConversionTasksRequest)((Object)obj);
        if (other.conversionTaskIds() == null ^ this.conversionTaskIds() == null) {
            return false;
        }
        return other.conversionTaskIds() == null || other.conversionTaskIds().equals(this.conversionTaskIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conversionTaskIds() != null) {
            sb.append("ConversionTaskIds: ").append(this.conversionTaskIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> conversionTaskIds = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConversionTasksRequest model) {
            this.setConversionTaskIds(model.conversionTaskIds);
        }

        public final Collection<String> getConversionTaskIds() {
            return this.conversionTaskIds;
        }

        @Override
        public final Builder conversionTaskIds(Collection<String> conversionTaskIds) {
            this.conversionTaskIds = ConversionIdStringListCopier.copy(conversionTaskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conversionTaskIds(String ... conversionTaskIds) {
            if (this.conversionTaskIds == null) {
                this.conversionTaskIds = new SdkInternalList(conversionTaskIds.length);
            }
            for (String e : conversionTaskIds) {
                this.conversionTaskIds.add(e);
            }
            return this;
        }

        public final void setConversionTaskIds(Collection<String> conversionTaskIds) {
            this.conversionTaskIds = ConversionIdStringListCopier.copy(conversionTaskIds);
        }

        @SafeVarargs
        public final void setConversionTaskIds(String ... conversionTaskIds) {
            if (this.conversionTaskIds == null) {
                this.conversionTaskIds = new SdkInternalList(conversionTaskIds.length);
            }
            for (String e : conversionTaskIds) {
                this.conversionTaskIds.add(e);
            }
        }

        public DescribeConversionTasksRequest build() {
            return new DescribeConversionTasksRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeConversionTasksRequest> {
        public Builder conversionTaskIds(Collection<String> var1);

        public Builder conversionTaskIds(String ... var1);
    }
}

