/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateVpcRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateVpcRequest> {
    private final String cidrBlock;
    private final Boolean amazonProvidedIpv6CidrBlock;
    private final String instanceTenancy;

    private CreateVpcRequest(BuilderImpl builder) {
        this.cidrBlock = builder.cidrBlock;
        this.amazonProvidedIpv6CidrBlock = builder.amazonProvidedIpv6CidrBlock;
        this.instanceTenancy = builder.instanceTenancy;
    }

    public String cidrBlock() {
        return this.cidrBlock;
    }

    public Boolean amazonProvidedIpv6CidrBlock() {
        return this.amazonProvidedIpv6CidrBlock;
    }

    public String instanceTenancy() {
        return this.instanceTenancy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.cidrBlock() == null ? 0 : this.cidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.amazonProvidedIpv6CidrBlock() == null ? 0 : this.amazonProvidedIpv6CidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.instanceTenancy() == null ? 0 : this.instanceTenancy().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcRequest)) {
            return false;
        }
        CreateVpcRequest other = (CreateVpcRequest)((Object)obj);
        if (other.cidrBlock() == null ^ this.cidrBlock() == null) {
            return false;
        }
        if (other.cidrBlock() != null && !other.cidrBlock().equals(this.cidrBlock())) {
            return false;
        }
        if (other.amazonProvidedIpv6CidrBlock() == null ^ this.amazonProvidedIpv6CidrBlock() == null) {
            return false;
        }
        if (other.amazonProvidedIpv6CidrBlock() != null && !other.amazonProvidedIpv6CidrBlock().equals(this.amazonProvidedIpv6CidrBlock())) {
            return false;
        }
        if (other.instanceTenancy() == null ^ this.instanceTenancy() == null) {
            return false;
        }
        return other.instanceTenancy() == null || other.instanceTenancy().equals(this.instanceTenancy());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cidrBlock() != null) {
            sb.append("CidrBlock: ").append(this.cidrBlock()).append(",");
        }
        if (this.amazonProvidedIpv6CidrBlock() != null) {
            sb.append("AmazonProvidedIpv6CidrBlock: ").append(this.amazonProvidedIpv6CidrBlock()).append(",");
        }
        if (this.instanceTenancy() != null) {
            sb.append("InstanceTenancy: ").append(this.instanceTenancy()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String cidrBlock;
        private Boolean amazonProvidedIpv6CidrBlock;
        private String instanceTenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcRequest model) {
            this.setCidrBlock(model.cidrBlock);
            this.setAmazonProvidedIpv6CidrBlock(model.amazonProvidedIpv6CidrBlock);
            this.setInstanceTenancy(model.instanceTenancy);
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final Boolean getAmazonProvidedIpv6CidrBlock() {
            return this.amazonProvidedIpv6CidrBlock;
        }

        @Override
        public final Builder amazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock) {
            this.amazonProvidedIpv6CidrBlock = amazonProvidedIpv6CidrBlock;
            return this;
        }

        public final void setAmazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock) {
            this.amazonProvidedIpv6CidrBlock = amazonProvidedIpv6CidrBlock;
        }

        public final String getInstanceTenancy() {
            return this.instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        public final void setInstanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
        }

        public CreateVpcRequest build() {
            return new CreateVpcRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateVpcRequest> {
        public Builder cidrBlock(String var1);

        public Builder amazonProvidedIpv6CidrBlock(Boolean var1);

        public Builder instanceTenancy(String var1);

        public Builder instanceTenancy(Tenancy var1);
    }
}

