/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.ConversionTaskState;
import software.amazon.awssdk.services.ec2.model.ImportInstanceTaskDetails;
import software.amazon.awssdk.services.ec2.model.ImportVolumeTaskDetails;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConversionTask
implements ToCopyableBuilder<Builder, ConversionTask> {
    private final String conversionTaskId;
    private final String expirationTime;
    private final ImportInstanceTaskDetails importInstance;
    private final ImportVolumeTaskDetails importVolume;
    private final String state;
    private final String statusMessage;
    private final List<Tag> tags;

    private ConversionTask(BuilderImpl builder) {
        this.conversionTaskId = builder.conversionTaskId;
        this.expirationTime = builder.expirationTime;
        this.importInstance = builder.importInstance;
        this.importVolume = builder.importVolume;
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
        this.tags = builder.tags;
    }

    public String conversionTaskId() {
        return this.conversionTaskId;
    }

    public String expirationTime() {
        return this.expirationTime;
    }

    public ImportInstanceTaskDetails importInstance() {
        return this.importInstance;
    }

    public ImportVolumeTaskDetails importVolume() {
        return this.importVolume;
    }

    public String state() {
        return this.state;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.conversionTaskId() == null ? 0 : this.conversionTaskId().hashCode());
        hashCode = 31 * hashCode + (this.expirationTime() == null ? 0 : this.expirationTime().hashCode());
        hashCode = 31 * hashCode + (this.importInstance() == null ? 0 : this.importInstance().hashCode());
        hashCode = 31 * hashCode + (this.importVolume() == null ? 0 : this.importVolume().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.statusMessage() == null ? 0 : this.statusMessage().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversionTask)) {
            return false;
        }
        ConversionTask other = (ConversionTask)obj;
        if (other.conversionTaskId() == null ^ this.conversionTaskId() == null) {
            return false;
        }
        if (other.conversionTaskId() != null && !other.conversionTaskId().equals(this.conversionTaskId())) {
            return false;
        }
        if (other.expirationTime() == null ^ this.expirationTime() == null) {
            return false;
        }
        if (other.expirationTime() != null && !other.expirationTime().equals(this.expirationTime())) {
            return false;
        }
        if (other.importInstance() == null ^ this.importInstance() == null) {
            return false;
        }
        if (other.importInstance() != null && !other.importInstance().equals(this.importInstance())) {
            return false;
        }
        if (other.importVolume() == null ^ this.importVolume() == null) {
            return false;
        }
        if (other.importVolume() != null && !other.importVolume().equals(this.importVolume())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.statusMessage() == null ^ this.statusMessage() == null) {
            return false;
        }
        if (other.statusMessage() != null && !other.statusMessage().equals(this.statusMessage())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conversionTaskId() != null) {
            sb.append("ConversionTaskId: ").append(this.conversionTaskId()).append(",");
        }
        if (this.expirationTime() != null) {
            sb.append("ExpirationTime: ").append(this.expirationTime()).append(",");
        }
        if (this.importInstance() != null) {
            sb.append("ImportInstance: ").append(this.importInstance()).append(",");
        }
        if (this.importVolume() != null) {
            sb.append("ImportVolume: ").append(this.importVolume()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.statusMessage() != null) {
            sb.append("StatusMessage: ").append(this.statusMessage()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String conversionTaskId;
        private String expirationTime;
        private ImportInstanceTaskDetails importInstance;
        private ImportVolumeTaskDetails importVolume;
        private String state;
        private String statusMessage;
        private List<Tag> tags = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(ConversionTask model) {
            this.setConversionTaskId(model.conversionTaskId);
            this.setExpirationTime(model.expirationTime);
            this.setImportInstance(model.importInstance);
            this.setImportVolume(model.importVolume);
            this.setState(model.state);
            this.setStatusMessage(model.statusMessage);
            this.setTags(model.tags);
        }

        public final String getConversionTaskId() {
            return this.conversionTaskId;
        }

        @Override
        public final Builder conversionTaskId(String conversionTaskId) {
            this.conversionTaskId = conversionTaskId;
            return this;
        }

        public final void setConversionTaskId(String conversionTaskId) {
            this.conversionTaskId = conversionTaskId;
        }

        public final String getExpirationTime() {
            return this.expirationTime;
        }

        @Override
        public final Builder expirationTime(String expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final void setExpirationTime(String expirationTime) {
            this.expirationTime = expirationTime;
        }

        public final ImportInstanceTaskDetails getImportInstance() {
            return this.importInstance;
        }

        @Override
        public final Builder importInstance(ImportInstanceTaskDetails importInstance) {
            this.importInstance = importInstance;
            return this;
        }

        public final void setImportInstance(ImportInstanceTaskDetails importInstance) {
            this.importInstance = importInstance;
        }

        public final ImportVolumeTaskDetails getImportVolume() {
            return this.importVolume;
        }

        @Override
        public final Builder importVolume(ImportVolumeTaskDetails importVolume) {
            this.importVolume = importVolume;
            return this;
        }

        public final void setImportVolume(ImportVolumeTaskDetails importVolume) {
            this.importVolume = importVolume;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ConversionTaskState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(ConversionTaskState state) {
            this.state(state.toString());
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
        }

        public ConversionTask build() {
            return new ConversionTask(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConversionTask> {
        public Builder conversionTaskId(String var1);

        public Builder expirationTime(String var1);

        public Builder importInstance(ImportInstanceTaskDetails var1);

        public Builder importVolume(ImportVolumeTaskDetails var1);

        public Builder state(String var1);

        public Builder state(ConversionTaskState var1);

        public Builder statusMessage(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

