/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.Ipv6AddressListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssignIpv6AddressesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, AssignIpv6AddressesResponse> {
    private final List<String> assignedIpv6Addresses;
    private final String networkInterfaceId;

    private AssignIpv6AddressesResponse(BuilderImpl builder) {
        this.assignedIpv6Addresses = builder.assignedIpv6Addresses;
        this.networkInterfaceId = builder.networkInterfaceId;
    }

    public List<String> assignedIpv6Addresses() {
        return this.assignedIpv6Addresses;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.assignedIpv6Addresses() == null ? 0 : this.assignedIpv6Addresses().hashCode());
        hashCode = 31 * hashCode + (this.networkInterfaceId() == null ? 0 : this.networkInterfaceId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignIpv6AddressesResponse)) {
            return false;
        }
        AssignIpv6AddressesResponse other = (AssignIpv6AddressesResponse)((Object)obj);
        if (other.assignedIpv6Addresses() == null ^ this.assignedIpv6Addresses() == null) {
            return false;
        }
        if (other.assignedIpv6Addresses() != null && !other.assignedIpv6Addresses().equals(this.assignedIpv6Addresses())) {
            return false;
        }
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        return other.networkInterfaceId() == null || other.networkInterfaceId().equals(this.networkInterfaceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.assignedIpv6Addresses() != null) {
            sb.append("AssignedIpv6Addresses: ").append(this.assignedIpv6Addresses()).append(",");
        }
        if (this.networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.networkInterfaceId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> assignedIpv6Addresses = new SdkInternalList();
        private String networkInterfaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignIpv6AddressesResponse model) {
            this.setAssignedIpv6Addresses(model.assignedIpv6Addresses);
            this.setNetworkInterfaceId(model.networkInterfaceId);
        }

        public final Collection<String> getAssignedIpv6Addresses() {
            return this.assignedIpv6Addresses;
        }

        @Override
        public final Builder assignedIpv6Addresses(Collection<String> assignedIpv6Addresses) {
            this.assignedIpv6Addresses = Ipv6AddressListCopier.copy(assignedIpv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignedIpv6Addresses(String ... assignedIpv6Addresses) {
            if (this.assignedIpv6Addresses == null) {
                this.assignedIpv6Addresses = new SdkInternalList(assignedIpv6Addresses.length);
            }
            for (String e : assignedIpv6Addresses) {
                this.assignedIpv6Addresses.add(e);
            }
            return this;
        }

        public final void setAssignedIpv6Addresses(Collection<String> assignedIpv6Addresses) {
            this.assignedIpv6Addresses = Ipv6AddressListCopier.copy(assignedIpv6Addresses);
        }

        @SafeVarargs
        public final void setAssignedIpv6Addresses(String ... assignedIpv6Addresses) {
            if (this.assignedIpv6Addresses == null) {
                this.assignedIpv6Addresses = new SdkInternalList(assignedIpv6Addresses.length);
            }
            for (String e : assignedIpv6Addresses) {
                this.assignedIpv6Addresses.add(e);
            }
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public AssignIpv6AddressesResponse build() {
            return new AssignIpv6AddressesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssignIpv6AddressesResponse> {
        public Builder assignedIpv6Addresses(Collection<String> var1);

        public Builder assignedIpv6Addresses(String ... var1);

        public Builder networkInterfaceId(String var1);
    }
}

