/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ebs.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ebs.EbsAsyncClient;
import software.amazon.awssdk.services.ebs.internal.UserAgentUtils;
import software.amazon.awssdk.services.ebs.model.ListSnapshotBlocksRequest;
import software.amazon.awssdk.services.ebs.model.ListSnapshotBlocksResponse;

public class ListSnapshotBlocksPublisher
implements SdkPublisher<ListSnapshotBlocksResponse> {
    private final EbsAsyncClient client;
    private final ListSnapshotBlocksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSnapshotBlocksPublisher(EbsAsyncClient client, ListSnapshotBlocksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSnapshotBlocksPublisher(EbsAsyncClient client, ListSnapshotBlocksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSnapshotBlocksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSnapshotBlocksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSnapshotBlocksResponseFetcher
    implements AsyncPageFetcher<ListSnapshotBlocksResponse> {
        private ListSnapshotBlocksResponseFetcher() {
        }

        public boolean hasNextPage(ListSnapshotBlocksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSnapshotBlocksResponse> nextPage(ListSnapshotBlocksResponse previousPage) {
            if (previousPage == null) {
                return ListSnapshotBlocksPublisher.this.client.listSnapshotBlocks(ListSnapshotBlocksPublisher.this.firstRequest);
            }
            return ListSnapshotBlocksPublisher.this.client.listSnapshotBlocks((ListSnapshotBlocksRequest)((Object)ListSnapshotBlocksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

