/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ebs.auth.scheme.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.services.ebs.auth.scheme.EbsAuthSchemeParams;
import software.amazon.awssdk.services.ebs.auth.scheme.EbsAuthSchemeProvider;

@SdkInternalApi
public final class DefaultEbsAuthSchemeProvider
implements EbsAuthSchemeProvider {
    private static final DefaultEbsAuthSchemeProvider DEFAULT = new DefaultEbsAuthSchemeProvider();

    private DefaultEbsAuthSchemeProvider() {
    }

    public static DefaultEbsAuthSchemeProvider create() {
        return DEFAULT;
    }

    @Override
    public List<AuthSchemeOption> resolveAuthScheme(EbsAuthSchemeParams params) {
        ArrayList<AuthSchemeOption> options = new ArrayList<AuthSchemeOption>();
        switch (params.operation()) {
            case "PutSnapshotBlock": {
                options.add((AuthSchemeOption)AuthSchemeOption.builder().schemeId("aws.auth#sigv4").putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)"ebs").putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)params.region().id()).putSignerProperty(AwsV4HttpSigner.PAYLOAD_SIGNING_ENABLED, (Object)false).build());
                break;
            }
            default: {
                options.add((AuthSchemeOption)AuthSchemeOption.builder().schemeId("aws.auth#sigv4").putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)"ebs").putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)params.region().id()).build());
            }
        }
        return Collections.unmodifiableList(options);
    }
}

