/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ebs;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ebs.DefaultEbsBaseClientBuilder;
import software.amazon.awssdk.services.ebs.DefaultEbsClient;
import software.amazon.awssdk.services.ebs.EbsClient;
import software.amazon.awssdk.services.ebs.EbsClientBuilder;
import software.amazon.awssdk.services.ebs.EbsServiceClientConfiguration;
import software.amazon.awssdk.services.ebs.endpoints.EbsEndpointProvider;

@SdkInternalApi
final class DefaultEbsClientBuilder
extends DefaultEbsBaseClientBuilder<EbsClientBuilder, EbsClient>
implements EbsClientBuilder {
    DefaultEbsClientBuilder() {
    }

    @Override
    public DefaultEbsClientBuilder endpointProvider(EbsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EbsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultEbsClientBuilder.validateClientOptions(clientConfiguration);
        EbsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultEbsClient client = new DefaultEbsClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private EbsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return EbsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

