/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ebs;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ebs.DefaultEbsBaseClientBuilder;
import software.amazon.awssdk.services.ebs.DefaultEbsClient;
import software.amazon.awssdk.services.ebs.EbsClient;
import software.amazon.awssdk.services.ebs.EbsClientBuilder;
import software.amazon.awssdk.services.ebs.EbsServiceClientConfiguration;
import software.amazon.awssdk.services.ebs.endpoints.EbsEndpointProvider;

@SdkInternalApi
final class DefaultEbsClientBuilder
extends DefaultEbsBaseClientBuilder<EbsClientBuilder, EbsClient>
implements EbsClientBuilder {
    DefaultEbsClientBuilder() {
    }

    @Override
    public DefaultEbsClientBuilder endpointProvider(EbsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EbsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultEbsClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        EbsServiceClientConfiguration serviceClientConfiguration = EbsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultEbsClient(serviceClientConfiguration, clientConfiguration);
    }
}

