/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ebs;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.ebs.DefaultEbsClientBuilder;
import software.amazon.awssdk.services.ebs.EbsClientBuilder;
import software.amazon.awssdk.services.ebs.model.AccessDeniedException;
import software.amazon.awssdk.services.ebs.model.CompleteSnapshotRequest;
import software.amazon.awssdk.services.ebs.model.CompleteSnapshotResponse;
import software.amazon.awssdk.services.ebs.model.ConcurrentLimitExceededException;
import software.amazon.awssdk.services.ebs.model.ConflictException;
import software.amazon.awssdk.services.ebs.model.EbsException;
import software.amazon.awssdk.services.ebs.model.GetSnapshotBlockRequest;
import software.amazon.awssdk.services.ebs.model.GetSnapshotBlockResponse;
import software.amazon.awssdk.services.ebs.model.InternalServerException;
import software.amazon.awssdk.services.ebs.model.ListChangedBlocksRequest;
import software.amazon.awssdk.services.ebs.model.ListChangedBlocksResponse;
import software.amazon.awssdk.services.ebs.model.ListSnapshotBlocksRequest;
import software.amazon.awssdk.services.ebs.model.ListSnapshotBlocksResponse;
import software.amazon.awssdk.services.ebs.model.PutSnapshotBlockRequest;
import software.amazon.awssdk.services.ebs.model.PutSnapshotBlockResponse;
import software.amazon.awssdk.services.ebs.model.RequestThrottledException;
import software.amazon.awssdk.services.ebs.model.ResourceNotFoundException;
import software.amazon.awssdk.services.ebs.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.ebs.model.StartSnapshotRequest;
import software.amazon.awssdk.services.ebs.model.StartSnapshotResponse;
import software.amazon.awssdk.services.ebs.model.ValidationException;
import software.amazon.awssdk.services.ebs.paginators.ListChangedBlocksIterable;
import software.amazon.awssdk.services.ebs.paginators.ListSnapshotBlocksIterable;

@SdkPublicApi
@ThreadSafe
public interface EbsClient
extends SdkClient {
    public static final String SERVICE_NAME = "ebs";
    public static final String SERVICE_METADATA_ID = "ebs";

    public static EbsClient create() {
        return (EbsClient)EbsClient.builder().build();
    }

    public static EbsClientBuilder builder() {
        return new DefaultEbsClientBuilder();
    }

    default public CompleteSnapshotResponse completeSnapshot(CompleteSnapshotRequest completeSnapshotRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, RequestThrottledException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, EbsException {
        throw new UnsupportedOperationException();
    }

    default public CompleteSnapshotResponse completeSnapshot(Consumer<CompleteSnapshotRequest.Builder> completeSnapshotRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, RequestThrottledException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, EbsException {
        return this.completeSnapshot((CompleteSnapshotRequest)((Object)((CompleteSnapshotRequest.Builder)CompleteSnapshotRequest.builder().applyMutation(completeSnapshotRequest)).build()));
    }

    default public <ReturnT> ReturnT getSnapshotBlock(GetSnapshotBlockRequest getSnapshotBlockRequest, ResponseTransformer<GetSnapshotBlockResponse, ReturnT> responseTransformer) throws AccessDeniedException, ValidationException, ResourceNotFoundException, RequestThrottledException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, EbsException {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> ReturnT getSnapshotBlock(Consumer<GetSnapshotBlockRequest.Builder> getSnapshotBlockRequest, ResponseTransformer<GetSnapshotBlockResponse, ReturnT> responseTransformer) throws AccessDeniedException, ValidationException, ResourceNotFoundException, RequestThrottledException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, EbsException {
        return this.getSnapshotBlock((GetSnapshotBlockRequest)((Object)((GetSnapshotBlockRequest.Builder)GetSnapshotBlockRequest.builder().applyMutation(getSnapshotBlockRequest)).build()), responseTransformer);
    }

    default public GetSnapshotBlockResponse getSnapshotBlock(GetSnapshotBlockRequest getSnapshotBlockRequest, Path destinationPath) throws AccessDeniedException, ValidationException, ResourceNotFoundException, RequestThrottledException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, EbsException {
        return (GetSnapshotBlockResponse)((Object)this.getSnapshotBlock(getSnapshotBlockRequest, ResponseTransformer.toFile((Path)destinationPath)));
    }

    default public GetSnapshotBlockResponse getSnapshotBlock(Consumer<GetSnapshotBlockRequest.Builder> getSnapshotBlockRequest, Path destinationPath) throws AccessDeniedException, ValidationException, ResourceNotFoundException, RequestThrottledException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, EbsException {
        return this.getSnapshotBlock((GetSnapshotBlockRequest)((Object)((GetSnapshotBlockRequest.Builder)GetSnapshotBlockRequest.builder().applyMutation(getSnapshotBlockRequest)).build()), destinationPath);
    }

    default public ResponseInputStream<GetSnapshotBlockResponse> getSnapshotBlock(GetSnapshotBlockRequest getSnapshotBlockRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, RequestThrottledException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, EbsException {
        return (ResponseInputStream)this.getSnapshotBlock(getSnapshotBlockRequest, ResponseTransformer.toInputStream());
    }

    default public ResponseInputStream<GetSnapshotBlockResponse> getSnapshotBlock(Consumer<GetSnapshotBlockRequest.Builder> getSnapshotBlockRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, RequestThrottledException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, EbsException {
        return this.getSnapshotBlock((GetSnapshotBlockRequest)((Object)((GetSnapshotBlockRequest.Builder)GetSnapshotBlockRequest.builder().applyMutation(getSnapshotBlockRequest)).build()));
    }

    default public ResponseBytes<GetSnapshotBlockResponse> getSnapshotBlockAsBytes(GetSnapshotBlockRequest getSnapshotBlockRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, RequestThrottledException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, EbsException {
        return (ResponseBytes)this.getSnapshotBlock(getSnapshotBlockRequest, ResponseTransformer.toBytes());
    }

    default public ResponseBytes<GetSnapshotBlockResponse> getSnapshotBlockAsBytes(Consumer<GetSnapshotBlockRequest.Builder> getSnapshotBlockRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, RequestThrottledException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, EbsException {
        return this.getSnapshotBlockAsBytes((GetSnapshotBlockRequest)((Object)((GetSnapshotBlockRequest.Builder)GetSnapshotBlockRequest.builder().applyMutation(getSnapshotBlockRequest)).build()));
    }

    default public ListChangedBlocksResponse listChangedBlocks(ListChangedBlocksRequest listChangedBlocksRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, RequestThrottledException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, EbsException {
        throw new UnsupportedOperationException();
    }

    default public ListChangedBlocksResponse listChangedBlocks(Consumer<ListChangedBlocksRequest.Builder> listChangedBlocksRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, RequestThrottledException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, EbsException {
        return this.listChangedBlocks((ListChangedBlocksRequest)((Object)((ListChangedBlocksRequest.Builder)ListChangedBlocksRequest.builder().applyMutation(listChangedBlocksRequest)).build()));
    }

    default public ListChangedBlocksIterable listChangedBlocksPaginator(ListChangedBlocksRequest listChangedBlocksRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, RequestThrottledException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, EbsException {
        throw new UnsupportedOperationException();
    }

    default public ListChangedBlocksIterable listChangedBlocksPaginator(Consumer<ListChangedBlocksRequest.Builder> listChangedBlocksRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, RequestThrottledException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, EbsException {
        return this.listChangedBlocksPaginator((ListChangedBlocksRequest)((Object)((ListChangedBlocksRequest.Builder)ListChangedBlocksRequest.builder().applyMutation(listChangedBlocksRequest)).build()));
    }

    default public ListSnapshotBlocksResponse listSnapshotBlocks(ListSnapshotBlocksRequest listSnapshotBlocksRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, RequestThrottledException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, EbsException {
        throw new UnsupportedOperationException();
    }

    default public ListSnapshotBlocksResponse listSnapshotBlocks(Consumer<ListSnapshotBlocksRequest.Builder> listSnapshotBlocksRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, RequestThrottledException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, EbsException {
        return this.listSnapshotBlocks((ListSnapshotBlocksRequest)((Object)((ListSnapshotBlocksRequest.Builder)ListSnapshotBlocksRequest.builder().applyMutation(listSnapshotBlocksRequest)).build()));
    }

    default public ListSnapshotBlocksIterable listSnapshotBlocksPaginator(ListSnapshotBlocksRequest listSnapshotBlocksRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, RequestThrottledException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, EbsException {
        throw new UnsupportedOperationException();
    }

    default public ListSnapshotBlocksIterable listSnapshotBlocksPaginator(Consumer<ListSnapshotBlocksRequest.Builder> listSnapshotBlocksRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, RequestThrottledException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, EbsException {
        return this.listSnapshotBlocksPaginator((ListSnapshotBlocksRequest)((Object)((ListSnapshotBlocksRequest.Builder)ListSnapshotBlocksRequest.builder().applyMutation(listSnapshotBlocksRequest)).build()));
    }

    default public PutSnapshotBlockResponse putSnapshotBlock(PutSnapshotBlockRequest putSnapshotBlockRequest, RequestBody requestBody) throws AccessDeniedException, ValidationException, ResourceNotFoundException, RequestThrottledException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, EbsException {
        throw new UnsupportedOperationException();
    }

    default public PutSnapshotBlockResponse putSnapshotBlock(Consumer<PutSnapshotBlockRequest.Builder> putSnapshotBlockRequest, RequestBody requestBody) throws AccessDeniedException, ValidationException, ResourceNotFoundException, RequestThrottledException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, EbsException {
        return this.putSnapshotBlock((PutSnapshotBlockRequest)((Object)((PutSnapshotBlockRequest.Builder)PutSnapshotBlockRequest.builder().applyMutation(putSnapshotBlockRequest)).build()), requestBody);
    }

    default public PutSnapshotBlockResponse putSnapshotBlock(PutSnapshotBlockRequest putSnapshotBlockRequest, Path sourcePath) throws AccessDeniedException, ValidationException, ResourceNotFoundException, RequestThrottledException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, EbsException {
        return this.putSnapshotBlock(putSnapshotBlockRequest, RequestBody.fromFile((Path)sourcePath));
    }

    default public PutSnapshotBlockResponse putSnapshotBlock(Consumer<PutSnapshotBlockRequest.Builder> putSnapshotBlockRequest, Path sourcePath) throws AccessDeniedException, ValidationException, ResourceNotFoundException, RequestThrottledException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, EbsException {
        return this.putSnapshotBlock((PutSnapshotBlockRequest)((Object)((PutSnapshotBlockRequest.Builder)PutSnapshotBlockRequest.builder().applyMutation(putSnapshotBlockRequest)).build()), sourcePath);
    }

    default public StartSnapshotResponse startSnapshot(StartSnapshotRequest startSnapshotRequest) throws AccessDeniedException, ValidationException, RequestThrottledException, ResourceNotFoundException, ServiceQuotaExceededException, InternalServerException, ConcurrentLimitExceededException, ConflictException, AwsServiceException, SdkClientException, EbsException {
        throw new UnsupportedOperationException();
    }

    default public StartSnapshotResponse startSnapshot(Consumer<StartSnapshotRequest.Builder> startSnapshotRequest) throws AccessDeniedException, ValidationException, RequestThrottledException, ResourceNotFoundException, ServiceQuotaExceededException, InternalServerException, ConcurrentLimitExceededException, ConflictException, AwsServiceException, SdkClientException, EbsException {
        return this.startSnapshot((StartSnapshotRequest)((Object)((StartSnapshotRequest.Builder)StartSnapshotRequest.builder().applyMutation(startSnapshotRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"ebs");
    }
}

