/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinitionsCopier;
import software.amazon.awssdk.services.dynamodb.model.BillingModeSummary;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescriptionListCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescriptionListCopier;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription;
import software.amazon.awssdk.services.dynamodb.model.RestoreSummary;
import software.amazon.awssdk.services.dynamodb.model.SSEDescription;
import software.amazon.awssdk.services.dynamodb.model.StreamSpecification;
import software.amazon.awssdk.services.dynamodb.model.TableStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableDescription> {
    private static final SdkField<List<AttributeDefinition>> ATTRIBUTE_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TableDescription.getter(TableDescription::attributeDefinitions)).setter(TableDescription.setter(Builder::attributeDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TableDescription.getter(TableDescription::tableName)).setter(TableDescription.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<List<KeySchemaElement>> KEY_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TableDescription.getter(TableDescription::keySchema)).setter(TableDescription.setter(Builder::keySchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySchema").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeySchemaElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TABLE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TableDescription.getter(TableDescription::tableStatusAsString)).setter(TableDescription.setter(Builder::tableStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableStatus").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TableDescription.getter(TableDescription::creationDateTime)).setter(TableDescription.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDateTime").build()}).build();
    private static final SdkField<ProvisionedThroughputDescription> PROVISIONED_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TableDescription.getter(TableDescription::provisionedThroughput)).setter(TableDescription.setter(Builder::provisionedThroughput)).constructor(ProvisionedThroughputDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughput").build()}).build();
    private static final SdkField<Long> TABLE_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(TableDescription.getter(TableDescription::tableSizeBytes)).setter(TableDescription.setter(Builder::tableSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableSizeBytes").build()}).build();
    private static final SdkField<Long> ITEM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(TableDescription.getter(TableDescription::itemCount)).setter(TableDescription.setter(Builder::itemCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCount").build()}).build();
    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TableDescription.getter(TableDescription::tableArn)).setter(TableDescription.setter(Builder::tableArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableArn").build()}).build();
    private static final SdkField<String> TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TableDescription.getter(TableDescription::tableId)).setter(TableDescription.setter(Builder::tableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableId").build()}).build();
    private static final SdkField<BillingModeSummary> BILLING_MODE_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TableDescription.getter(TableDescription::billingModeSummary)).setter(TableDescription.setter(Builder::billingModeSummary)).constructor(BillingModeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingModeSummary").build()}).build();
    private static final SdkField<List<LocalSecondaryIndexDescription>> LOCAL_SECONDARY_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TableDescription.getter(TableDescription::localSecondaryIndexes)).setter(TableDescription.setter(Builder::localSecondaryIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalSecondaryIndexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocalSecondaryIndexDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GlobalSecondaryIndexDescription>> GLOBAL_SECONDARY_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TableDescription.getter(TableDescription::globalSecondaryIndexes)).setter(TableDescription.setter(Builder::globalSecondaryIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlobalSecondaryIndexDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StreamSpecification> STREAM_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TableDescription.getter(TableDescription::streamSpecification)).setter(TableDescription.setter(Builder::streamSpecification)).constructor(StreamSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamSpecification").build()}).build();
    private static final SdkField<String> LATEST_STREAM_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TableDescription.getter(TableDescription::latestStreamLabel)).setter(TableDescription.setter(Builder::latestStreamLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestStreamLabel").build()}).build();
    private static final SdkField<String> LATEST_STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TableDescription.getter(TableDescription::latestStreamArn)).setter(TableDescription.setter(Builder::latestStreamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestStreamArn").build()}).build();
    private static final SdkField<RestoreSummary> RESTORE_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TableDescription.getter(TableDescription::restoreSummary)).setter(TableDescription.setter(Builder::restoreSummary)).constructor(RestoreSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreSummary").build()}).build();
    private static final SdkField<SSEDescription> SSE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TableDescription.getter(TableDescription::sseDescription)).setter(TableDescription.setter(Builder::sseDescription)).constructor(SSEDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSEDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_DEFINITIONS_FIELD, TABLE_NAME_FIELD, KEY_SCHEMA_FIELD, TABLE_STATUS_FIELD, CREATION_DATE_TIME_FIELD, PROVISIONED_THROUGHPUT_FIELD, TABLE_SIZE_BYTES_FIELD, ITEM_COUNT_FIELD, TABLE_ARN_FIELD, TABLE_ID_FIELD, BILLING_MODE_SUMMARY_FIELD, LOCAL_SECONDARY_INDEXES_FIELD, GLOBAL_SECONDARY_INDEXES_FIELD, STREAM_SPECIFICATION_FIELD, LATEST_STREAM_LABEL_FIELD, LATEST_STREAM_ARN_FIELD, RESTORE_SUMMARY_FIELD, SSE_DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AttributeDefinition> attributeDefinitions;
    private final String tableName;
    private final List<KeySchemaElement> keySchema;
    private final String tableStatus;
    private final Instant creationDateTime;
    private final ProvisionedThroughputDescription provisionedThroughput;
    private final Long tableSizeBytes;
    private final Long itemCount;
    private final String tableArn;
    private final String tableId;
    private final BillingModeSummary billingModeSummary;
    private final List<LocalSecondaryIndexDescription> localSecondaryIndexes;
    private final List<GlobalSecondaryIndexDescription> globalSecondaryIndexes;
    private final StreamSpecification streamSpecification;
    private final String latestStreamLabel;
    private final String latestStreamArn;
    private final RestoreSummary restoreSummary;
    private final SSEDescription sseDescription;

    private TableDescription(BuilderImpl builder) {
        this.attributeDefinitions = builder.attributeDefinitions;
        this.tableName = builder.tableName;
        this.keySchema = builder.keySchema;
        this.tableStatus = builder.tableStatus;
        this.creationDateTime = builder.creationDateTime;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.tableSizeBytes = builder.tableSizeBytes;
        this.itemCount = builder.itemCount;
        this.tableArn = builder.tableArn;
        this.tableId = builder.tableId;
        this.billingModeSummary = builder.billingModeSummary;
        this.localSecondaryIndexes = builder.localSecondaryIndexes;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
        this.streamSpecification = builder.streamSpecification;
        this.latestStreamLabel = builder.latestStreamLabel;
        this.latestStreamArn = builder.latestStreamArn;
        this.restoreSummary = builder.restoreSummary;
        this.sseDescription = builder.sseDescription;
    }

    public List<AttributeDefinition> attributeDefinitions() {
        return this.attributeDefinitions;
    }

    public String tableName() {
        return this.tableName;
    }

    public List<KeySchemaElement> keySchema() {
        return this.keySchema;
    }

    public TableStatus tableStatus() {
        return TableStatus.fromValue(this.tableStatus);
    }

    public String tableStatusAsString() {
        return this.tableStatus;
    }

    public Instant creationDateTime() {
        return this.creationDateTime;
    }

    public ProvisionedThroughputDescription provisionedThroughput() {
        return this.provisionedThroughput;
    }

    public Long tableSizeBytes() {
        return this.tableSizeBytes;
    }

    public Long itemCount() {
        return this.itemCount;
    }

    public String tableArn() {
        return this.tableArn;
    }

    public String tableId() {
        return this.tableId;
    }

    public BillingModeSummary billingModeSummary() {
        return this.billingModeSummary;
    }

    public List<LocalSecondaryIndexDescription> localSecondaryIndexes() {
        return this.localSecondaryIndexes;
    }

    public List<GlobalSecondaryIndexDescription> globalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public StreamSpecification streamSpecification() {
        return this.streamSpecification;
    }

    public String latestStreamLabel() {
        return this.latestStreamLabel;
    }

    public String latestStreamArn() {
        return this.latestStreamArn;
    }

    public RestoreSummary restoreSummary() {
        return this.restoreSummary;
    }

    public SSEDescription sseDescription() {
        return this.sseDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keySchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingModeSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.localSecondaryIndexes());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalSecondaryIndexes());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestStreamLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestStreamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableDescription)) {
            return false;
        }
        TableDescription other = (TableDescription)obj;
        return Objects.equals(this.attributeDefinitions(), other.attributeDefinitions()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.keySchema(), other.keySchema()) && Objects.equals(this.tableStatusAsString(), other.tableStatusAsString()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.provisionedThroughput(), other.provisionedThroughput()) && Objects.equals(this.tableSizeBytes(), other.tableSizeBytes()) && Objects.equals(this.itemCount(), other.itemCount()) && Objects.equals(this.tableArn(), other.tableArn()) && Objects.equals(this.tableId(), other.tableId()) && Objects.equals(this.billingModeSummary(), other.billingModeSummary()) && Objects.equals(this.localSecondaryIndexes(), other.localSecondaryIndexes()) && Objects.equals(this.globalSecondaryIndexes(), other.globalSecondaryIndexes()) && Objects.equals(this.streamSpecification(), other.streamSpecification()) && Objects.equals(this.latestStreamLabel(), other.latestStreamLabel()) && Objects.equals(this.latestStreamArn(), other.latestStreamArn()) && Objects.equals(this.restoreSummary(), other.restoreSummary()) && Objects.equals(this.sseDescription(), other.sseDescription());
    }

    public String toString() {
        return ToString.builder((String)"TableDescription").add("AttributeDefinitions", this.attributeDefinitions()).add("TableName", (Object)this.tableName()).add("KeySchema", this.keySchema()).add("TableStatus", (Object)this.tableStatusAsString()).add("CreationDateTime", (Object)this.creationDateTime()).add("ProvisionedThroughput", (Object)this.provisionedThroughput()).add("TableSizeBytes", (Object)this.tableSizeBytes()).add("ItemCount", (Object)this.itemCount()).add("TableArn", (Object)this.tableArn()).add("TableId", (Object)this.tableId()).add("BillingModeSummary", (Object)this.billingModeSummary()).add("LocalSecondaryIndexes", this.localSecondaryIndexes()).add("GlobalSecondaryIndexes", this.globalSecondaryIndexes()).add("StreamSpecification", (Object)this.streamSpecification()).add("LatestStreamLabel", (Object)this.latestStreamLabel()).add("LatestStreamArn", (Object)this.latestStreamArn()).add("RestoreSummary", (Object)this.restoreSummary()).add("SSEDescription", (Object)this.sseDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeDefinitions": {
                return Optional.ofNullable(clazz.cast(this.attributeDefinitions()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "KeySchema": {
                return Optional.ofNullable(clazz.cast(this.keySchema()));
            }
            case "TableStatus": {
                return Optional.ofNullable(clazz.cast(this.tableStatusAsString()));
            }
            case "CreationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "ProvisionedThroughput": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughput()));
            }
            case "TableSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.tableSizeBytes()));
            }
            case "ItemCount": {
                return Optional.ofNullable(clazz.cast(this.itemCount()));
            }
            case "TableArn": {
                return Optional.ofNullable(clazz.cast(this.tableArn()));
            }
            case "TableId": {
                return Optional.ofNullable(clazz.cast(this.tableId()));
            }
            case "BillingModeSummary": {
                return Optional.ofNullable(clazz.cast(this.billingModeSummary()));
            }
            case "LocalSecondaryIndexes": {
                return Optional.ofNullable(clazz.cast(this.localSecondaryIndexes()));
            }
            case "GlobalSecondaryIndexes": {
                return Optional.ofNullable(clazz.cast(this.globalSecondaryIndexes()));
            }
            case "StreamSpecification": {
                return Optional.ofNullable(clazz.cast(this.streamSpecification()));
            }
            case "LatestStreamLabel": {
                return Optional.ofNullable(clazz.cast(this.latestStreamLabel()));
            }
            case "LatestStreamArn": {
                return Optional.ofNullable(clazz.cast(this.latestStreamArn()));
            }
            case "RestoreSummary": {
                return Optional.ofNullable(clazz.cast(this.restoreSummary()));
            }
            case "SSEDescription": {
                return Optional.ofNullable(clazz.cast(this.sseDescription()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableDescription, T> g) {
        return obj -> g.apply((TableDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AttributeDefinition> attributeDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String tableName;
        private List<KeySchemaElement> keySchema = DefaultSdkAutoConstructList.getInstance();
        private String tableStatus;
        private Instant creationDateTime;
        private ProvisionedThroughputDescription provisionedThroughput;
        private Long tableSizeBytes;
        private Long itemCount;
        private String tableArn;
        private String tableId;
        private BillingModeSummary billingModeSummary;
        private List<LocalSecondaryIndexDescription> localSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();
        private List<GlobalSecondaryIndexDescription> globalSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();
        private StreamSpecification streamSpecification;
        private String latestStreamLabel;
        private String latestStreamArn;
        private RestoreSummary restoreSummary;
        private SSEDescription sseDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(TableDescription model) {
            this.attributeDefinitions(model.attributeDefinitions);
            this.tableName(model.tableName);
            this.keySchema(model.keySchema);
            this.tableStatus(model.tableStatus);
            this.creationDateTime(model.creationDateTime);
            this.provisionedThroughput(model.provisionedThroughput);
            this.tableSizeBytes(model.tableSizeBytes);
            this.itemCount(model.itemCount);
            this.tableArn(model.tableArn);
            this.tableId(model.tableId);
            this.billingModeSummary(model.billingModeSummary);
            this.localSecondaryIndexes(model.localSecondaryIndexes);
            this.globalSecondaryIndexes(model.globalSecondaryIndexes);
            this.streamSpecification(model.streamSpecification);
            this.latestStreamLabel(model.latestStreamLabel);
            this.latestStreamArn(model.latestStreamArn);
            this.restoreSummary(model.restoreSummary);
            this.sseDescription(model.sseDescription);
        }

        public final Collection<AttributeDefinition.Builder> getAttributeDefinitions() {
            return this.attributeDefinitions != null ? (Collection)this.attributeDefinitions.stream().map(AttributeDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copy(attributeDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(AttributeDefinition ... attributeDefinitions) {
            this.attributeDefinitions(Arrays.asList(attributeDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(Consumer<AttributeDefinition.Builder> ... attributeDefinitions) {
            this.attributeDefinitions(Stream.of(attributeDefinitions).map(c -> (AttributeDefinition)((AttributeDefinition.Builder)AttributeDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributeDefinitions(Collection<AttributeDefinition.BuilderImpl> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copyFromBuilder(attributeDefinitions);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Collection<KeySchemaElement.Builder> getKeySchema() {
            return this.keySchema != null ? (Collection)this.keySchema.stream().map(KeySchemaElement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement ... keySchema) {
            this.keySchema(Arrays.asList(keySchema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(Consumer<KeySchemaElement.Builder> ... keySchema) {
            this.keySchema(Stream.of(keySchema).map(c -> (KeySchemaElement)((KeySchemaElement.Builder)KeySchemaElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeySchema(Collection<KeySchemaElement.BuilderImpl> keySchema) {
            this.keySchema = KeySchemaCopier.copyFromBuilder(keySchema);
        }

        public final String getTableStatusAsString() {
            return this.tableStatus;
        }

        @Override
        public final Builder tableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
            return this;
        }

        @Override
        public final Builder tableStatus(TableStatus tableStatus) {
            this.tableStatus(tableStatus == null ? null : tableStatus.toString());
            return this;
        }

        public final void setTableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final ProvisionedThroughputDescription.Builder getProvisionedThroughput() {
            return this.provisionedThroughput != null ? this.provisionedThroughput.toBuilder() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughputDescription provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final void setProvisionedThroughput(ProvisionedThroughputDescription.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        public final Long getTableSizeBytes() {
            return this.tableSizeBytes;
        }

        @Override
        public final Builder tableSizeBytes(Long tableSizeBytes) {
            this.tableSizeBytes = tableSizeBytes;
            return this;
        }

        public final void setTableSizeBytes(Long tableSizeBytes) {
            this.tableSizeBytes = tableSizeBytes;
        }

        public final Long getItemCount() {
            return this.itemCount;
        }

        @Override
        public final Builder itemCount(Long itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final void setItemCount(Long itemCount) {
            this.itemCount = itemCount;
        }

        public final String getTableArn() {
            return this.tableArn;
        }

        @Override
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        public final String getTableId() {
            return this.tableId;
        }

        @Override
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        public final BillingModeSummary.Builder getBillingModeSummary() {
            return this.billingModeSummary != null ? this.billingModeSummary.toBuilder() : null;
        }

        @Override
        public final Builder billingModeSummary(BillingModeSummary billingModeSummary) {
            this.billingModeSummary = billingModeSummary;
            return this;
        }

        public final void setBillingModeSummary(BillingModeSummary.BuilderImpl billingModeSummary) {
            this.billingModeSummary = billingModeSummary != null ? billingModeSummary.build() : null;
        }

        public final Collection<LocalSecondaryIndexDescription.Builder> getLocalSecondaryIndexes() {
            return this.localSecondaryIndexes != null ? (Collection)this.localSecondaryIndexes.stream().map(LocalSecondaryIndexDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder localSecondaryIndexes(Collection<LocalSecondaryIndexDescription> localSecondaryIndexes) {
            this.localSecondaryIndexes = LocalSecondaryIndexDescriptionListCopier.copy(localSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexes(LocalSecondaryIndexDescription ... localSecondaryIndexes) {
            this.localSecondaryIndexes(Arrays.asList(localSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexes(Consumer<LocalSecondaryIndexDescription.Builder> ... localSecondaryIndexes) {
            this.localSecondaryIndexes(Stream.of(localSecondaryIndexes).map(c -> (LocalSecondaryIndexDescription)((LocalSecondaryIndexDescription.Builder)LocalSecondaryIndexDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLocalSecondaryIndexes(Collection<LocalSecondaryIndexDescription.BuilderImpl> localSecondaryIndexes) {
            this.localSecondaryIndexes = LocalSecondaryIndexDescriptionListCopier.copyFromBuilder(localSecondaryIndexes);
        }

        public final Collection<GlobalSecondaryIndexDescription.Builder> getGlobalSecondaryIndexes() {
            return this.globalSecondaryIndexes != null ? (Collection)this.globalSecondaryIndexes.stream().map(GlobalSecondaryIndexDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndexDescription> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexDescriptionListCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(GlobalSecondaryIndexDescription ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(Consumer<GlobalSecondaryIndexDescription.Builder> ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Stream.of(globalSecondaryIndexes).map(c -> (GlobalSecondaryIndexDescription)((GlobalSecondaryIndexDescription.Builder)GlobalSecondaryIndexDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalSecondaryIndexes(Collection<GlobalSecondaryIndexDescription.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexDescriptionListCopier.copyFromBuilder(globalSecondaryIndexes);
        }

        public final StreamSpecification.Builder getStreamSpecification() {
            return this.streamSpecification != null ? this.streamSpecification.toBuilder() : null;
        }

        @Override
        public final Builder streamSpecification(StreamSpecification streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        public final void setStreamSpecification(StreamSpecification.BuilderImpl streamSpecification) {
            this.streamSpecification = streamSpecification != null ? streamSpecification.build() : null;
        }

        public final String getLatestStreamLabel() {
            return this.latestStreamLabel;
        }

        @Override
        public final Builder latestStreamLabel(String latestStreamLabel) {
            this.latestStreamLabel = latestStreamLabel;
            return this;
        }

        public final void setLatestStreamLabel(String latestStreamLabel) {
            this.latestStreamLabel = latestStreamLabel;
        }

        public final String getLatestStreamArn() {
            return this.latestStreamArn;
        }

        @Override
        public final Builder latestStreamArn(String latestStreamArn) {
            this.latestStreamArn = latestStreamArn;
            return this;
        }

        public final void setLatestStreamArn(String latestStreamArn) {
            this.latestStreamArn = latestStreamArn;
        }

        public final RestoreSummary.Builder getRestoreSummary() {
            return this.restoreSummary != null ? this.restoreSummary.toBuilder() : null;
        }

        @Override
        public final Builder restoreSummary(RestoreSummary restoreSummary) {
            this.restoreSummary = restoreSummary;
            return this;
        }

        public final void setRestoreSummary(RestoreSummary.BuilderImpl restoreSummary) {
            this.restoreSummary = restoreSummary != null ? restoreSummary.build() : null;
        }

        public final SSEDescription.Builder getSseDescription() {
            return this.sseDescription != null ? this.sseDescription.toBuilder() : null;
        }

        @Override
        public final Builder sseDescription(SSEDescription sseDescription) {
            this.sseDescription = sseDescription;
            return this;
        }

        public final void setSseDescription(SSEDescription.BuilderImpl sseDescription) {
            this.sseDescription = sseDescription != null ? sseDescription.build() : null;
        }

        public TableDescription build() {
            return new TableDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableDescription> {
        public Builder attributeDefinitions(Collection<AttributeDefinition> var1);

        public Builder attributeDefinitions(AttributeDefinition ... var1);

        public Builder attributeDefinitions(Consumer<AttributeDefinition.Builder> ... var1);

        public Builder tableName(String var1);

        public Builder keySchema(Collection<KeySchemaElement> var1);

        public Builder keySchema(KeySchemaElement ... var1);

        public Builder keySchema(Consumer<KeySchemaElement.Builder> ... var1);

        public Builder tableStatus(String var1);

        public Builder tableStatus(TableStatus var1);

        public Builder creationDateTime(Instant var1);

        public Builder provisionedThroughput(ProvisionedThroughputDescription var1);

        default public Builder provisionedThroughput(Consumer<ProvisionedThroughputDescription.Builder> provisionedThroughput) {
            return this.provisionedThroughput((ProvisionedThroughputDescription)((ProvisionedThroughputDescription.Builder)ProvisionedThroughputDescription.builder().applyMutation(provisionedThroughput)).build());
        }

        public Builder tableSizeBytes(Long var1);

        public Builder itemCount(Long var1);

        public Builder tableArn(String var1);

        public Builder tableId(String var1);

        public Builder billingModeSummary(BillingModeSummary var1);

        default public Builder billingModeSummary(Consumer<BillingModeSummary.Builder> billingModeSummary) {
            return this.billingModeSummary((BillingModeSummary)((BillingModeSummary.Builder)BillingModeSummary.builder().applyMutation(billingModeSummary)).build());
        }

        public Builder localSecondaryIndexes(Collection<LocalSecondaryIndexDescription> var1);

        public Builder localSecondaryIndexes(LocalSecondaryIndexDescription ... var1);

        public Builder localSecondaryIndexes(Consumer<LocalSecondaryIndexDescription.Builder> ... var1);

        public Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndexDescription> var1);

        public Builder globalSecondaryIndexes(GlobalSecondaryIndexDescription ... var1);

        public Builder globalSecondaryIndexes(Consumer<GlobalSecondaryIndexDescription.Builder> ... var1);

        public Builder streamSpecification(StreamSpecification var1);

        default public Builder streamSpecification(Consumer<StreamSpecification.Builder> streamSpecification) {
            return this.streamSpecification((StreamSpecification)((StreamSpecification.Builder)StreamSpecification.builder().applyMutation(streamSpecification)).build());
        }

        public Builder latestStreamLabel(String var1);

        public Builder latestStreamArn(String var1);

        public Builder restoreSummary(RestoreSummary var1);

        default public Builder restoreSummary(Consumer<RestoreSummary.Builder> restoreSummary) {
            return this.restoreSummary((RestoreSummary)((RestoreSummary.Builder)RestoreSummary.builder().applyMutation(restoreSummary)).build());
        }

        public Builder sseDescription(SSEDescription var1);

        default public Builder sseDescription(Consumer<SSEDescription.Builder> sseDescription) {
            return this.sseDescription((SSEDescription)((SSEDescription.Builder)SSEDescription.builder().applyMutation(sseDescription)).build());
        }
    }
}

