/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsUpdate;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdateListCopier;
import software.amazon.awssdk.services.dynamodb.model.ReplicaSettingsUpdate;
import software.amazon.awssdk.services.dynamodb.model.ReplicaSettingsUpdateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGlobalTableSettingsRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, UpdateGlobalTableSettingsRequest> {
    private static final SdkField<String> GLOBAL_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateGlobalTableSettingsRequest.getter(UpdateGlobalTableSettingsRequest::globalTableName)).setter(UpdateGlobalTableSettingsRequest.setter(Builder::globalTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableName").build()}).build();
    private static final SdkField<String> GLOBAL_TABLE_BILLING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateGlobalTableSettingsRequest.getter(UpdateGlobalTableSettingsRequest::globalTableBillingModeAsString)).setter(UpdateGlobalTableSettingsRequest.setter(Builder::globalTableBillingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableBillingMode").build()}).build();
    private static final SdkField<Long> GLOBAL_TABLE_PROVISIONED_WRITE_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(UpdateGlobalTableSettingsRequest.getter(UpdateGlobalTableSettingsRequest::globalTableProvisionedWriteCapacityUnits)).setter(UpdateGlobalTableSettingsRequest.setter(Builder::globalTableProvisionedWriteCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableProvisionedWriteCapacityUnits").build()}).build();
    private static final SdkField<AutoScalingSettingsUpdate> GLOBAL_TABLE_PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_SETTINGS_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateGlobalTableSettingsRequest.getter(UpdateGlobalTableSettingsRequest::globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate)).setter(UpdateGlobalTableSettingsRequest.setter(Builder::globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate)).constructor(AutoScalingSettingsUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate").build()}).build();
    private static final SdkField<List<GlobalTableGlobalSecondaryIndexSettingsUpdate>> GLOBAL_TABLE_GLOBAL_SECONDARY_INDEX_SETTINGS_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateGlobalTableSettingsRequest.getter(UpdateGlobalTableSettingsRequest::globalTableGlobalSecondaryIndexSettingsUpdate)).setter(UpdateGlobalTableSettingsRequest.setter(Builder::globalTableGlobalSecondaryIndexSettingsUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableGlobalSecondaryIndexSettingsUpdate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlobalTableGlobalSecondaryIndexSettingsUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ReplicaSettingsUpdate>> REPLICA_SETTINGS_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateGlobalTableSettingsRequest.getter(UpdateGlobalTableSettingsRequest::replicaSettingsUpdate)).setter(UpdateGlobalTableSettingsRequest.setter(Builder::replicaSettingsUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaSettingsUpdate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicaSettingsUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_TABLE_NAME_FIELD, GLOBAL_TABLE_BILLING_MODE_FIELD, GLOBAL_TABLE_PROVISIONED_WRITE_CAPACITY_UNITS_FIELD, GLOBAL_TABLE_PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_SETTINGS_UPDATE_FIELD, GLOBAL_TABLE_GLOBAL_SECONDARY_INDEX_SETTINGS_UPDATE_FIELD, REPLICA_SETTINGS_UPDATE_FIELD));
    private final String globalTableName;
    private final String globalTableBillingMode;
    private final Long globalTableProvisionedWriteCapacityUnits;
    private final AutoScalingSettingsUpdate globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate;
    private final List<GlobalTableGlobalSecondaryIndexSettingsUpdate> globalTableGlobalSecondaryIndexSettingsUpdate;
    private final List<ReplicaSettingsUpdate> replicaSettingsUpdate;

    private UpdateGlobalTableSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.globalTableName = builder.globalTableName;
        this.globalTableBillingMode = builder.globalTableBillingMode;
        this.globalTableProvisionedWriteCapacityUnits = builder.globalTableProvisionedWriteCapacityUnits;
        this.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate = builder.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate;
        this.globalTableGlobalSecondaryIndexSettingsUpdate = builder.globalTableGlobalSecondaryIndexSettingsUpdate;
        this.replicaSettingsUpdate = builder.replicaSettingsUpdate;
    }

    public String globalTableName() {
        return this.globalTableName;
    }

    public BillingMode globalTableBillingMode() {
        return BillingMode.fromValue(this.globalTableBillingMode);
    }

    public String globalTableBillingModeAsString() {
        return this.globalTableBillingMode;
    }

    public Long globalTableProvisionedWriteCapacityUnits() {
        return this.globalTableProvisionedWriteCapacityUnits;
    }

    public AutoScalingSettingsUpdate globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate() {
        return this.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate;
    }

    public List<GlobalTableGlobalSecondaryIndexSettingsUpdate> globalTableGlobalSecondaryIndexSettingsUpdate() {
        return this.globalTableGlobalSecondaryIndexSettingsUpdate;
    }

    public List<ReplicaSettingsUpdate> replicaSettingsUpdate() {
        return this.replicaSettingsUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.globalTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalTableBillingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalTableProvisionedWriteCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalTableGlobalSecondaryIndexSettingsUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaSettingsUpdate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGlobalTableSettingsRequest)) {
            return false;
        }
        UpdateGlobalTableSettingsRequest other = (UpdateGlobalTableSettingsRequest)((Object)obj);
        return Objects.equals(this.globalTableName(), other.globalTableName()) && Objects.equals(this.globalTableBillingModeAsString(), other.globalTableBillingModeAsString()) && Objects.equals(this.globalTableProvisionedWriteCapacityUnits(), other.globalTableProvisionedWriteCapacityUnits()) && Objects.equals(this.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate(), other.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate()) && Objects.equals(this.globalTableGlobalSecondaryIndexSettingsUpdate(), other.globalTableGlobalSecondaryIndexSettingsUpdate()) && Objects.equals(this.replicaSettingsUpdate(), other.replicaSettingsUpdate());
    }

    public String toString() {
        return ToString.builder((String)"UpdateGlobalTableSettingsRequest").add("GlobalTableName", (Object)this.globalTableName()).add("GlobalTableBillingMode", (Object)this.globalTableBillingModeAsString()).add("GlobalTableProvisionedWriteCapacityUnits", (Object)this.globalTableProvisionedWriteCapacityUnits()).add("GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate", (Object)this.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate()).add("GlobalTableGlobalSecondaryIndexSettingsUpdate", this.globalTableGlobalSecondaryIndexSettingsUpdate()).add("ReplicaSettingsUpdate", this.replicaSettingsUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalTableName": {
                return Optional.ofNullable(clazz.cast(this.globalTableName()));
            }
            case "GlobalTableBillingMode": {
                return Optional.ofNullable(clazz.cast(this.globalTableBillingModeAsString()));
            }
            case "GlobalTableProvisionedWriteCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.globalTableProvisionedWriteCapacityUnits()));
            }
            case "GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate": {
                return Optional.ofNullable(clazz.cast(this.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate()));
            }
            case "GlobalTableGlobalSecondaryIndexSettingsUpdate": {
                return Optional.ofNullable(clazz.cast(this.globalTableGlobalSecondaryIndexSettingsUpdate()));
            }
            case "ReplicaSettingsUpdate": {
                return Optional.ofNullable(clazz.cast(this.replicaSettingsUpdate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGlobalTableSettingsRequest, T> g) {
        return obj -> g.apply((UpdateGlobalTableSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private String globalTableName;
        private String globalTableBillingMode;
        private Long globalTableProvisionedWriteCapacityUnits;
        private AutoScalingSettingsUpdate globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate;
        private List<GlobalTableGlobalSecondaryIndexSettingsUpdate> globalTableGlobalSecondaryIndexSettingsUpdate = DefaultSdkAutoConstructList.getInstance();
        private List<ReplicaSettingsUpdate> replicaSettingsUpdate = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGlobalTableSettingsRequest model) {
            super(model);
            this.globalTableName(model.globalTableName);
            this.globalTableBillingMode(model.globalTableBillingMode);
            this.globalTableProvisionedWriteCapacityUnits(model.globalTableProvisionedWriteCapacityUnits);
            this.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate(model.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate);
            this.globalTableGlobalSecondaryIndexSettingsUpdate(model.globalTableGlobalSecondaryIndexSettingsUpdate);
            this.replicaSettingsUpdate(model.replicaSettingsUpdate);
        }

        public final String getGlobalTableName() {
            return this.globalTableName;
        }

        @Override
        public final Builder globalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
            return this;
        }

        public final void setGlobalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
        }

        public final String getGlobalTableBillingModeAsString() {
            return this.globalTableBillingMode;
        }

        @Override
        public final Builder globalTableBillingMode(String globalTableBillingMode) {
            this.globalTableBillingMode = globalTableBillingMode;
            return this;
        }

        @Override
        public final Builder globalTableBillingMode(BillingMode globalTableBillingMode) {
            this.globalTableBillingMode(globalTableBillingMode.toString());
            return this;
        }

        public final void setGlobalTableBillingMode(String globalTableBillingMode) {
            this.globalTableBillingMode = globalTableBillingMode;
        }

        public final Long getGlobalTableProvisionedWriteCapacityUnits() {
            return this.globalTableProvisionedWriteCapacityUnits;
        }

        @Override
        public final Builder globalTableProvisionedWriteCapacityUnits(Long globalTableProvisionedWriteCapacityUnits) {
            this.globalTableProvisionedWriteCapacityUnits = globalTableProvisionedWriteCapacityUnits;
            return this;
        }

        public final void setGlobalTableProvisionedWriteCapacityUnits(Long globalTableProvisionedWriteCapacityUnits) {
            this.globalTableProvisionedWriteCapacityUnits = globalTableProvisionedWriteCapacityUnits;
        }

        public final AutoScalingSettingsUpdate.Builder getGlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate() {
            return this.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate != null ? this.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate.toBuilder() : null;
        }

        @Override
        public final Builder globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate) {
            this.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate = globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate;
            return this;
        }

        public final void setGlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate.BuilderImpl globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate) {
            this.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate = globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate != null ? globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate.build() : null;
        }

        public final Collection<GlobalTableGlobalSecondaryIndexSettingsUpdate.Builder> getGlobalTableGlobalSecondaryIndexSettingsUpdate() {
            return this.globalTableGlobalSecondaryIndexSettingsUpdate != null ? (Collection)this.globalTableGlobalSecondaryIndexSettingsUpdate.stream().map(GlobalTableGlobalSecondaryIndexSettingsUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder globalTableGlobalSecondaryIndexSettingsUpdate(Collection<GlobalTableGlobalSecondaryIndexSettingsUpdate> globalTableGlobalSecondaryIndexSettingsUpdate) {
            this.globalTableGlobalSecondaryIndexSettingsUpdate = GlobalTableGlobalSecondaryIndexSettingsUpdateListCopier.copy(globalTableGlobalSecondaryIndexSettingsUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalTableGlobalSecondaryIndexSettingsUpdate(GlobalTableGlobalSecondaryIndexSettingsUpdate ... globalTableGlobalSecondaryIndexSettingsUpdate) {
            this.globalTableGlobalSecondaryIndexSettingsUpdate(Arrays.asList(globalTableGlobalSecondaryIndexSettingsUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalTableGlobalSecondaryIndexSettingsUpdate(Consumer<GlobalTableGlobalSecondaryIndexSettingsUpdate.Builder> ... globalTableGlobalSecondaryIndexSettingsUpdate) {
            this.globalTableGlobalSecondaryIndexSettingsUpdate(Stream.of(globalTableGlobalSecondaryIndexSettingsUpdate).map(c -> (GlobalTableGlobalSecondaryIndexSettingsUpdate)((GlobalTableGlobalSecondaryIndexSettingsUpdate.Builder)GlobalTableGlobalSecondaryIndexSettingsUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalTableGlobalSecondaryIndexSettingsUpdate(Collection<GlobalTableGlobalSecondaryIndexSettingsUpdate.BuilderImpl> globalTableGlobalSecondaryIndexSettingsUpdate) {
            this.globalTableGlobalSecondaryIndexSettingsUpdate = GlobalTableGlobalSecondaryIndexSettingsUpdateListCopier.copyFromBuilder(globalTableGlobalSecondaryIndexSettingsUpdate);
        }

        public final Collection<ReplicaSettingsUpdate.Builder> getReplicaSettingsUpdate() {
            return this.replicaSettingsUpdate != null ? (Collection)this.replicaSettingsUpdate.stream().map(ReplicaSettingsUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicaSettingsUpdate(Collection<ReplicaSettingsUpdate> replicaSettingsUpdate) {
            this.replicaSettingsUpdate = ReplicaSettingsUpdateListCopier.copy(replicaSettingsUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaSettingsUpdate(ReplicaSettingsUpdate ... replicaSettingsUpdate) {
            this.replicaSettingsUpdate(Arrays.asList(replicaSettingsUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaSettingsUpdate(Consumer<ReplicaSettingsUpdate.Builder> ... replicaSettingsUpdate) {
            this.replicaSettingsUpdate(Stream.of(replicaSettingsUpdate).map(c -> (ReplicaSettingsUpdate)((ReplicaSettingsUpdate.Builder)ReplicaSettingsUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicaSettingsUpdate(Collection<ReplicaSettingsUpdate.BuilderImpl> replicaSettingsUpdate) {
            this.replicaSettingsUpdate = ReplicaSettingsUpdateListCopier.copyFromBuilder(replicaSettingsUpdate);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGlobalTableSettingsRequest build() {
            return new UpdateGlobalTableSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGlobalTableSettingsRequest> {
        public Builder globalTableName(String var1);

        public Builder globalTableBillingMode(String var1);

        public Builder globalTableBillingMode(BillingMode var1);

        public Builder globalTableProvisionedWriteCapacityUnits(Long var1);

        public Builder globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate var1);

        default public Builder globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate(Consumer<AutoScalingSettingsUpdate.Builder> globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate) {
            return this.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate((AutoScalingSettingsUpdate)((AutoScalingSettingsUpdate.Builder)AutoScalingSettingsUpdate.builder().applyMutation(globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate)).build());
        }

        public Builder globalTableGlobalSecondaryIndexSettingsUpdate(Collection<GlobalTableGlobalSecondaryIndexSettingsUpdate> var1);

        public Builder globalTableGlobalSecondaryIndexSettingsUpdate(GlobalTableGlobalSecondaryIndexSettingsUpdate ... var1);

        public Builder globalTableGlobalSecondaryIndexSettingsUpdate(Consumer<GlobalTableGlobalSecondaryIndexSettingsUpdate.Builder> ... var1);

        public Builder replicaSettingsUpdate(Collection<ReplicaSettingsUpdate> var1);

        public Builder replicaSettingsUpdate(ReplicaSettingsUpdate ... var1);

        public Builder replicaSettingsUpdate(Consumer<ReplicaSettingsUpdate.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

