/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb;

import java.time.Duration;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.awscore.retry.AwsRetryPolicy;
import software.amazon.awssdk.core.internal.retry.SdkDefaultRetrySetting;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FullJitterBackoffStrategy;

@SdkProtectedApi
public final class DynamoDbRetryPolicy {
    private static final int DEFAULT_MAX_ERROR_RETRY = 8;
    private static final Duration DEFAULT_BASE_DELAY = Duration.ofMillis(25L);
    private static final BackoffStrategy DEFAULT_BACKOFF_STRATEGY = FullJitterBackoffStrategy.builder().baseDelay(DEFAULT_BASE_DELAY).maxBackoffTime(SdkDefaultRetrySetting.MAX_BACKOFF).build();
    private static final RetryPolicy DEFAULT = AwsRetryPolicy.defaultRetryPolicy().toBuilder().numRetries(Integer.valueOf(8)).backoffStrategy(DEFAULT_BACKOFF_STRATEGY).build();

    private DynamoDbRetryPolicy() {
    }

    public static RetryPolicy defaultPolicy() {
        return DEFAULT;
    }
}

