/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTableResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, CreateTableResponse> {
    private static final SdkField<TableDescription> TABLE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateTableResponse.getter(CreateTableResponse::tableDescription)).setter(CreateTableResponse.setter(Builder::tableDescription)).constructor(TableDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_DESCRIPTION_FIELD));
    private final TableDescription tableDescription;

    private CreateTableResponse(BuilderImpl builder) {
        super(builder);
        this.tableDescription = builder.tableDescription;
    }

    public TableDescription tableDescription() {
        return this.tableDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTableResponse)) {
            return false;
        }
        CreateTableResponse other = (CreateTableResponse)((Object)obj);
        return Objects.equals(this.tableDescription(), other.tableDescription());
    }

    public String toString() {
        return ToString.builder((String)"CreateTableResponse").add("TableDescription", (Object)this.tableDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableDescription": {
                return Optional.ofNullable(clazz.cast(this.tableDescription()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTableResponse, T> g) {
        return obj -> g.apply((CreateTableResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private TableDescription tableDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTableResponse model) {
            super(model);
            this.tableDescription(model.tableDescription);
        }

        public final TableDescription.Builder getTableDescription() {
            return this.tableDescription != null ? this.tableDescription.toBuilder() : null;
        }

        @Override
        public final Builder tableDescription(TableDescription tableDescription) {
            this.tableDescription = tableDescription;
            return this;
        }

        public final void setTableDescription(TableDescription.BuilderImpl tableDescription) {
            this.tableDescription = tableDescription != null ? tableDescription.build() : null;
        }

        @Override
        public CreateTableResponse build() {
            return new CreateTableResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTableResponse> {
        public Builder tableDescription(TableDescription var1);

        default public Builder tableDescription(Consumer<TableDescription.Builder> tableDescription) {
            return this.tableDescription((TableDescription)((TableDescription.Builder)TableDescription.builder().applyMutation(tableDescription)).build());
        }
    }
}

