/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.StreamViewType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamSpecification> {
    private static final SdkField<Boolean> STREAM_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(StreamSpecification.getter(StreamSpecification::streamEnabled)).setter(StreamSpecification.setter(Builder::streamEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamEnabled").build()}).build();
    private static final SdkField<String> STREAM_VIEW_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StreamSpecification.getter(StreamSpecification::streamViewTypeAsString)).setter(StreamSpecification.setter(Builder::streamViewType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamViewType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ENABLED_FIELD, STREAM_VIEW_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean streamEnabled;
    private final String streamViewType;

    private StreamSpecification(BuilderImpl builder) {
        this.streamEnabled = builder.streamEnabled;
        this.streamViewType = builder.streamViewType;
    }

    public Boolean streamEnabled() {
        return this.streamEnabled;
    }

    public StreamViewType streamViewType() {
        return StreamViewType.fromValue(this.streamViewType);
    }

    public String streamViewTypeAsString() {
        return this.streamViewType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamViewTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamSpecification)) {
            return false;
        }
        StreamSpecification other = (StreamSpecification)obj;
        return Objects.equals(this.streamEnabled(), other.streamEnabled()) && Objects.equals(this.streamViewTypeAsString(), other.streamViewTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"StreamSpecification").add("StreamEnabled", (Object)this.streamEnabled()).add("StreamViewType", (Object)this.streamViewTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamEnabled": {
                return Optional.ofNullable(clazz.cast(this.streamEnabled()));
            }
            case "StreamViewType": {
                return Optional.ofNullable(clazz.cast(this.streamViewTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamSpecification, T> g) {
        return obj -> g.apply((StreamSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean streamEnabled;
        private String streamViewType;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamSpecification model) {
            this.streamEnabled(model.streamEnabled);
            this.streamViewType(model.streamViewType);
        }

        public final Boolean getStreamEnabled() {
            return this.streamEnabled;
        }

        @Override
        public final Builder streamEnabled(Boolean streamEnabled) {
            this.streamEnabled = streamEnabled;
            return this;
        }

        public final void setStreamEnabled(Boolean streamEnabled) {
            this.streamEnabled = streamEnabled;
        }

        public final String getStreamViewTypeAsString() {
            return this.streamViewType;
        }

        @Override
        public final Builder streamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
            return this;
        }

        @Override
        public final Builder streamViewType(StreamViewType streamViewType) {
            this.streamViewType(streamViewType.toString());
            return this;
        }

        public final void setStreamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
        }

        public StreamSpecification build() {
            return new StreamSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamSpecification> {
        public Builder streamEnabled(Boolean var1);

        public Builder streamViewType(String var1);

        public Builder streamViewType(StreamViewType var1);
    }
}

