/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class PartiQLBatchRequestCopier {
    static List<BatchStatementRequest> copy(Collection<? extends BatchStatementRequest> partiQLBatchRequestParam) {
        List<BatchStatementRequest> list;
        if (partiQLBatchRequestParam == null || partiQLBatchRequestParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchStatementRequest> modifiableList = new ArrayList<>(partiQLBatchRequestParam.size());
            partiQLBatchRequestParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BatchStatementRequest> copyFromBuilder(
            Collection<? extends BatchStatementRequest.Builder> partiQLBatchRequestParam) {
        List<BatchStatementRequest> list;
        if (partiQLBatchRequestParam == null || partiQLBatchRequestParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchStatementRequest> modifiableList = new ArrayList<>(partiQLBatchRequestParam.size());
            partiQLBatchRequestParam.forEach(entry -> {
                BatchStatementRequest member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BatchStatementRequest.Builder> copyToBuilder(Collection<? extends BatchStatementRequest> partiQLBatchRequestParam) {
        List<BatchStatementRequest.Builder> list;
        if (partiQLBatchRequestParam == null || partiQLBatchRequestParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchStatementRequest.Builder> modifiableList = new ArrayList<>(partiQLBatchRequestParam.size());
            partiQLBatchRequestParam.forEach(entry -> {
                BatchStatementRequest.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
