/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a Contributor Insights summary entry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContributorInsightsSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ContributorInsightsSummary.Builder, ContributorInsightsSummary> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(ContributorInsightsSummary::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(ContributorInsightsSummary::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final SdkField<String> CONTRIBUTOR_INSIGHTS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContributorInsightsStatus")
            .getter(getter(ContributorInsightsSummary::contributorInsightsStatusAsString))
            .setter(setter(Builder::contributorInsightsStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributorInsightsStatus").build())
            .build();

    private static final SdkField<String> CONTRIBUTOR_INSIGHTS_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContributorInsightsMode").getter(getter(ContributorInsightsSummary::contributorInsightsModeAsString))
            .setter(setter(Builder::contributorInsightsMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributorInsightsMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD,
            INDEX_NAME_FIELD, CONTRIBUTOR_INSIGHTS_STATUS_FIELD, CONTRIBUTOR_INSIGHTS_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tableName;

    private final String indexName;

    private final String contributorInsightsStatus;

    private final String contributorInsightsMode;

    private ContributorInsightsSummary(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.indexName = builder.indexName;
        this.contributorInsightsStatus = builder.contributorInsightsStatus;
        this.contributorInsightsMode = builder.contributorInsightsMode;
    }

    /**
     * <p>
     * Name of the table associated with the summary.
     * </p>
     * 
     * @return Name of the table associated with the summary.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * Name of the index associated with the summary, if any.
     * </p>
     * 
     * @return Name of the index associated with the summary, if any.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * Describes the current status for contributor insights for the given table and index, if applicable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contributorInsightsStatus} will return {@link ContributorInsightsStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contributorInsightsStatusAsString}.
     * </p>
     * 
     * @return Describes the current status for contributor insights for the given table and index, if applicable.
     * @see ContributorInsightsStatus
     */
    public final ContributorInsightsStatus contributorInsightsStatus() {
        return ContributorInsightsStatus.fromValue(contributorInsightsStatus);
    }

    /**
     * <p>
     * Describes the current status for contributor insights for the given table and index, if applicable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contributorInsightsStatus} will return {@link ContributorInsightsStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contributorInsightsStatusAsString}.
     * </p>
     * 
     * @return Describes the current status for contributor insights for the given table and index, if applicable.
     * @see ContributorInsightsStatus
     */
    public final String contributorInsightsStatusAsString() {
        return contributorInsightsStatus;
    }

    /**
     * <p>
     * Indicates the current mode of CloudWatch Contributor Insights, specifying whether it tracks all access and
     * throttled events or throttled events only for the DynamoDB table or index.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contributorInsightsMode} will return {@link ContributorInsightsMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contributorInsightsModeAsString}.
     * </p>
     * 
     * @return Indicates the current mode of CloudWatch Contributor Insights, specifying whether it tracks all access
     *         and throttled events or throttled events only for the DynamoDB table or index.
     * @see ContributorInsightsMode
     */
    public final ContributorInsightsMode contributorInsightsMode() {
        return ContributorInsightsMode.fromValue(contributorInsightsMode);
    }

    /**
     * <p>
     * Indicates the current mode of CloudWatch Contributor Insights, specifying whether it tracks all access and
     * throttled events or throttled events only for the DynamoDB table or index.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contributorInsightsMode} will return {@link ContributorInsightsMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contributorInsightsModeAsString}.
     * </p>
     * 
     * @return Indicates the current mode of CloudWatch Contributor Insights, specifying whether it tracks all access
     *         and throttled events or throttled events only for the DynamoDB table or index.
     * @see ContributorInsightsMode
     */
    public final String contributorInsightsModeAsString() {
        return contributorInsightsMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(contributorInsightsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contributorInsightsModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContributorInsightsSummary)) {
            return false;
        }
        ContributorInsightsSummary other = (ContributorInsightsSummary) obj;
        return Objects.equals(tableName(), other.tableName()) && Objects.equals(indexName(), other.indexName())
                && Objects.equals(contributorInsightsStatusAsString(), other.contributorInsightsStatusAsString())
                && Objects.equals(contributorInsightsModeAsString(), other.contributorInsightsModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContributorInsightsSummary").add("TableName", tableName()).add("IndexName", indexName())
                .add("ContributorInsightsStatus", contributorInsightsStatusAsString())
                .add("ContributorInsightsMode", contributorInsightsModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "ContributorInsightsStatus":
            return Optional.ofNullable(clazz.cast(contributorInsightsStatusAsString()));
        case "ContributorInsightsMode":
            return Optional.ofNullable(clazz.cast(contributorInsightsModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("IndexName", INDEX_NAME_FIELD);
        map.put("ContributorInsightsStatus", CONTRIBUTOR_INSIGHTS_STATUS_FIELD);
        map.put("ContributorInsightsMode", CONTRIBUTOR_INSIGHTS_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContributorInsightsSummary, T> g) {
        return obj -> g.apply((ContributorInsightsSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContributorInsightsSummary> {
        /**
         * <p>
         * Name of the table associated with the summary.
         * </p>
         * 
         * @param tableName
         *        Name of the table associated with the summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * Name of the index associated with the summary, if any.
         * </p>
         * 
         * @param indexName
         *        Name of the index associated with the summary, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * Describes the current status for contributor insights for the given table and index, if applicable.
         * </p>
         * 
         * @param contributorInsightsStatus
         *        Describes the current status for contributor insights for the given table and index, if applicable.
         * @see ContributorInsightsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContributorInsightsStatus
         */
        Builder contributorInsightsStatus(String contributorInsightsStatus);

        /**
         * <p>
         * Describes the current status for contributor insights for the given table and index, if applicable.
         * </p>
         * 
         * @param contributorInsightsStatus
         *        Describes the current status for contributor insights for the given table and index, if applicable.
         * @see ContributorInsightsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContributorInsightsStatus
         */
        Builder contributorInsightsStatus(ContributorInsightsStatus contributorInsightsStatus);

        /**
         * <p>
         * Indicates the current mode of CloudWatch Contributor Insights, specifying whether it tracks all access and
         * throttled events or throttled events only for the DynamoDB table or index.
         * </p>
         * 
         * @param contributorInsightsMode
         *        Indicates the current mode of CloudWatch Contributor Insights, specifying whether it tracks all access
         *        and throttled events or throttled events only for the DynamoDB table or index.
         * @see ContributorInsightsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContributorInsightsMode
         */
        Builder contributorInsightsMode(String contributorInsightsMode);

        /**
         * <p>
         * Indicates the current mode of CloudWatch Contributor Insights, specifying whether it tracks all access and
         * throttled events or throttled events only for the DynamoDB table or index.
         * </p>
         * 
         * @param contributorInsightsMode
         *        Indicates the current mode of CloudWatch Contributor Insights, specifying whether it tracks all access
         *        and throttled events or throttled events only for the DynamoDB table or index.
         * @see ContributorInsightsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContributorInsightsMode
         */
        Builder contributorInsightsMode(ContributorInsightsMode contributorInsightsMode);
    }

    static final class BuilderImpl implements Builder {
        private String tableName;

        private String indexName;

        private String contributorInsightsStatus;

        private String contributorInsightsMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ContributorInsightsSummary model) {
            tableName(model.tableName);
            indexName(model.indexName);
            contributorInsightsStatus(model.contributorInsightsStatus);
            contributorInsightsMode(model.contributorInsightsMode);
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getContributorInsightsStatus() {
            return contributorInsightsStatus;
        }

        public final void setContributorInsightsStatus(String contributorInsightsStatus) {
            this.contributorInsightsStatus = contributorInsightsStatus;
        }

        @Override
        public final Builder contributorInsightsStatus(String contributorInsightsStatus) {
            this.contributorInsightsStatus = contributorInsightsStatus;
            return this;
        }

        @Override
        public final Builder contributorInsightsStatus(ContributorInsightsStatus contributorInsightsStatus) {
            this.contributorInsightsStatus(contributorInsightsStatus == null ? null : contributorInsightsStatus.toString());
            return this;
        }

        public final String getContributorInsightsMode() {
            return contributorInsightsMode;
        }

        public final void setContributorInsightsMode(String contributorInsightsMode) {
            this.contributorInsightsMode = contributorInsightsMode;
        }

        @Override
        public final Builder contributorInsightsMode(String contributorInsightsMode) {
            this.contributorInsightsMode = contributorInsightsMode;
            return this;
        }

        @Override
        public final Builder contributorInsightsMode(ContributorInsightsMode contributorInsightsMode) {
            this.contributorInsightsMode(contributorInsightsMode == null ? null : contributorInsightsMode.toString());
            return this;
        }

        @Override
        public ContributorInsightsSummary build() {
            return new ContributorInsightsSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
