/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.endpoints.internal;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.awscore.endpoints.AccountIdEndpointMode;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.EndpointAuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.awscore.internal.useragent.BusinessMetricsUtils;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SelectedAuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.useragent.BusinessMetricCollection;
import software.amazon.awssdk.core.useragent.BusinessMetricFeatureId;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4aHttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.RegionSet;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.services.dynamodb.endpoints.DynamoDbEndpointParams;
import software.amazon.awssdk.services.dynamodb.endpoints.DynamoDbEndpointProvider;
import software.amazon.awssdk.services.dynamodb.endpoints.internal.AwsEndpointProviderUtils;
import software.amazon.awssdk.services.dynamodb.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeExportRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeImportRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.dynamodb.model.ImportTableRequest;
import software.amazon.awssdk.services.dynamodb.model.ListBackupsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListExportsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListImportsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.TagResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.UntagResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveRequest;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
public final class DynamoDbResolveEndpointInterceptor
implements ExecutionInterceptor {
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        SdkRequest result = context.request();
        if (AwsEndpointProviderUtils.endpointIsDiscovered(executionAttributes)) {
            return result;
        }
        DynamoDbEndpointProvider provider = (DynamoDbEndpointProvider)executionAttributes.getAttribute(SdkInternalExecutionAttribute.ENDPOINT_PROVIDER);
        try {
            Optional<String> hostPrefix;
            long resolveEndpointStart = System.nanoTime();
            DynamoDbEndpointParams endpointParams = DynamoDbResolveEndpointInterceptor.ruleParams(result, executionAttributes);
            Endpoint endpoint = provider.resolveEndpoint(endpointParams).join();
            Duration resolveEndpointDuration = Duration.ofNanos(System.nanoTime() - resolveEndpointStart);
            Optional metricCollector = executionAttributes.getOptionalAttribute(SdkExecutionAttribute.API_CALL_METRIC_COLLECTOR);
            metricCollector.ifPresent(mc -> mc.reportMetric(CoreMetric.ENDPOINT_RESOLVE_DURATION, (Object)resolveEndpointDuration));
            if (!AwsEndpointProviderUtils.disableHostPrefixInjection(executionAttributes) && (hostPrefix = DynamoDbResolveEndpointInterceptor.hostPrefix((String)executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME), result)).isPresent()) {
                endpoint = AwsEndpointProviderUtils.addHostPrefix(endpoint, hostPrefix.get());
            }
            List endpointAuthSchemes = (List)endpoint.attribute(AwsEndpointAttribute.AUTH_SCHEMES);
            SelectedAuthScheme selectedAuthScheme = (SelectedAuthScheme)executionAttributes.getAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME);
            if (endpointAuthSchemes != null && selectedAuthScheme != null) {
                selectedAuthScheme = this.authSchemeWithEndpointSignerProperties(endpointAuthSchemes, selectedAuthScheme);
                executionAttributes.putAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME, selectedAuthScheme);
            }
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT, (Object)endpoint);
            this.setMetricValues(endpoint, executionAttributes);
            return result;
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SdkClientException) {
                throw (SdkClientException)cause;
            }
            throw SdkClientException.create((String)"Endpoint resolution failed", (Throwable)cause);
        }
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        Endpoint resolvedEndpoint = (Endpoint)executionAttributes.getAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT);
        if (resolvedEndpoint.headers().isEmpty()) {
            return context.httpRequest();
        }
        SdkHttpRequest.Builder httpRequestBuilder = (SdkHttpRequest.Builder)context.httpRequest().toBuilder();
        resolvedEndpoint.headers().forEach((name, values) -> values.forEach(v -> httpRequestBuilder.appendHeader(name, v)));
        return (SdkHttpRequest)httpRequestBuilder.build();
    }

    public static DynamoDbEndpointParams ruleParams(SdkRequest request, ExecutionAttributes executionAttributes) {
        DynamoDbEndpointParams.Builder builder = DynamoDbEndpointParams.builder();
        builder.region(AwsEndpointProviderUtils.regionBuiltIn(executionAttributes));
        builder.useDualStack(AwsEndpointProviderUtils.dualStackEnabledBuiltIn(executionAttributes));
        builder.useFips(AwsEndpointProviderUtils.fipsEnabledBuiltIn(executionAttributes));
        builder.endpoint(AwsEndpointProviderUtils.endpointBuiltIn(executionAttributes));
        builder.accountId(DynamoDbResolveEndpointInterceptor.resolveAndRecordAccountIdFromIdentity(executionAttributes));
        builder.accountIdEndpointMode(DynamoDbResolveEndpointInterceptor.recordAccountIdEndpointMode(executionAttributes));
        DynamoDbResolveEndpointInterceptor.setContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), request);
        DynamoDbResolveEndpointInterceptor.setStaticContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME));
        DynamoDbResolveEndpointInterceptor.setOperationContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), request);
        return builder.build();
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, String operationName, SdkRequest request) {
        switch (operationName) {
            case "CreateBackup": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (CreateBackupRequest)request);
                break;
            }
            case "CreateGlobalTable": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (CreateGlobalTableRequest)request);
                break;
            }
            case "CreateTable": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (CreateTableRequest)request);
                break;
            }
            case "DeleteBackup": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (DeleteBackupRequest)request);
                break;
            }
            case "DeleteItem": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (DeleteItemRequest)request);
                break;
            }
            case "DeleteResourcePolicy": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (DeleteResourcePolicyRequest)request);
                break;
            }
            case "DeleteTable": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (DeleteTableRequest)request);
                break;
            }
            case "DescribeBackup": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (DescribeBackupRequest)request);
                break;
            }
            case "DescribeContinuousBackups": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (DescribeContinuousBackupsRequest)request);
                break;
            }
            case "DescribeContributorInsights": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (DescribeContributorInsightsRequest)request);
                break;
            }
            case "DescribeExport": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (DescribeExportRequest)request);
                break;
            }
            case "DescribeGlobalTable": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (DescribeGlobalTableRequest)request);
                break;
            }
            case "DescribeGlobalTableSettings": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (DescribeGlobalTableSettingsRequest)request);
                break;
            }
            case "DescribeImport": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (DescribeImportRequest)request);
                break;
            }
            case "DescribeKinesisStreamingDestination": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (DescribeKinesisStreamingDestinationRequest)request);
                break;
            }
            case "DescribeTable": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (DescribeTableRequest)request);
                break;
            }
            case "DescribeTableReplicaAutoScaling": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (DescribeTableReplicaAutoScalingRequest)request);
                break;
            }
            case "DescribeTimeToLive": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (DescribeTimeToLiveRequest)request);
                break;
            }
            case "DisableKinesisStreamingDestination": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (DisableKinesisStreamingDestinationRequest)request);
                break;
            }
            case "EnableKinesisStreamingDestination": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (EnableKinesisStreamingDestinationRequest)request);
                break;
            }
            case "ExportTableToPointInTime": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (ExportTableToPointInTimeRequest)request);
                break;
            }
            case "GetItem": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (GetItemRequest)request);
                break;
            }
            case "GetResourcePolicy": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (GetResourcePolicyRequest)request);
                break;
            }
            case "ListBackups": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (ListBackupsRequest)request);
                break;
            }
            case "ListContributorInsights": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (ListContributorInsightsRequest)request);
                break;
            }
            case "ListExports": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (ListExportsRequest)request);
                break;
            }
            case "ListImports": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (ListImportsRequest)request);
                break;
            }
            case "ListTagsOfResource": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (ListTagsOfResourceRequest)request);
                break;
            }
            case "PutItem": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (PutItemRequest)request);
                break;
            }
            case "PutResourcePolicy": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (PutResourcePolicyRequest)request);
                break;
            }
            case "Query": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (QueryRequest)request);
                break;
            }
            case "RestoreTableFromBackup": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (RestoreTableFromBackupRequest)request);
                break;
            }
            case "RestoreTableToPointInTime": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (RestoreTableToPointInTimeRequest)request);
                break;
            }
            case "Scan": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (ScanRequest)request);
                break;
            }
            case "TagResource": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (TagResourceRequest)request);
                break;
            }
            case "UntagResource": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (UntagResourceRequest)request);
                break;
            }
            case "UpdateContinuousBackups": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (UpdateContinuousBackupsRequest)request);
                break;
            }
            case "UpdateContributorInsights": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (UpdateContributorInsightsRequest)request);
                break;
            }
            case "UpdateGlobalTable": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (UpdateGlobalTableRequest)request);
                break;
            }
            case "UpdateGlobalTableSettings": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (UpdateGlobalTableSettingsRequest)request);
                break;
            }
            case "UpdateItem": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (UpdateItemRequest)request);
                break;
            }
            case "UpdateKinesisStreamingDestination": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (UpdateKinesisStreamingDestinationRequest)request);
                break;
            }
            case "UpdateTable": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (UpdateTableRequest)request);
                break;
            }
            case "UpdateTableReplicaAutoScaling": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (UpdateTableReplicaAutoScalingRequest)request);
                break;
            }
            case "UpdateTimeToLive": {
                DynamoDbResolveEndpointInterceptor.setContextParams(params, (UpdateTimeToLiveRequest)request);
                break;
            }
        }
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, CreateBackupRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, CreateGlobalTableRequest request) {
        params.resourceArn(request.globalTableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, CreateTableRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, DeleteBackupRequest request) {
        params.resourceArn(request.backupArn());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, DeleteItemRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, DeleteResourcePolicyRequest request) {
        params.resourceArn(request.resourceArn());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, DeleteTableRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, DescribeBackupRequest request) {
        params.resourceArn(request.backupArn());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, DescribeContinuousBackupsRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, DescribeContributorInsightsRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, DescribeExportRequest request) {
        params.resourceArn(request.exportArn());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, DescribeGlobalTableRequest request) {
        params.resourceArn(request.globalTableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, DescribeGlobalTableSettingsRequest request) {
        params.resourceArn(request.globalTableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, DescribeImportRequest request) {
        params.resourceArn(request.importArn());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, DescribeKinesisStreamingDestinationRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, DescribeTableRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, DescribeTableReplicaAutoScalingRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, DescribeTimeToLiveRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, DisableKinesisStreamingDestinationRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, EnableKinesisStreamingDestinationRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, ExportTableToPointInTimeRequest request) {
        params.resourceArn(request.tableArn());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, GetItemRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, GetResourcePolicyRequest request) {
        params.resourceArn(request.resourceArn());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, ListBackupsRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, ListContributorInsightsRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, ListExportsRequest request) {
        params.resourceArn(request.tableArn());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, ListImportsRequest request) {
        params.resourceArn(request.tableArn());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, ListTagsOfResourceRequest request) {
        params.resourceArn(request.resourceArn());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, PutItemRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, PutResourcePolicyRequest request) {
        params.resourceArn(request.resourceArn());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, QueryRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, RestoreTableFromBackupRequest request) {
        params.resourceArn(request.targetTableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, RestoreTableToPointInTimeRequest request) {
        params.resourceArn(request.targetTableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, ScanRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, TagResourceRequest request) {
        params.resourceArn(request.resourceArn());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, UntagResourceRequest request) {
        params.resourceArn(request.resourceArn());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, UpdateContinuousBackupsRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, UpdateContributorInsightsRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, UpdateGlobalTableRequest request) {
        params.resourceArn(request.globalTableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, UpdateGlobalTableSettingsRequest request) {
        params.resourceArn(request.globalTableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, UpdateItemRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, UpdateKinesisStreamingDestinationRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, UpdateTableRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, UpdateTableReplicaAutoScalingRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setContextParams(DynamoDbEndpointParams.Builder params, UpdateTimeToLiveRequest request) {
        params.resourceArn(request.tableName());
    }

    private static void setStaticContextParams(DynamoDbEndpointParams.Builder params, String operationName) {
    }

    private <T extends Identity> SelectedAuthScheme<T> authSchemeWithEndpointSignerProperties(List<EndpointAuthScheme> endpointAuthSchemes, SelectedAuthScheme<T> selectedAuthScheme) {
        for (EndpointAuthScheme endpointAuthScheme : endpointAuthSchemes) {
            if (!endpointAuthScheme.schemeId().equals(selectedAuthScheme.authSchemeOption().schemeId())) continue;
            AuthSchemeOption.Builder option = (AuthSchemeOption.Builder)selectedAuthScheme.authSchemeOption().toBuilder();
            if (endpointAuthScheme instanceof SigV4AuthScheme) {
                SigV4AuthScheme v4AuthScheme = (SigV4AuthScheme)endpointAuthScheme;
                if (v4AuthScheme.isDisableDoubleEncodingSet()) {
                    option.putSignerProperty(AwsV4HttpSigner.DOUBLE_URL_ENCODE, (Object)(!v4AuthScheme.disableDoubleEncoding() ? 1 : 0));
                }
                if (v4AuthScheme.signingRegion() != null) {
                    option.putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)v4AuthScheme.signingRegion());
                }
                if (v4AuthScheme.signingName() != null) {
                    option.putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)v4AuthScheme.signingName());
                }
                return new SelectedAuthScheme(selectedAuthScheme.identity(), selectedAuthScheme.signer(), (AuthSchemeOption)option.build());
            }
            if (endpointAuthScheme instanceof SigV4aAuthScheme) {
                SigV4aAuthScheme v4aAuthScheme = (SigV4aAuthScheme)endpointAuthScheme;
                if (v4aAuthScheme.isDisableDoubleEncodingSet()) {
                    option.putSignerProperty(AwsV4aHttpSigner.DOUBLE_URL_ENCODE, (Object)(!v4aAuthScheme.disableDoubleEncoding() ? 1 : 0));
                }
                if (!CollectionUtils.isNullOrEmpty((Collection)v4aAuthScheme.signingRegionSet())) {
                    RegionSet regionSet = RegionSet.create((Collection)v4aAuthScheme.signingRegionSet());
                    option.putSignerProperty(AwsV4aHttpSigner.REGION_SET, (Object)regionSet);
                }
                if (v4aAuthScheme.signingName() != null) {
                    option.putSignerProperty(AwsV4aHttpSigner.SERVICE_SIGNING_NAME, (Object)v4aAuthScheme.signingName());
                }
                return new SelectedAuthScheme(selectedAuthScheme.identity(), selectedAuthScheme.signer(), (AuthSchemeOption)option.build());
            }
            throw new IllegalArgumentException("Endpoint auth scheme '" + endpointAuthScheme.name() + "' cannot be mapped to the SDK auth scheme. Was it declared in the service's model?");
        }
        return selectedAuthScheme;
    }

    private static void setOperationContextParams(DynamoDbEndpointParams.Builder params, String operationName, SdkRequest request) {
        switch (operationName) {
            case "BatchGetItem": {
                DynamoDbResolveEndpointInterceptor.setOperationContextParams(params, (BatchGetItemRequest)request);
                break;
            }
            case "BatchWriteItem": {
                DynamoDbResolveEndpointInterceptor.setOperationContextParams(params, (BatchWriteItemRequest)request);
                break;
            }
            case "ImportTable": {
                DynamoDbResolveEndpointInterceptor.setOperationContextParams(params, (ImportTableRequest)request);
                break;
            }
            case "TransactGetItems": {
                DynamoDbResolveEndpointInterceptor.setOperationContextParams(params, (TransactGetItemsRequest)request);
                break;
            }
            case "TransactWriteItems": {
                DynamoDbResolveEndpointInterceptor.setOperationContextParams(params, (TransactWriteItemsRequest)request);
                break;
            }
        }
    }

    private static void setOperationContextParams(DynamoDbEndpointParams.Builder params, BatchGetItemRequest request) {
        JmesPathRuntime.Value input = new JmesPathRuntime.Value((Object)request);
        params.resourceArnList(input.field("RequestItems").keys().stringValues());
    }

    private static void setOperationContextParams(DynamoDbEndpointParams.Builder params, BatchWriteItemRequest request) {
        JmesPathRuntime.Value input = new JmesPathRuntime.Value((Object)request);
        params.resourceArnList(input.field("RequestItems").keys().stringValues());
    }

    private static void setOperationContextParams(DynamoDbEndpointParams.Builder params, ImportTableRequest request) {
        JmesPathRuntime.Value input = new JmesPathRuntime.Value((Object)request);
        params.resourceArn(input.field("TableCreationParameters").field("TableName").stringValue());
    }

    private static void setOperationContextParams(DynamoDbEndpointParams.Builder params, TransactGetItemsRequest request) {
        JmesPathRuntime.Value input = new JmesPathRuntime.Value((Object)request);
        params.resourceArnList(input.field("TransactItems").wildcard().field("Get").field("TableName").stringValues());
    }

    private static void setOperationContextParams(DynamoDbEndpointParams.Builder params, TransactWriteItemsRequest request) {
        JmesPathRuntime.Value input = new JmesPathRuntime.Value((Object)request);
        params.resourceArnList(input.field("TransactItems").wildcard().multiSelectList(x0 -> x0.field("ConditionCheck").field("TableName"), x1 -> x1.field("Put").field("TableName"), x2 -> x2.field("Delete").field("TableName"), x3 -> x3.field("Update").field("TableName")).flatten().stringValues());
    }

    private static Optional<String> hostPrefix(String operationName, SdkRequest request) {
        return Optional.empty();
    }

    private static String resolveAndRecordAccountIdFromIdentity(ExecutionAttributes executionAttributes) {
        String accountId = DynamoDbResolveEndpointInterceptor.accountIdFromIdentity((SelectedAuthScheme)executionAttributes.getAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME));
        if (accountId != null) {
            ((BusinessMetricCollection)executionAttributes.getAttribute(SdkInternalExecutionAttribute.BUSINESS_METRICS)).addMetric(BusinessMetricFeatureId.RESOLVED_ACCOUNT_ID.value());
        }
        return accountId;
    }

    private static <T extends Identity> String accountIdFromIdentity(SelectedAuthScheme<T> selectedAuthScheme) {
        Identity identity = (Identity)CompletableFutureUtils.joinLikeSync((CompletableFuture)selectedAuthScheme.identity());
        String accountId = null;
        if (identity instanceof AwsCredentialsIdentity) {
            accountId = ((AwsCredentialsIdentity)identity).accountId().orElse(null);
        }
        return accountId;
    }

    private static String recordAccountIdEndpointMode(ExecutionAttributes executionAttributes) {
        AccountIdEndpointMode mode = (AccountIdEndpointMode)executionAttributes.getAttribute(AwsExecutionAttribute.AWS_AUTH_ACCOUNT_ID_ENDPOINT_MODE);
        BusinessMetricsUtils.resolveAccountIdEndpointModeMetric((AccountIdEndpointMode)mode).ifPresent(m -> ((BusinessMetricCollection)executionAttributes.getAttribute(SdkInternalExecutionAttribute.BUSINESS_METRICS)).addMetric(m));
        return mode.name().toLowerCase();
    }

    private void setMetricValues(Endpoint endpoint, ExecutionAttributes executionAttributes) {
        if (endpoint.attribute(AwsEndpointAttribute.METRIC_VALUES) != null) {
            executionAttributes.getOptionalAttribute(SdkInternalExecutionAttribute.BUSINESS_METRICS).ifPresent(metrics -> ((List)endpoint.attribute(AwsEndpointAttribute.METRIC_VALUES)).forEach(v -> metrics.addMetric(v)));
        }
    }
}

