/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateKinesisStreamingDestinationResponse extends DynamoDbResponse implements
        ToCopyableBuilder<UpdateKinesisStreamingDestinationResponse.Builder, UpdateKinesisStreamingDestinationResponse> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(UpdateKinesisStreamingDestinationResponse::tableName))
            .setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamArn").getter(getter(UpdateKinesisStreamingDestinationResponse::streamArn))
            .setter(setter(Builder::streamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()).build();

    private static final SdkField<String> DESTINATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationStatus").getter(getter(UpdateKinesisStreamingDestinationResponse::destinationStatusAsString))
            .setter(setter(Builder::destinationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationStatus").build()).build();

    private static final SdkField<UpdateKinesisStreamingConfiguration> UPDATE_KINESIS_STREAMING_CONFIGURATION_FIELD = SdkField
            .<UpdateKinesisStreamingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("UpdateKinesisStreamingConfiguration")
            .getter(getter(UpdateKinesisStreamingDestinationResponse::updateKinesisStreamingConfiguration))
            .setter(setter(Builder::updateKinesisStreamingConfiguration))
            .constructor(UpdateKinesisStreamingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("UpdateKinesisStreamingConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD,
            STREAM_ARN_FIELD, DESTINATION_STATUS_FIELD, UPDATE_KINESIS_STREAMING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String tableName;

    private final String streamArn;

    private final String destinationStatus;

    private final UpdateKinesisStreamingConfiguration updateKinesisStreamingConfiguration;

    private UpdateKinesisStreamingDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.streamArn = builder.streamArn;
        this.destinationStatus = builder.destinationStatus;
        this.updateKinesisStreamingConfiguration = builder.updateKinesisStreamingConfiguration;
    }

    /**
     * <p>
     * The table name for the Kinesis streaming destination output.
     * </p>
     * 
     * @return The table name for the Kinesis streaming destination output.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The ARN for the Kinesis stream input.
     * </p>
     * 
     * @return The ARN for the Kinesis stream input.
     */
    public final String streamArn() {
        return streamArn;
    }

    /**
     * <p>
     * The status of the attempt to update the Kinesis streaming destination output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationStatus}
     * will return {@link DestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationStatusAsString}.
     * </p>
     * 
     * @return The status of the attempt to update the Kinesis streaming destination output.
     * @see DestinationStatus
     */
    public final DestinationStatus destinationStatus() {
        return DestinationStatus.fromValue(destinationStatus);
    }

    /**
     * <p>
     * The status of the attempt to update the Kinesis streaming destination output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationStatus}
     * will return {@link DestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationStatusAsString}.
     * </p>
     * 
     * @return The status of the attempt to update the Kinesis streaming destination output.
     * @see DestinationStatus
     */
    public final String destinationStatusAsString() {
        return destinationStatus;
    }

    /**
     * <p>
     * The command to update the Kinesis streaming destination configuration.
     * </p>
     * 
     * @return The command to update the Kinesis streaming destination configuration.
     */
    public final UpdateKinesisStreamingConfiguration updateKinesisStreamingConfiguration() {
        return updateKinesisStreamingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updateKinesisStreamingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKinesisStreamingDestinationResponse)) {
            return false;
        }
        UpdateKinesisStreamingDestinationResponse other = (UpdateKinesisStreamingDestinationResponse) obj;
        return Objects.equals(tableName(), other.tableName()) && Objects.equals(streamArn(), other.streamArn())
                && Objects.equals(destinationStatusAsString(), other.destinationStatusAsString())
                && Objects.equals(updateKinesisStreamingConfiguration(), other.updateKinesisStreamingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateKinesisStreamingDestinationResponse").add("TableName", tableName())
                .add("StreamArn", streamArn()).add("DestinationStatus", destinationStatusAsString())
                .add("UpdateKinesisStreamingConfiguration", updateKinesisStreamingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "StreamArn":
            return Optional.ofNullable(clazz.cast(streamArn()));
        case "DestinationStatus":
            return Optional.ofNullable(clazz.cast(destinationStatusAsString()));
        case "UpdateKinesisStreamingConfiguration":
            return Optional.ofNullable(clazz.cast(updateKinesisStreamingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("StreamArn", STREAM_ARN_FIELD);
        map.put("DestinationStatus", DESTINATION_STATUS_FIELD);
        map.put("UpdateKinesisStreamingConfiguration", UPDATE_KINESIS_STREAMING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateKinesisStreamingDestinationResponse, T> g) {
        return obj -> g.apply((UpdateKinesisStreamingDestinationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DynamoDbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateKinesisStreamingDestinationResponse> {
        /**
         * <p>
         * The table name for the Kinesis streaming destination output.
         * </p>
         * 
         * @param tableName
         *        The table name for the Kinesis streaming destination output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The ARN for the Kinesis stream input.
         * </p>
         * 
         * @param streamArn
         *        The ARN for the Kinesis stream input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);

        /**
         * <p>
         * The status of the attempt to update the Kinesis streaming destination output.
         * </p>
         * 
         * @param destinationStatus
         *        The status of the attempt to update the Kinesis streaming destination output.
         * @see DestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationStatus
         */
        Builder destinationStatus(String destinationStatus);

        /**
         * <p>
         * The status of the attempt to update the Kinesis streaming destination output.
         * </p>
         * 
         * @param destinationStatus
         *        The status of the attempt to update the Kinesis streaming destination output.
         * @see DestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationStatus
         */
        Builder destinationStatus(DestinationStatus destinationStatus);

        /**
         * <p>
         * The command to update the Kinesis streaming destination configuration.
         * </p>
         * 
         * @param updateKinesisStreamingConfiguration
         *        The command to update the Kinesis streaming destination configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateKinesisStreamingConfiguration(UpdateKinesisStreamingConfiguration updateKinesisStreamingConfiguration);

        /**
         * <p>
         * The command to update the Kinesis streaming destination configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateKinesisStreamingConfiguration.Builder} avoiding the need to create one manually via
         * {@link UpdateKinesisStreamingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateKinesisStreamingConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #updateKinesisStreamingConfiguration(UpdateKinesisStreamingConfiguration)}.
         * 
         * @param updateKinesisStreamingConfiguration
         *        a consumer that will call methods on {@link UpdateKinesisStreamingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateKinesisStreamingConfiguration(UpdateKinesisStreamingConfiguration)
         */
        default Builder updateKinesisStreamingConfiguration(
                Consumer<UpdateKinesisStreamingConfiguration.Builder> updateKinesisStreamingConfiguration) {
            return updateKinesisStreamingConfiguration(UpdateKinesisStreamingConfiguration.builder()
                    .applyMutation(updateKinesisStreamingConfiguration).build());
        }
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private String tableName;

        private String streamArn;

        private String destinationStatus;

        private UpdateKinesisStreamingConfiguration updateKinesisStreamingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKinesisStreamingDestinationResponse model) {
            super(model);
            tableName(model.tableName);
            streamArn(model.streamArn);
            destinationStatus(model.destinationStatus);
            updateKinesisStreamingConfiguration(model.updateKinesisStreamingConfiguration);
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getStreamArn() {
            return streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final String getDestinationStatus() {
            return destinationStatus;
        }

        public final void setDestinationStatus(String destinationStatus) {
            this.destinationStatus = destinationStatus;
        }

        @Override
        public final Builder destinationStatus(String destinationStatus) {
            this.destinationStatus = destinationStatus;
            return this;
        }

        @Override
        public final Builder destinationStatus(DestinationStatus destinationStatus) {
            this.destinationStatus(destinationStatus == null ? null : destinationStatus.toString());
            return this;
        }

        public final UpdateKinesisStreamingConfiguration.Builder getUpdateKinesisStreamingConfiguration() {
            return updateKinesisStreamingConfiguration != null ? updateKinesisStreamingConfiguration.toBuilder() : null;
        }

        public final void setUpdateKinesisStreamingConfiguration(
                UpdateKinesisStreamingConfiguration.BuilderImpl updateKinesisStreamingConfiguration) {
            this.updateKinesisStreamingConfiguration = updateKinesisStreamingConfiguration != null ? updateKinesisStreamingConfiguration
                    .build() : null;
        }

        @Override
        public final Builder updateKinesisStreamingConfiguration(
                UpdateKinesisStreamingConfiguration updateKinesisStreamingConfiguration) {
            this.updateKinesisStreamingConfiguration = updateKinesisStreamingConfiguration;
            return this;
        }

        @Override
        public UpdateKinesisStreamingDestinationResponse build() {
            return new UpdateKinesisStreamingDestinationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
