/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.internal.UserAgentUtils;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;

public class QueryIterable
implements SdkIterable<QueryResponse> {
    private final DynamoDbClient client;
    private final QueryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public QueryIterable(DynamoDbClient client, QueryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new QueryResponseFetcher();
    }

    public Iterator<QueryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Map<String, AttributeValue>> items() {
        Function<QueryResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class QueryResponseFetcher
    implements SyncPageFetcher<QueryResponse> {
        private QueryResponseFetcher() {
        }

        public boolean hasNextPage(QueryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.lastEvaluatedKey());
        }

        public QueryResponse nextPage(QueryResponse previousPage) {
            if (previousPage == null) {
                return QueryIterable.this.client.query(QueryIterable.this.firstRequest);
            }
            return QueryIterable.this.client.query((QueryRequest)((Object)QueryIterable.this.firstRequest.toBuilder().exclusiveStartKey(previousPage.lastEvaluatedKey()).build()));
        }
    }
}

