/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The description of the warm throughput value on a global secondary index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlobalSecondaryIndexWarmThroughputDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<GlobalSecondaryIndexWarmThroughputDescription.Builder, GlobalSecondaryIndexWarmThroughputDescription> {
    private static final SdkField<Long> READ_UNITS_PER_SECOND_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ReadUnitsPerSecond").getter(getter(GlobalSecondaryIndexWarmThroughputDescription::readUnitsPerSecond))
            .setter(setter(Builder::readUnitsPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadUnitsPerSecond").build())
            .build();

    private static final SdkField<Long> WRITE_UNITS_PER_SECOND_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("WriteUnitsPerSecond").getter(getter(GlobalSecondaryIndexWarmThroughputDescription::writeUnitsPerSecond))
            .setter(setter(Builder::writeUnitsPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteUnitsPerSecond").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GlobalSecondaryIndexWarmThroughputDescription::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(READ_UNITS_PER_SECOND_FIELD,
            WRITE_UNITS_PER_SECOND_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long readUnitsPerSecond;

    private final Long writeUnitsPerSecond;

    private final String status;

    private GlobalSecondaryIndexWarmThroughputDescription(BuilderImpl builder) {
        this.readUnitsPerSecond = builder.readUnitsPerSecond;
        this.writeUnitsPerSecond = builder.writeUnitsPerSecond;
        this.status = builder.status;
    }

    /**
     * <p>
     * Represents warm throughput read units per second value for a global secondary index.
     * </p>
     * 
     * @return Represents warm throughput read units per second value for a global secondary index.
     */
    public final Long readUnitsPerSecond() {
        return readUnitsPerSecond;
    }

    /**
     * <p>
     * Represents warm throughput write units per second value for a global secondary index.
     * </p>
     * 
     * @return Represents warm throughput write units per second value for a global secondary index.
     */
    public final Long writeUnitsPerSecond() {
        return writeUnitsPerSecond;
    }

    /**
     * <p>
     * Represents the warm throughput status being created or updated on a global secondary index. The status can only
     * be <code>UPDATING</code> or <code>ACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Represents the warm throughput status being created or updated on a global secondary index. The status
     *         can only be <code>UPDATING</code> or <code>ACTIVE</code>.
     * @see IndexStatus
     */
    public final IndexStatus status() {
        return IndexStatus.fromValue(status);
    }

    /**
     * <p>
     * Represents the warm throughput status being created or updated on a global secondary index. The status can only
     * be <code>UPDATING</code> or <code>ACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Represents the warm throughput status being created or updated on a global secondary index. The status
     *         can only be <code>UPDATING</code> or <code>ACTIVE</code>.
     * @see IndexStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(readUnitsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(writeUnitsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalSecondaryIndexWarmThroughputDescription)) {
            return false;
        }
        GlobalSecondaryIndexWarmThroughputDescription other = (GlobalSecondaryIndexWarmThroughputDescription) obj;
        return Objects.equals(readUnitsPerSecond(), other.readUnitsPerSecond())
                && Objects.equals(writeUnitsPerSecond(), other.writeUnitsPerSecond())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GlobalSecondaryIndexWarmThroughputDescription").add("ReadUnitsPerSecond", readUnitsPerSecond())
                .add("WriteUnitsPerSecond", writeUnitsPerSecond()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReadUnitsPerSecond":
            return Optional.ofNullable(clazz.cast(readUnitsPerSecond()));
        case "WriteUnitsPerSecond":
            return Optional.ofNullable(clazz.cast(writeUnitsPerSecond()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReadUnitsPerSecond", READ_UNITS_PER_SECOND_FIELD);
        map.put("WriteUnitsPerSecond", WRITE_UNITS_PER_SECOND_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GlobalSecondaryIndexWarmThroughputDescription, T> g) {
        return obj -> g.apply((GlobalSecondaryIndexWarmThroughputDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlobalSecondaryIndexWarmThroughputDescription> {
        /**
         * <p>
         * Represents warm throughput read units per second value for a global secondary index.
         * </p>
         * 
         * @param readUnitsPerSecond
         *        Represents warm throughput read units per second value for a global secondary index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readUnitsPerSecond(Long readUnitsPerSecond);

        /**
         * <p>
         * Represents warm throughput write units per second value for a global secondary index.
         * </p>
         * 
         * @param writeUnitsPerSecond
         *        Represents warm throughput write units per second value for a global secondary index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeUnitsPerSecond(Long writeUnitsPerSecond);

        /**
         * <p>
         * Represents the warm throughput status being created or updated on a global secondary index. The status can
         * only be <code>UPDATING</code> or <code>ACTIVE</code>.
         * </p>
         * 
         * @param status
         *        Represents the warm throughput status being created or updated on a global secondary index. The status
         *        can only be <code>UPDATING</code> or <code>ACTIVE</code>.
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Represents the warm throughput status being created or updated on a global secondary index. The status can
         * only be <code>UPDATING</code> or <code>ACTIVE</code>.
         * </p>
         * 
         * @param status
         *        Represents the warm throughput status being created or updated on a global secondary index. The status
         *        can only be <code>UPDATING</code> or <code>ACTIVE</code>.
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder status(IndexStatus status);
    }

    static final class BuilderImpl implements Builder {
        private Long readUnitsPerSecond;

        private Long writeUnitsPerSecond;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalSecondaryIndexWarmThroughputDescription model) {
            readUnitsPerSecond(model.readUnitsPerSecond);
            writeUnitsPerSecond(model.writeUnitsPerSecond);
            status(model.status);
        }

        public final Long getReadUnitsPerSecond() {
            return readUnitsPerSecond;
        }

        public final void setReadUnitsPerSecond(Long readUnitsPerSecond) {
            this.readUnitsPerSecond = readUnitsPerSecond;
        }

        @Override
        public final Builder readUnitsPerSecond(Long readUnitsPerSecond) {
            this.readUnitsPerSecond = readUnitsPerSecond;
            return this;
        }

        public final Long getWriteUnitsPerSecond() {
            return writeUnitsPerSecond;
        }

        public final void setWriteUnitsPerSecond(Long writeUnitsPerSecond) {
            this.writeUnitsPerSecond = writeUnitsPerSecond;
        }

        @Override
        public final Builder writeUnitsPerSecond(Long writeUnitsPerSecond) {
            this.writeUnitsPerSecond = writeUnitsPerSecond;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IndexStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GlobalSecondaryIndexWarmThroughputDescription build() {
            return new GlobalSecondaryIndexWarmThroughputDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
