/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.BackupTypeFilter;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBackupsRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, ListBackupsRequest> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(ListBackupsRequest.getter(ListBackupsRequest::tableName)).setter(ListBackupsRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(ListBackupsRequest.getter(ListBackupsRequest::limit)).setter(ListBackupsRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<Instant> TIME_RANGE_LOWER_BOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TimeRangeLowerBound").getter(ListBackupsRequest.getter(ListBackupsRequest::timeRangeLowerBound)).setter(ListBackupsRequest.setter(Builder::timeRangeLowerBound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRangeLowerBound").build()}).build();
    private static final SdkField<Instant> TIME_RANGE_UPPER_BOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TimeRangeUpperBound").getter(ListBackupsRequest.getter(ListBackupsRequest::timeRangeUpperBound)).setter(ListBackupsRequest.setter(Builder::timeRangeUpperBound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRangeUpperBound").build()}).build();
    private static final SdkField<String> EXCLUSIVE_START_BACKUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExclusiveStartBackupArn").getter(ListBackupsRequest.getter(ListBackupsRequest::exclusiveStartBackupArn)).setter(ListBackupsRequest.setter(Builder::exclusiveStartBackupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartBackupArn").build()}).build();
    private static final SdkField<String> BACKUP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupType").getter(ListBackupsRequest.getter(ListBackupsRequest::backupTypeAsString)).setter(ListBackupsRequest.setter(Builder::backupType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, LIMIT_FIELD, TIME_RANGE_LOWER_BOUND_FIELD, TIME_RANGE_UPPER_BOUND_FIELD, EXCLUSIVE_START_BACKUP_ARN_FIELD, BACKUP_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBackupsRequest.memberNameToFieldInitializer();
    private final String tableName;
    private final Integer limit;
    private final Instant timeRangeLowerBound;
    private final Instant timeRangeUpperBound;
    private final String exclusiveStartBackupArn;
    private final String backupType;

    private ListBackupsRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.limit = builder.limit;
        this.timeRangeLowerBound = builder.timeRangeLowerBound;
        this.timeRangeUpperBound = builder.timeRangeUpperBound;
        this.exclusiveStartBackupArn = builder.exclusiveStartBackupArn;
        this.backupType = builder.backupType;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final Instant timeRangeLowerBound() {
        return this.timeRangeLowerBound;
    }

    public final Instant timeRangeUpperBound() {
        return this.timeRangeUpperBound;
    }

    public final String exclusiveStartBackupArn() {
        return this.exclusiveStartBackupArn;
    }

    public final BackupTypeFilter backupType() {
        return BackupTypeFilter.fromValue(this.backupType);
    }

    public final String backupTypeAsString() {
        return this.backupType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeRangeLowerBound());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeRangeUpperBound());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartBackupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackupsRequest)) {
            return false;
        }
        ListBackupsRequest other = (ListBackupsRequest)((Object)obj);
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.timeRangeLowerBound(), other.timeRangeLowerBound()) && Objects.equals(this.timeRangeUpperBound(), other.timeRangeUpperBound()) && Objects.equals(this.exclusiveStartBackupArn(), other.exclusiveStartBackupArn()) && Objects.equals(this.backupTypeAsString(), other.backupTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListBackupsRequest").add("TableName", (Object)this.tableName()).add("Limit", (Object)this.limit()).add("TimeRangeLowerBound", (Object)this.timeRangeLowerBound()).add("TimeRangeUpperBound", (Object)this.timeRangeUpperBound()).add("ExclusiveStartBackupArn", (Object)this.exclusiveStartBackupArn()).add("BackupType", (Object)this.backupTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "TimeRangeLowerBound": {
                return Optional.ofNullable(clazz.cast(this.timeRangeLowerBound()));
            }
            case "TimeRangeUpperBound": {
                return Optional.ofNullable(clazz.cast(this.timeRangeUpperBound()));
            }
            case "ExclusiveStartBackupArn": {
                return Optional.ofNullable(clazz.cast(this.exclusiveStartBackupArn()));
            }
            case "BackupType": {
                return Optional.ofNullable(clazz.cast(this.backupTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("Limit", LIMIT_FIELD);
        map.put("TimeRangeLowerBound", TIME_RANGE_LOWER_BOUND_FIELD);
        map.put("TimeRangeUpperBound", TIME_RANGE_UPPER_BOUND_FIELD);
        map.put("ExclusiveStartBackupArn", EXCLUSIVE_START_BACKUP_ARN_FIELD);
        map.put("BackupType", BACKUP_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBackupsRequest, T> g) {
        return obj -> g.apply((ListBackupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private String tableName;
        private Integer limit;
        private Instant timeRangeLowerBound;
        private Instant timeRangeUpperBound;
        private String exclusiveStartBackupArn;
        private String backupType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackupsRequest model) {
            super(model);
            this.tableName(model.tableName);
            this.limit(model.limit);
            this.timeRangeLowerBound(model.timeRangeLowerBound);
            this.timeRangeUpperBound(model.timeRangeUpperBound);
            this.exclusiveStartBackupArn(model.exclusiveStartBackupArn);
            this.backupType(model.backupType);
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final Instant getTimeRangeLowerBound() {
            return this.timeRangeLowerBound;
        }

        public final void setTimeRangeLowerBound(Instant timeRangeLowerBound) {
            this.timeRangeLowerBound = timeRangeLowerBound;
        }

        @Override
        public final Builder timeRangeLowerBound(Instant timeRangeLowerBound) {
            this.timeRangeLowerBound = timeRangeLowerBound;
            return this;
        }

        public final Instant getTimeRangeUpperBound() {
            return this.timeRangeUpperBound;
        }

        public final void setTimeRangeUpperBound(Instant timeRangeUpperBound) {
            this.timeRangeUpperBound = timeRangeUpperBound;
        }

        @Override
        public final Builder timeRangeUpperBound(Instant timeRangeUpperBound) {
            this.timeRangeUpperBound = timeRangeUpperBound;
            return this;
        }

        public final String getExclusiveStartBackupArn() {
            return this.exclusiveStartBackupArn;
        }

        public final void setExclusiveStartBackupArn(String exclusiveStartBackupArn) {
            this.exclusiveStartBackupArn = exclusiveStartBackupArn;
        }

        @Override
        public final Builder exclusiveStartBackupArn(String exclusiveStartBackupArn) {
            this.exclusiveStartBackupArn = exclusiveStartBackupArn;
            return this;
        }

        public final String getBackupType() {
            return this.backupType;
        }

        public final void setBackupType(String backupType) {
            this.backupType = backupType;
        }

        @Override
        public final Builder backupType(String backupType) {
            this.backupType = backupType;
            return this;
        }

        @Override
        public final Builder backupType(BackupTypeFilter backupType) {
            this.backupType(backupType == null ? null : backupType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBackupsRequest build() {
            return new ListBackupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBackupsRequest> {
        public Builder tableName(String var1);

        public Builder limit(Integer var1);

        public Builder timeRangeLowerBound(Instant var1);

        public Builder timeRangeUpperBound(Instant var1);

        public Builder exclusiveStartBackupArn(String var1);

        public Builder backupType(String var1);

        public Builder backupType(BackupTypeFilter var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

