/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.TableStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableWarmThroughputDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableWarmThroughputDescription> {
    private static final SdkField<Long> READ_UNITS_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ReadUnitsPerSecond").getter(TableWarmThroughputDescription.getter(TableWarmThroughputDescription::readUnitsPerSecond)).setter(TableWarmThroughputDescription.setter(Builder::readUnitsPerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadUnitsPerSecond").build()}).build();
    private static final SdkField<Long> WRITE_UNITS_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("WriteUnitsPerSecond").getter(TableWarmThroughputDescription.getter(TableWarmThroughputDescription::writeUnitsPerSecond)).setter(TableWarmThroughputDescription.setter(Builder::writeUnitsPerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteUnitsPerSecond").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(TableWarmThroughputDescription.getter(TableWarmThroughputDescription::statusAsString)).setter(TableWarmThroughputDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(READ_UNITS_PER_SECOND_FIELD, WRITE_UNITS_PER_SECOND_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TableWarmThroughputDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long readUnitsPerSecond;
    private final Long writeUnitsPerSecond;
    private final String status;

    private TableWarmThroughputDescription(BuilderImpl builder) {
        this.readUnitsPerSecond = builder.readUnitsPerSecond;
        this.writeUnitsPerSecond = builder.writeUnitsPerSecond;
        this.status = builder.status;
    }

    public final Long readUnitsPerSecond() {
        return this.readUnitsPerSecond;
    }

    public final Long writeUnitsPerSecond() {
        return this.writeUnitsPerSecond;
    }

    public final TableStatus status() {
        return TableStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.readUnitsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeUnitsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableWarmThroughputDescription)) {
            return false;
        }
        TableWarmThroughputDescription other = (TableWarmThroughputDescription)obj;
        return Objects.equals(this.readUnitsPerSecond(), other.readUnitsPerSecond()) && Objects.equals(this.writeUnitsPerSecond(), other.writeUnitsPerSecond()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TableWarmThroughputDescription").add("ReadUnitsPerSecond", (Object)this.readUnitsPerSecond()).add("WriteUnitsPerSecond", (Object)this.writeUnitsPerSecond()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReadUnitsPerSecond": {
                return Optional.ofNullable(clazz.cast(this.readUnitsPerSecond()));
            }
            case "WriteUnitsPerSecond": {
                return Optional.ofNullable(clazz.cast(this.writeUnitsPerSecond()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReadUnitsPerSecond", READ_UNITS_PER_SECOND_FIELD);
        map.put("WriteUnitsPerSecond", WRITE_UNITS_PER_SECOND_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableWarmThroughputDescription, T> g) {
        return obj -> g.apply((TableWarmThroughputDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long readUnitsPerSecond;
        private Long writeUnitsPerSecond;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(TableWarmThroughputDescription model) {
            this.readUnitsPerSecond(model.readUnitsPerSecond);
            this.writeUnitsPerSecond(model.writeUnitsPerSecond);
            this.status(model.status);
        }

        public final Long getReadUnitsPerSecond() {
            return this.readUnitsPerSecond;
        }

        public final void setReadUnitsPerSecond(Long readUnitsPerSecond) {
            this.readUnitsPerSecond = readUnitsPerSecond;
        }

        @Override
        public final Builder readUnitsPerSecond(Long readUnitsPerSecond) {
            this.readUnitsPerSecond = readUnitsPerSecond;
            return this;
        }

        public final Long getWriteUnitsPerSecond() {
            return this.writeUnitsPerSecond;
        }

        public final void setWriteUnitsPerSecond(Long writeUnitsPerSecond) {
            this.writeUnitsPerSecond = writeUnitsPerSecond;
        }

        @Override
        public final Builder writeUnitsPerSecond(Long writeUnitsPerSecond) {
            this.writeUnitsPerSecond = writeUnitsPerSecond;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TableStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public TableWarmThroughputDescription build() {
            return new TableWarmThroughputDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableWarmThroughputDescription> {
        public Builder readUnitsPerSecond(Long var1);

        public Builder writeUnitsPerSecond(Long var1);

        public Builder status(String var1);

        public Builder status(TableStatus var1);
    }
}

