/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BatchStatementErrorCodeEnum {
    CONDITIONAL_CHECK_FAILED("ConditionalCheckFailed"),
    ITEM_COLLECTION_SIZE_LIMIT_EXCEEDED("ItemCollectionSizeLimitExceeded"),
    REQUEST_LIMIT_EXCEEDED("RequestLimitExceeded"),
    VALIDATION_ERROR("ValidationError"),
    PROVISIONED_THROUGHPUT_EXCEEDED("ProvisionedThroughputExceeded"),
    TRANSACTION_CONFLICT("TransactionConflict"),
    THROTTLING_ERROR("ThrottlingError"),
    INTERNAL_SERVER_ERROR("InternalServerError"),
    RESOURCE_NOT_FOUND("ResourceNotFound"),
    ACCESS_DENIED("AccessDenied"),
    DUPLICATE_ITEM("DuplicateItem"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BatchStatementErrorCodeEnum> VALUE_MAP;
    private final String value;

    private BatchStatementErrorCodeEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BatchStatementErrorCodeEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BatchStatementErrorCodeEnum> knownValues() {
        EnumSet<BatchStatementErrorCodeEnum> knownValues = EnumSet.allOf(BatchStatementErrorCodeEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BatchStatementErrorCodeEnum.class, BatchStatementErrorCodeEnum::toString);
    }
}

