/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.endpoints;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class DynamoDbEndpointParams
implements ToCopyableBuilder<Builder, DynamoDbEndpointParams> {
    private final Region region;
    private final Boolean useDualStack;
    private final Boolean useFIPS;
    private final String endpoint;
    private final String accountId;
    private final String accountIdEndpointMode;

    private DynamoDbEndpointParams(BuilderImpl builder) {
        this.region = builder.region;
        this.useDualStack = builder.useDualStack;
        this.useFIPS = builder.useFIPS;
        this.endpoint = builder.endpoint;
        this.accountId = builder.accountId;
        this.accountIdEndpointMode = builder.accountIdEndpointMode;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Region region() {
        return this.region;
    }

    public Boolean useDualStack() {
        return this.useDualStack;
    }

    public Boolean useFips() {
        return this.useFIPS;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String accountId() {
        return this.accountId;
    }

    public String accountIdEndpointMode() {
        return this.accountIdEndpointMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    private static class BuilderImpl
    implements Builder {
        private Region region;
        private Boolean useDualStack = false;
        private Boolean useFIPS = false;
        private String endpoint;
        private String accountId;
        private String accountIdEndpointMode;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamoDbEndpointParams builder) {
            this.region = builder.region;
            this.useDualStack = builder.useDualStack;
            this.useFIPS = builder.useFIPS;
            this.endpoint = builder.endpoint;
            this.accountId = builder.accountId;
            this.accountIdEndpointMode = builder.accountIdEndpointMode;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder useDualStack(Boolean useDualStack) {
            this.useDualStack = useDualStack;
            if (this.useDualStack == null) {
                this.useDualStack = false;
            }
            return this;
        }

        @Override
        public Builder useFips(Boolean useFIPS) {
            this.useFIPS = useFIPS;
            if (this.useFIPS == null) {
                this.useFIPS = false;
            }
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Override
        public Builder accountIdEndpointMode(String accountIdEndpointMode) {
            this.accountIdEndpointMode = accountIdEndpointMode;
            return this;
        }

        @Override
        public DynamoDbEndpointParams build() {
            return new DynamoDbEndpointParams(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DynamoDbEndpointParams> {
        public Builder region(Region var1);

        public Builder useDualStack(Boolean var1);

        public Builder useFips(Boolean var1);

        public Builder endpoint(String var1);

        public Builder accountId(String var1);

        public Builder accountIdEndpointMode(String var1);

        public DynamoDbEndpointParams build();
    }
}

