/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the properties of the exported table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportDescription.Builder, ExportDescription> {
    private static final SdkField<String> EXPORT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportArn").getter(getter(ExportDescription::exportArn)).setter(setter(Builder::exportArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportArn").build()).build();

    private static final SdkField<String> EXPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportStatus").getter(getter(ExportDescription::exportStatusAsString))
            .setter(setter(Builder::exportStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportStatus").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ExportDescription::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ExportDescription::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> EXPORT_MANIFEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportManifest").getter(getter(ExportDescription::exportManifest))
            .setter(setter(Builder::exportManifest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportManifest").build()).build();

    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableArn").getter(getter(ExportDescription::tableArn)).setter(setter(Builder::tableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableArn").build()).build();

    private static final SdkField<String> TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableId").getter(getter(ExportDescription::tableId)).setter(setter(Builder::tableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableId").build()).build();

    private static final SdkField<Instant> EXPORT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExportTime").getter(getter(ExportDescription::exportTime)).setter(setter(Builder::exportTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportTime").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(ExportDescription::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Bucket").getter(getter(ExportDescription::s3Bucket)).setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()).build();

    private static final SdkField<String> S3_BUCKET_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketOwner").getter(getter(ExportDescription::s3BucketOwner)).setter(setter(Builder::s3BucketOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketOwner").build()).build();

    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Prefix").getter(getter(ExportDescription::s3Prefix)).setter(setter(Builder::s3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix").build()).build();

    private static final SdkField<String> S3_SSE_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3SseAlgorithm").getter(getter(ExportDescription::s3SseAlgorithmAsString))
            .setter(setter(Builder::s3SseAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3SseAlgorithm").build()).build();

    private static final SdkField<String> S3_SSE_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3SseKmsKeyId").getter(getter(ExportDescription::s3SseKmsKeyId)).setter(setter(Builder::s3SseKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3SseKmsKeyId").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureCode").getter(getter(ExportDescription::failureCode)).setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureMessage").getter(getter(ExportDescription::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()).build();

    private static final SdkField<String> EXPORT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportFormat").getter(getter(ExportDescription::exportFormatAsString))
            .setter(setter(Builder::exportFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportFormat").build()).build();

    private static final SdkField<Long> BILLED_SIZE_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BilledSizeBytes").getter(getter(ExportDescription::billedSizeBytes))
            .setter(setter(Builder::billedSizeBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BilledSizeBytes").build()).build();

    private static final SdkField<Long> ITEM_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("ItemCount")
            .getter(getter(ExportDescription::itemCount)).setter(setter(Builder::itemCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCount").build()).build();

    private static final SdkField<String> EXPORT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportType").getter(getter(ExportDescription::exportTypeAsString)).setter(setter(Builder::exportType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportType").build()).build();

    private static final SdkField<IncrementalExportSpecification> INCREMENTAL_EXPORT_SPECIFICATION_FIELD = SdkField
            .<IncrementalExportSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("IncrementalExportSpecification")
            .getter(getter(ExportDescription::incrementalExportSpecification))
            .setter(setter(Builder::incrementalExportSpecification))
            .constructor(IncrementalExportSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncrementalExportSpecification")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ARN_FIELD,
            EXPORT_STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, EXPORT_MANIFEST_FIELD, TABLE_ARN_FIELD, TABLE_ID_FIELD,
            EXPORT_TIME_FIELD, CLIENT_TOKEN_FIELD, S3_BUCKET_FIELD, S3_BUCKET_OWNER_FIELD, S3_PREFIX_FIELD,
            S3_SSE_ALGORITHM_FIELD, S3_SSE_KMS_KEY_ID_FIELD, FAILURE_CODE_FIELD, FAILURE_MESSAGE_FIELD, EXPORT_FORMAT_FIELD,
            BILLED_SIZE_BYTES_FIELD, ITEM_COUNT_FIELD, EXPORT_TYPE_FIELD, INCREMENTAL_EXPORT_SPECIFICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String exportArn;

    private final String exportStatus;

    private final Instant startTime;

    private final Instant endTime;

    private final String exportManifest;

    private final String tableArn;

    private final String tableId;

    private final Instant exportTime;

    private final String clientToken;

    private final String s3Bucket;

    private final String s3BucketOwner;

    private final String s3Prefix;

    private final String s3SseAlgorithm;

    private final String s3SseKmsKeyId;

    private final String failureCode;

    private final String failureMessage;

    private final String exportFormat;

    private final Long billedSizeBytes;

    private final Long itemCount;

    private final String exportType;

    private final IncrementalExportSpecification incrementalExportSpecification;

    private ExportDescription(BuilderImpl builder) {
        this.exportArn = builder.exportArn;
        this.exportStatus = builder.exportStatus;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.exportManifest = builder.exportManifest;
        this.tableArn = builder.tableArn;
        this.tableId = builder.tableId;
        this.exportTime = builder.exportTime;
        this.clientToken = builder.clientToken;
        this.s3Bucket = builder.s3Bucket;
        this.s3BucketOwner = builder.s3BucketOwner;
        this.s3Prefix = builder.s3Prefix;
        this.s3SseAlgorithm = builder.s3SseAlgorithm;
        this.s3SseKmsKeyId = builder.s3SseKmsKeyId;
        this.failureCode = builder.failureCode;
        this.failureMessage = builder.failureMessage;
        this.exportFormat = builder.exportFormat;
        this.billedSizeBytes = builder.billedSizeBytes;
        this.itemCount = builder.itemCount;
        this.exportType = builder.exportType;
        this.incrementalExportSpecification = builder.incrementalExportSpecification;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the table export.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the table export.
     */
    public final String exportArn() {
        return exportArn;
    }

    /**
     * <p>
     * Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportStatus} will
     * return {@link ExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportStatusAsString}.
     * </p>
     * 
     * @return Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.
     * @see ExportStatus
     */
    public final ExportStatus exportStatus() {
        return ExportStatus.fromValue(exportStatus);
    }

    /**
     * <p>
     * Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportStatus} will
     * return {@link ExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportStatusAsString}.
     * </p>
     * 
     * @return Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.
     * @see ExportStatus
     */
    public final String exportStatusAsString() {
        return exportStatus;
    }

    /**
     * <p>
     * The time at which the export task began.
     * </p>
     * 
     * @return The time at which the export task began.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time at which the export task completed.
     * </p>
     * 
     * @return The time at which the export task completed.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The name of the manifest file for the export task.
     * </p>
     * 
     * @return The name of the manifest file for the export task.
     */
    public final String exportManifest() {
        return exportManifest;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the table that was exported.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the table that was exported.
     */
    public final String tableArn() {
        return tableArn;
    }

    /**
     * <p>
     * Unique ID of the table that was exported.
     * </p>
     * 
     * @return Unique ID of the table that was exported.
     */
    public final String tableId() {
        return tableId;
    }

    /**
     * <p>
     * Point in time from which table data was exported.
     * </p>
     * 
     * @return Point in time from which table data was exported.
     */
    public final Instant exportTime() {
        return exportTime;
    }

    /**
     * <p>
     * The client token that was provided for the export task. A client token makes calls to
     * <code>ExportTableToPointInTimeInput</code> idempotent, meaning that multiple identical calls have the same effect
     * as one single call.
     * </p>
     * 
     * @return The client token that was provided for the export task. A client token makes calls to
     *         <code>ExportTableToPointInTimeInput</code> idempotent, meaning that multiple identical calls have the
     *         same effect as one single call.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket containing the export.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket containing the export.
     */
    public final String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the bucket containing the export.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the bucket containing the export.
     */
    public final String s3BucketOwner() {
        return s3BucketOwner;
    }

    /**
     * <p>
     * The Amazon S3 bucket prefix used as the file name and path of the exported snapshot.
     * </p>
     * 
     * @return The Amazon S3 bucket prefix used as the file name and path of the exported snapshot.
     */
    public final String s3Prefix() {
        return s3Prefix;
    }

    /**
     * <p>
     * Type of encryption used on the bucket where export data is stored. Valid values for <code>S3SseAlgorithm</code>
     * are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AES256</code> - server-side encryption with Amazon S3 managed keys
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KMS</code> - server-side encryption with KMS managed keys
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3SseAlgorithm}
     * will return {@link S3SseAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3SseAlgorithmAsString}.
     * </p>
     * 
     * @return Type of encryption used on the bucket where export data is stored. Valid values for
     *         <code>S3SseAlgorithm</code> are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AES256</code> - server-side encryption with Amazon S3 managed keys
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KMS</code> - server-side encryption with KMS managed keys
     *         </p>
     *         </li>
     * @see S3SseAlgorithm
     */
    public final S3SseAlgorithm s3SseAlgorithm() {
        return S3SseAlgorithm.fromValue(s3SseAlgorithm);
    }

    /**
     * <p>
     * Type of encryption used on the bucket where export data is stored. Valid values for <code>S3SseAlgorithm</code>
     * are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AES256</code> - server-side encryption with Amazon S3 managed keys
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KMS</code> - server-side encryption with KMS managed keys
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3SseAlgorithm}
     * will return {@link S3SseAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3SseAlgorithmAsString}.
     * </p>
     * 
     * @return Type of encryption used on the bucket where export data is stored. Valid values for
     *         <code>S3SseAlgorithm</code> are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AES256</code> - server-side encryption with Amazon S3 managed keys
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KMS</code> - server-side encryption with KMS managed keys
     *         </p>
     *         </li>
     * @see S3SseAlgorithm
     */
    public final String s3SseAlgorithmAsString() {
        return s3SseAlgorithm;
    }

    /**
     * <p>
     * The ID of the KMS managed key used to encrypt the S3 bucket where export data is stored (if applicable).
     * </p>
     * 
     * @return The ID of the KMS managed key used to encrypt the S3 bucket where export data is stored (if applicable).
     */
    public final String s3SseKmsKeyId() {
        return s3SseKmsKeyId;
    }

    /**
     * <p>
     * Status code for the result of the failed export.
     * </p>
     * 
     * @return Status code for the result of the failed export.
     */
    public final String failureCode() {
        return failureCode;
    }

    /**
     * <p>
     * Export failure reason description.
     * </p>
     * 
     * @return Export failure reason description.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    /**
     * <p>
     * The format of the exported data. Valid values for <code>ExportFormat</code> are <code>DYNAMODB_JSON</code> or
     * <code>ION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportFormat} will
     * return {@link ExportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportFormatAsString}.
     * </p>
     * 
     * @return The format of the exported data. Valid values for <code>ExportFormat</code> are
     *         <code>DYNAMODB_JSON</code> or <code>ION</code>.
     * @see ExportFormat
     */
    public final ExportFormat exportFormat() {
        return ExportFormat.fromValue(exportFormat);
    }

    /**
     * <p>
     * The format of the exported data. Valid values for <code>ExportFormat</code> are <code>DYNAMODB_JSON</code> or
     * <code>ION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportFormat} will
     * return {@link ExportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportFormatAsString}.
     * </p>
     * 
     * @return The format of the exported data. Valid values for <code>ExportFormat</code> are
     *         <code>DYNAMODB_JSON</code> or <code>ION</code>.
     * @see ExportFormat
     */
    public final String exportFormatAsString() {
        return exportFormat;
    }

    /**
     * <p>
     * The billable size of the table export.
     * </p>
     * 
     * @return The billable size of the table export.
     */
    public final Long billedSizeBytes() {
        return billedSizeBytes;
    }

    /**
     * <p>
     * The number of items exported.
     * </p>
     * 
     * @return The number of items exported.
     */
    public final Long itemCount() {
        return itemCount;
    }

    /**
     * <p>
     * The type of export that was performed. Valid values are <code>FULL_EXPORT</code> or
     * <code>INCREMENTAL_EXPORT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportType} will
     * return {@link ExportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportTypeAsString}.
     * </p>
     * 
     * @return The type of export that was performed. Valid values are <code>FULL_EXPORT</code> or
     *         <code>INCREMENTAL_EXPORT</code>.
     * @see ExportType
     */
    public final ExportType exportType() {
        return ExportType.fromValue(exportType);
    }

    /**
     * <p>
     * The type of export that was performed. Valid values are <code>FULL_EXPORT</code> or
     * <code>INCREMENTAL_EXPORT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportType} will
     * return {@link ExportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportTypeAsString}.
     * </p>
     * 
     * @return The type of export that was performed. Valid values are <code>FULL_EXPORT</code> or
     *         <code>INCREMENTAL_EXPORT</code>.
     * @see ExportType
     */
    public final String exportTypeAsString() {
        return exportType;
    }

    /**
     * <p>
     * Optional object containing the parameters specific to an incremental export.
     * </p>
     * 
     * @return Optional object containing the parameters specific to an incremental export.
     */
    public final IncrementalExportSpecification incrementalExportSpecification() {
        return incrementalExportSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exportArn());
        hashCode = 31 * hashCode + Objects.hashCode(exportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(exportManifest());
        hashCode = 31 * hashCode + Objects.hashCode(tableArn());
        hashCode = 31 * hashCode + Objects.hashCode(tableId());
        hashCode = 31 * hashCode + Objects.hashCode(exportTime());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(s3SseAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3SseKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(exportFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(billedSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(exportTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(incrementalExportSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportDescription)) {
            return false;
        }
        ExportDescription other = (ExportDescription) obj;
        return Objects.equals(exportArn(), other.exportArn())
                && Objects.equals(exportStatusAsString(), other.exportStatusAsString())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(exportManifest(), other.exportManifest()) && Objects.equals(tableArn(), other.tableArn())
                && Objects.equals(tableId(), other.tableId()) && Objects.equals(exportTime(), other.exportTime())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(s3Bucket(), other.s3Bucket())
                && Objects.equals(s3BucketOwner(), other.s3BucketOwner()) && Objects.equals(s3Prefix(), other.s3Prefix())
                && Objects.equals(s3SseAlgorithmAsString(), other.s3SseAlgorithmAsString())
                && Objects.equals(s3SseKmsKeyId(), other.s3SseKmsKeyId()) && Objects.equals(failureCode(), other.failureCode())
                && Objects.equals(failureMessage(), other.failureMessage())
                && Objects.equals(exportFormatAsString(), other.exportFormatAsString())
                && Objects.equals(billedSizeBytes(), other.billedSizeBytes()) && Objects.equals(itemCount(), other.itemCount())
                && Objects.equals(exportTypeAsString(), other.exportTypeAsString())
                && Objects.equals(incrementalExportSpecification(), other.incrementalExportSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportDescription").add("ExportArn", exportArn()).add("ExportStatus", exportStatusAsString())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("ExportManifest", exportManifest())
                .add("TableArn", tableArn()).add("TableId", tableId()).add("ExportTime", exportTime())
                .add("ClientToken", clientToken()).add("S3Bucket", s3Bucket()).add("S3BucketOwner", s3BucketOwner())
                .add("S3Prefix", s3Prefix()).add("S3SseAlgorithm", s3SseAlgorithmAsString())
                .add("S3SseKmsKeyId", s3SseKmsKeyId()).add("FailureCode", failureCode()).add("FailureMessage", failureMessage())
                .add("ExportFormat", exportFormatAsString()).add("BilledSizeBytes", billedSizeBytes())
                .add("ItemCount", itemCount()).add("ExportType", exportTypeAsString())
                .add("IncrementalExportSpecification", incrementalExportSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportArn":
            return Optional.ofNullable(clazz.cast(exportArn()));
        case "ExportStatus":
            return Optional.ofNullable(clazz.cast(exportStatusAsString()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "ExportManifest":
            return Optional.ofNullable(clazz.cast(exportManifest()));
        case "TableArn":
            return Optional.ofNullable(clazz.cast(tableArn()));
        case "TableId":
            return Optional.ofNullable(clazz.cast(tableId()));
        case "ExportTime":
            return Optional.ofNullable(clazz.cast(exportTime()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "S3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "S3BucketOwner":
            return Optional.ofNullable(clazz.cast(s3BucketOwner()));
        case "S3Prefix":
            return Optional.ofNullable(clazz.cast(s3Prefix()));
        case "S3SseAlgorithm":
            return Optional.ofNullable(clazz.cast(s3SseAlgorithmAsString()));
        case "S3SseKmsKeyId":
            return Optional.ofNullable(clazz.cast(s3SseKmsKeyId()));
        case "FailureCode":
            return Optional.ofNullable(clazz.cast(failureCode()));
        case "FailureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        case "ExportFormat":
            return Optional.ofNullable(clazz.cast(exportFormatAsString()));
        case "BilledSizeBytes":
            return Optional.ofNullable(clazz.cast(billedSizeBytes()));
        case "ItemCount":
            return Optional.ofNullable(clazz.cast(itemCount()));
        case "ExportType":
            return Optional.ofNullable(clazz.cast(exportTypeAsString()));
        case "IncrementalExportSpecification":
            return Optional.ofNullable(clazz.cast(incrementalExportSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExportArn", EXPORT_ARN_FIELD);
        map.put("ExportStatus", EXPORT_STATUS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("ExportManifest", EXPORT_MANIFEST_FIELD);
        map.put("TableArn", TABLE_ARN_FIELD);
        map.put("TableId", TABLE_ID_FIELD);
        map.put("ExportTime", EXPORT_TIME_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("S3Bucket", S3_BUCKET_FIELD);
        map.put("S3BucketOwner", S3_BUCKET_OWNER_FIELD);
        map.put("S3Prefix", S3_PREFIX_FIELD);
        map.put("S3SseAlgorithm", S3_SSE_ALGORITHM_FIELD);
        map.put("S3SseKmsKeyId", S3_SSE_KMS_KEY_ID_FIELD);
        map.put("FailureCode", FAILURE_CODE_FIELD);
        map.put("FailureMessage", FAILURE_MESSAGE_FIELD);
        map.put("ExportFormat", EXPORT_FORMAT_FIELD);
        map.put("BilledSizeBytes", BILLED_SIZE_BYTES_FIELD);
        map.put("ItemCount", ITEM_COUNT_FIELD);
        map.put("ExportType", EXPORT_TYPE_FIELD);
        map.put("IncrementalExportSpecification", INCREMENTAL_EXPORT_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportDescription, T> g) {
        return obj -> g.apply((ExportDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportDescription> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the table export.
         * </p>
         * 
         * @param exportArn
         *        The Amazon Resource Name (ARN) of the table export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportArn(String exportArn);

        /**
         * <p>
         * Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.
         * </p>
         * 
         * @param exportStatus
         *        Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.
         * @see ExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportStatus
         */
        Builder exportStatus(String exportStatus);

        /**
         * <p>
         * Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.
         * </p>
         * 
         * @param exportStatus
         *        Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.
         * @see ExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportStatus
         */
        Builder exportStatus(ExportStatus exportStatus);

        /**
         * <p>
         * The time at which the export task began.
         * </p>
         * 
         * @param startTime
         *        The time at which the export task began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time at which the export task completed.
         * </p>
         * 
         * @param endTime
         *        The time at which the export task completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The name of the manifest file for the export task.
         * </p>
         * 
         * @param exportManifest
         *        The name of the manifest file for the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportManifest(String exportManifest);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the table that was exported.
         * </p>
         * 
         * @param tableArn
         *        The Amazon Resource Name (ARN) of the table that was exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableArn(String tableArn);

        /**
         * <p>
         * Unique ID of the table that was exported.
         * </p>
         * 
         * @param tableId
         *        Unique ID of the table that was exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableId(String tableId);

        /**
         * <p>
         * Point in time from which table data was exported.
         * </p>
         * 
         * @param exportTime
         *        Point in time from which table data was exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTime(Instant exportTime);

        /**
         * <p>
         * The client token that was provided for the export task. A client token makes calls to
         * <code>ExportTableToPointInTimeInput</code> idempotent, meaning that multiple identical calls have the same
         * effect as one single call.
         * </p>
         * 
         * @param clientToken
         *        The client token that was provided for the export task. A client token makes calls to
         *        <code>ExportTableToPointInTimeInput</code> idempotent, meaning that multiple identical calls have the
         *        same effect as one single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The name of the Amazon S3 bucket containing the export.
         * </p>
         * 
         * @param s3Bucket
         *        The name of the Amazon S3 bucket containing the export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the bucket containing the export.
         * </p>
         * 
         * @param s3BucketOwner
         *        The ID of the Amazon Web Services account that owns the bucket containing the export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketOwner(String s3BucketOwner);

        /**
         * <p>
         * The Amazon S3 bucket prefix used as the file name and path of the exported snapshot.
         * </p>
         * 
         * @param s3Prefix
         *        The Amazon S3 bucket prefix used as the file name and path of the exported snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Prefix(String s3Prefix);

        /**
         * <p>
         * Type of encryption used on the bucket where export data is stored. Valid values for
         * <code>S3SseAlgorithm</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AES256</code> - server-side encryption with Amazon S3 managed keys
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KMS</code> - server-side encryption with KMS managed keys
         * </p>
         * </li>
         * </ul>
         * 
         * @param s3SseAlgorithm
         *        Type of encryption used on the bucket where export data is stored. Valid values for
         *        <code>S3SseAlgorithm</code> are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AES256</code> - server-side encryption with Amazon S3 managed keys
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KMS</code> - server-side encryption with KMS managed keys
         *        </p>
         *        </li>
         * @see S3SseAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3SseAlgorithm
         */
        Builder s3SseAlgorithm(String s3SseAlgorithm);

        /**
         * <p>
         * Type of encryption used on the bucket where export data is stored. Valid values for
         * <code>S3SseAlgorithm</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AES256</code> - server-side encryption with Amazon S3 managed keys
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KMS</code> - server-side encryption with KMS managed keys
         * </p>
         * </li>
         * </ul>
         * 
         * @param s3SseAlgorithm
         *        Type of encryption used on the bucket where export data is stored. Valid values for
         *        <code>S3SseAlgorithm</code> are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AES256</code> - server-side encryption with Amazon S3 managed keys
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KMS</code> - server-side encryption with KMS managed keys
         *        </p>
         *        </li>
         * @see S3SseAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3SseAlgorithm
         */
        Builder s3SseAlgorithm(S3SseAlgorithm s3SseAlgorithm);

        /**
         * <p>
         * The ID of the KMS managed key used to encrypt the S3 bucket where export data is stored (if applicable).
         * </p>
         * 
         * @param s3SseKmsKeyId
         *        The ID of the KMS managed key used to encrypt the S3 bucket where export data is stored (if
         *        applicable).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3SseKmsKeyId(String s3SseKmsKeyId);

        /**
         * <p>
         * Status code for the result of the failed export.
         * </p>
         * 
         * @param failureCode
         *        Status code for the result of the failed export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * Export failure reason description.
         * </p>
         * 
         * @param failureMessage
         *        Export failure reason description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * The format of the exported data. Valid values for <code>ExportFormat</code> are <code>DYNAMODB_JSON</code> or
         * <code>ION</code>.
         * </p>
         * 
         * @param exportFormat
         *        The format of the exported data. Valid values for <code>ExportFormat</code> are
         *        <code>DYNAMODB_JSON</code> or <code>ION</code>.
         * @see ExportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportFormat
         */
        Builder exportFormat(String exportFormat);

        /**
         * <p>
         * The format of the exported data. Valid values for <code>ExportFormat</code> are <code>DYNAMODB_JSON</code> or
         * <code>ION</code>.
         * </p>
         * 
         * @param exportFormat
         *        The format of the exported data. Valid values for <code>ExportFormat</code> are
         *        <code>DYNAMODB_JSON</code> or <code>ION</code>.
         * @see ExportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportFormat
         */
        Builder exportFormat(ExportFormat exportFormat);

        /**
         * <p>
         * The billable size of the table export.
         * </p>
         * 
         * @param billedSizeBytes
         *        The billable size of the table export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billedSizeBytes(Long billedSizeBytes);

        /**
         * <p>
         * The number of items exported.
         * </p>
         * 
         * @param itemCount
         *        The number of items exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemCount(Long itemCount);

        /**
         * <p>
         * The type of export that was performed. Valid values are <code>FULL_EXPORT</code> or
         * <code>INCREMENTAL_EXPORT</code>.
         * </p>
         * 
         * @param exportType
         *        The type of export that was performed. Valid values are <code>FULL_EXPORT</code> or
         *        <code>INCREMENTAL_EXPORT</code>.
         * @see ExportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportType
         */
        Builder exportType(String exportType);

        /**
         * <p>
         * The type of export that was performed. Valid values are <code>FULL_EXPORT</code> or
         * <code>INCREMENTAL_EXPORT</code>.
         * </p>
         * 
         * @param exportType
         *        The type of export that was performed. Valid values are <code>FULL_EXPORT</code> or
         *        <code>INCREMENTAL_EXPORT</code>.
         * @see ExportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportType
         */
        Builder exportType(ExportType exportType);

        /**
         * <p>
         * Optional object containing the parameters specific to an incremental export.
         * </p>
         * 
         * @param incrementalExportSpecification
         *        Optional object containing the parameters specific to an incremental export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incrementalExportSpecification(IncrementalExportSpecification incrementalExportSpecification);

        /**
         * <p>
         * Optional object containing the parameters specific to an incremental export.
         * </p>
         * This is a convenience method that creates an instance of the {@link IncrementalExportSpecification.Builder}
         * avoiding the need to create one manually via {@link IncrementalExportSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IncrementalExportSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #incrementalExportSpecification(IncrementalExportSpecification)}.
         * 
         * @param incrementalExportSpecification
         *        a consumer that will call methods on {@link IncrementalExportSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incrementalExportSpecification(IncrementalExportSpecification)
         */
        default Builder incrementalExportSpecification(
                Consumer<IncrementalExportSpecification.Builder> incrementalExportSpecification) {
            return incrementalExportSpecification(IncrementalExportSpecification.builder()
                    .applyMutation(incrementalExportSpecification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String exportArn;

        private String exportStatus;

        private Instant startTime;

        private Instant endTime;

        private String exportManifest;

        private String tableArn;

        private String tableId;

        private Instant exportTime;

        private String clientToken;

        private String s3Bucket;

        private String s3BucketOwner;

        private String s3Prefix;

        private String s3SseAlgorithm;

        private String s3SseKmsKeyId;

        private String failureCode;

        private String failureMessage;

        private String exportFormat;

        private Long billedSizeBytes;

        private Long itemCount;

        private String exportType;

        private IncrementalExportSpecification incrementalExportSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportDescription model) {
            exportArn(model.exportArn);
            exportStatus(model.exportStatus);
            startTime(model.startTime);
            endTime(model.endTime);
            exportManifest(model.exportManifest);
            tableArn(model.tableArn);
            tableId(model.tableId);
            exportTime(model.exportTime);
            clientToken(model.clientToken);
            s3Bucket(model.s3Bucket);
            s3BucketOwner(model.s3BucketOwner);
            s3Prefix(model.s3Prefix);
            s3SseAlgorithm(model.s3SseAlgorithm);
            s3SseKmsKeyId(model.s3SseKmsKeyId);
            failureCode(model.failureCode);
            failureMessage(model.failureMessage);
            exportFormat(model.exportFormat);
            billedSizeBytes(model.billedSizeBytes);
            itemCount(model.itemCount);
            exportType(model.exportType);
            incrementalExportSpecification(model.incrementalExportSpecification);
        }

        public final String getExportArn() {
            return exportArn;
        }

        public final void setExportArn(String exportArn) {
            this.exportArn = exportArn;
        }

        @Override
        public final Builder exportArn(String exportArn) {
            this.exportArn = exportArn;
            return this;
        }

        public final String getExportStatus() {
            return exportStatus;
        }

        public final void setExportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
        }

        @Override
        public final Builder exportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        public final Builder exportStatus(ExportStatus exportStatus) {
            this.exportStatus(exportStatus == null ? null : exportStatus.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getExportManifest() {
            return exportManifest;
        }

        public final void setExportManifest(String exportManifest) {
            this.exportManifest = exportManifest;
        }

        @Override
        public final Builder exportManifest(String exportManifest) {
            this.exportManifest = exportManifest;
            return this;
        }

        public final String getTableArn() {
            return tableArn;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        @Override
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        public final String getTableId() {
            return tableId;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        @Override
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final Instant getExportTime() {
            return exportTime;
        }

        public final void setExportTime(Instant exportTime) {
            this.exportTime = exportTime;
        }

        @Override
        public final Builder exportTime(Instant exportTime) {
            this.exportTime = exportTime;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3BucketOwner() {
            return s3BucketOwner;
        }

        public final void setS3BucketOwner(String s3BucketOwner) {
            this.s3BucketOwner = s3BucketOwner;
        }

        @Override
        public final Builder s3BucketOwner(String s3BucketOwner) {
            this.s3BucketOwner = s3BucketOwner;
            return this;
        }

        public final String getS3Prefix() {
            return s3Prefix;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final String getS3SseAlgorithm() {
            return s3SseAlgorithm;
        }

        public final void setS3SseAlgorithm(String s3SseAlgorithm) {
            this.s3SseAlgorithm = s3SseAlgorithm;
        }

        @Override
        public final Builder s3SseAlgorithm(String s3SseAlgorithm) {
            this.s3SseAlgorithm = s3SseAlgorithm;
            return this;
        }

        @Override
        public final Builder s3SseAlgorithm(S3SseAlgorithm s3SseAlgorithm) {
            this.s3SseAlgorithm(s3SseAlgorithm == null ? null : s3SseAlgorithm.toString());
            return this;
        }

        public final String getS3SseKmsKeyId() {
            return s3SseKmsKeyId;
        }

        public final void setS3SseKmsKeyId(String s3SseKmsKeyId) {
            this.s3SseKmsKeyId = s3SseKmsKeyId;
        }

        @Override
        public final Builder s3SseKmsKeyId(String s3SseKmsKeyId) {
            this.s3SseKmsKeyId = s3SseKmsKeyId;
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final String getExportFormat() {
            return exportFormat;
        }

        public final void setExportFormat(String exportFormat) {
            this.exportFormat = exportFormat;
        }

        @Override
        public final Builder exportFormat(String exportFormat) {
            this.exportFormat = exportFormat;
            return this;
        }

        @Override
        public final Builder exportFormat(ExportFormat exportFormat) {
            this.exportFormat(exportFormat == null ? null : exportFormat.toString());
            return this;
        }

        public final Long getBilledSizeBytes() {
            return billedSizeBytes;
        }

        public final void setBilledSizeBytes(Long billedSizeBytes) {
            this.billedSizeBytes = billedSizeBytes;
        }

        @Override
        public final Builder billedSizeBytes(Long billedSizeBytes) {
            this.billedSizeBytes = billedSizeBytes;
            return this;
        }

        public final Long getItemCount() {
            return itemCount;
        }

        public final void setItemCount(Long itemCount) {
            this.itemCount = itemCount;
        }

        @Override
        public final Builder itemCount(Long itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final String getExportType() {
            return exportType;
        }

        public final void setExportType(String exportType) {
            this.exportType = exportType;
        }

        @Override
        public final Builder exportType(String exportType) {
            this.exportType = exportType;
            return this;
        }

        @Override
        public final Builder exportType(ExportType exportType) {
            this.exportType(exportType == null ? null : exportType.toString());
            return this;
        }

        public final IncrementalExportSpecification.Builder getIncrementalExportSpecification() {
            return incrementalExportSpecification != null ? incrementalExportSpecification.toBuilder() : null;
        }

        public final void setIncrementalExportSpecification(
                IncrementalExportSpecification.BuilderImpl incrementalExportSpecification) {
            this.incrementalExportSpecification = incrementalExportSpecification != null ? incrementalExportSpecification.build()
                    : null;
        }

        @Override
        public final Builder incrementalExportSpecification(IncrementalExportSpecification incrementalExportSpecification) {
            this.incrementalExportSpecification = incrementalExportSpecification;
            return this;
        }

        @Override
        public ExportDescription build() {
            return new ExportDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
