/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.OnDemandThroughputOverride;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputOverride;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicaGlobalSecondaryIndex
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicaGlobalSecondaryIndex> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexName").getter(ReplicaGlobalSecondaryIndex.getter(ReplicaGlobalSecondaryIndex::indexName)).setter(ReplicaGlobalSecondaryIndex.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()}).build();
    private static final SdkField<ProvisionedThroughputOverride> PROVISIONED_THROUGHPUT_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedThroughputOverride").getter(ReplicaGlobalSecondaryIndex.getter(ReplicaGlobalSecondaryIndex::provisionedThroughputOverride)).setter(ReplicaGlobalSecondaryIndex.setter(Builder::provisionedThroughputOverride)).constructor(ProvisionedThroughputOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughputOverride").build()}).build();
    private static final SdkField<OnDemandThroughputOverride> ON_DEMAND_THROUGHPUT_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OnDemandThroughputOverride").getter(ReplicaGlobalSecondaryIndex.getter(ReplicaGlobalSecondaryIndex::onDemandThroughputOverride)).setter(ReplicaGlobalSecondaryIndex.setter(Builder::onDemandThroughputOverride)).constructor(OnDemandThroughputOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandThroughputOverride").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD, PROVISIONED_THROUGHPUT_OVERRIDE_FIELD, ON_DEMAND_THROUGHPUT_OVERRIDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReplicaGlobalSecondaryIndex.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String indexName;
    private final ProvisionedThroughputOverride provisionedThroughputOverride;
    private final OnDemandThroughputOverride onDemandThroughputOverride;

    private ReplicaGlobalSecondaryIndex(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.provisionedThroughputOverride = builder.provisionedThroughputOverride;
        this.onDemandThroughputOverride = builder.onDemandThroughputOverride;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final ProvisionedThroughputOverride provisionedThroughputOverride() {
        return this.provisionedThroughputOverride;
    }

    public final OnDemandThroughputOverride onDemandThroughputOverride() {
        return this.onDemandThroughputOverride;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughputOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandThroughputOverride());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaGlobalSecondaryIndex)) {
            return false;
        }
        ReplicaGlobalSecondaryIndex other = (ReplicaGlobalSecondaryIndex)obj;
        return Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.provisionedThroughputOverride(), other.provisionedThroughputOverride()) && Objects.equals(this.onDemandThroughputOverride(), other.onDemandThroughputOverride());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicaGlobalSecondaryIndex").add("IndexName", (Object)this.indexName()).add("ProvisionedThroughputOverride", (Object)this.provisionedThroughputOverride()).add("OnDemandThroughputOverride", (Object)this.onDemandThroughputOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "ProvisionedThroughputOverride": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughputOverride()));
            }
            case "OnDemandThroughputOverride": {
                return Optional.ofNullable(clazz.cast(this.onDemandThroughputOverride()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IndexName", INDEX_NAME_FIELD);
        map.put("ProvisionedThroughputOverride", PROVISIONED_THROUGHPUT_OVERRIDE_FIELD);
        map.put("OnDemandThroughputOverride", ON_DEMAND_THROUGHPUT_OVERRIDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicaGlobalSecondaryIndex, T> g) {
        return obj -> g.apply((ReplicaGlobalSecondaryIndex)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String indexName;
        private ProvisionedThroughputOverride provisionedThroughputOverride;
        private OnDemandThroughputOverride onDemandThroughputOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaGlobalSecondaryIndex model) {
            this.indexName(model.indexName);
            this.provisionedThroughputOverride(model.provisionedThroughputOverride);
            this.onDemandThroughputOverride(model.onDemandThroughputOverride);
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final ProvisionedThroughputOverride.Builder getProvisionedThroughputOverride() {
            return this.provisionedThroughputOverride != null ? this.provisionedThroughputOverride.toBuilder() : null;
        }

        public final void setProvisionedThroughputOverride(ProvisionedThroughputOverride.BuilderImpl provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride != null ? provisionedThroughputOverride.build() : null;
        }

        @Override
        public final Builder provisionedThroughputOverride(ProvisionedThroughputOverride provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride;
            return this;
        }

        public final OnDemandThroughputOverride.Builder getOnDemandThroughputOverride() {
            return this.onDemandThroughputOverride != null ? this.onDemandThroughputOverride.toBuilder() : null;
        }

        public final void setOnDemandThroughputOverride(OnDemandThroughputOverride.BuilderImpl onDemandThroughputOverride) {
            this.onDemandThroughputOverride = onDemandThroughputOverride != null ? onDemandThroughputOverride.build() : null;
        }

        @Override
        public final Builder onDemandThroughputOverride(OnDemandThroughputOverride onDemandThroughputOverride) {
            this.onDemandThroughputOverride = onDemandThroughputOverride;
            return this;
        }

        public ReplicaGlobalSecondaryIndex build() {
            return new ReplicaGlobalSecondaryIndex(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicaGlobalSecondaryIndex> {
        public Builder indexName(String var1);

        public Builder provisionedThroughputOverride(ProvisionedThroughputOverride var1);

        default public Builder provisionedThroughputOverride(Consumer<ProvisionedThroughputOverride.Builder> provisionedThroughputOverride) {
            return this.provisionedThroughputOverride((ProvisionedThroughputOverride)((ProvisionedThroughputOverride.Builder)ProvisionedThroughputOverride.builder().applyMutation(provisionedThroughputOverride)).build());
        }

        public Builder onDemandThroughputOverride(OnDemandThroughputOverride var1);

        default public Builder onDemandThroughputOverride(Consumer<OnDemandThroughputOverride.Builder> onDemandThroughputOverride) {
            return this.onDemandThroughputOverride((OnDemandThroughputOverride)((OnDemandThroughputOverride.Builder)OnDemandThroughputOverride.builder().applyMutation(onDemandThroughputOverride)).build());
        }
    }
}

