/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of an <code>UpdateItem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateItemResponse extends DynamoDbResponse implements
        ToCopyableBuilder<UpdateItemResponse.Builder, UpdateItemResponse> {
    private static final SdkField<Map<String, AttributeValue>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(UpdateItemResponse::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ConsumedCapacity> CONSUMED_CAPACITY_FIELD = SdkField
            .<ConsumedCapacity> builder(MarshallingType.SDK_POJO).memberName("ConsumedCapacity")
            .getter(getter(UpdateItemResponse::consumedCapacity)).setter(setter(Builder::consumedCapacity))
            .constructor(ConsumedCapacity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedCapacity").build()).build();

    private static final SdkField<ItemCollectionMetrics> ITEM_COLLECTION_METRICS_FIELD = SdkField
            .<ItemCollectionMetrics> builder(MarshallingType.SDK_POJO).memberName("ItemCollectionMetrics")
            .getter(getter(UpdateItemResponse::itemCollectionMetrics)).setter(setter(Builder::itemCollectionMetrics))
            .constructor(ItemCollectionMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCollectionMetrics").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD,
            CONSUMED_CAPACITY_FIELD, ITEM_COLLECTION_METRICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Map<String, AttributeValue> attributes;

    private final ConsumedCapacity consumedCapacity;

    private final ItemCollectionMetrics itemCollectionMetrics;

    private UpdateItemResponse(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
        this.consumedCapacity = builder.consumedCapacity;
        this.itemCollectionMetrics = builder.itemCollectionMetrics;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of attribute values as they appear before or after the <code>UpdateItem</code> operation, as determined by
     * the <code>ReturnValues</code> parameter.
     * </p>
     * <p>
     * The <code>Attributes</code> map is only present if the update was successful and <code>ReturnValues</code> was
     * specified as something other than <code>NONE</code> in the request. Each element represents one attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return A map of attribute values as they appear before or after the <code>UpdateItem</code> operation, as
     *         determined by the <code>ReturnValues</code> parameter.</p>
     *         <p>
     *         The <code>Attributes</code> map is only present if the update was successful and
     *         <code>ReturnValues</code> was specified as something other than <code>NONE</code> in the request. Each
     *         element represents one attribute.
     */
    public final Map<String, AttributeValue> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The capacity units consumed by the <code>UpdateItem</code> operation. The data returned includes the total
     * provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation.
     * <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code> parameter was
     * specified. For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/read-write-operations.html#write-operation-consumption"
     * >Capacity unity consumption for write operations</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return The capacity units consumed by the <code>UpdateItem</code> operation. The data returned includes the
     *         total provisioned throughput consumed, along with statistics for the table and any indexes involved in
     *         the operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code>
     *         parameter was specified. For more information, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/read-write-operations.html#write-operation-consumption"
     *         >Capacity unity consumption for write operations</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public final ConsumedCapacity consumedCapacity() {
        return consumedCapacity;
    }

    /**
     * <p>
     * Information about item collections, if any, that were affected by the <code>UpdateItem</code> operation.
     * <code>ItemCollectionMetrics</code> is only returned if the <code>ReturnItemCollectionMetrics</code> parameter was
     * specified. If the table does not have any local secondary indexes, this information is not returned in the
     * response.
     * </p>
     * <p>
     * Each <code>ItemCollectionMetrics</code> element consists of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the
     * partition key value of the item itself.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SizeEstimateRangeGB</code> - An estimate of item collection size, in gigabytes. This value is a two-element
     * array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the
     * items in the table, plus the size of all attributes projected into all of the local secondary indexes on that
     * table. Use this estimate to measure whether a local secondary index is approaching its size limit.
     * </p>
     * <p>
     * The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about item collections, if any, that were affected by the <code>UpdateItem</code> operation.
     *         <code>ItemCollectionMetrics</code> is only returned if the <code>ReturnItemCollectionMetrics</code>
     *         parameter was specified. If the table does not have any local secondary indexes, this information is not
     *         returned in the response.</p>
     *         <p>
     *         Each <code>ItemCollectionMetrics</code> element consists of:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the
     *         partition key value of the item itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SizeEstimateRangeGB</code> - An estimate of item collection size, in gigabytes. This value is a
     *         two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the
     *         size of all the items in the table, plus the size of all attributes projected into all of the local
     *         secondary indexes on that table. Use this estimate to measure whether a local secondary index is
     *         approaching its size limit.
     *         </p>
     *         <p>
     *         The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the
     *         estimate.
     *         </p>
     *         </li>
     */
    public final ItemCollectionMetrics itemCollectionMetrics() {
        return itemCollectionMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(consumedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(itemCollectionMetrics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateItemResponse)) {
            return false;
        }
        UpdateItemResponse other = (UpdateItemResponse) obj;
        return hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes())
                && Objects.equals(consumedCapacity(), other.consumedCapacity())
                && Objects.equals(itemCollectionMetrics(), other.itemCollectionMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateItemResponse").add("Attributes", hasAttributes() ? attributes() : null)
                .add("ConsumedCapacity", consumedCapacity()).add("ItemCollectionMetrics", itemCollectionMetrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "ConsumedCapacity":
            return Optional.ofNullable(clazz.cast(consumedCapacity()));
        case "ItemCollectionMetrics":
            return Optional.ofNullable(clazz.cast(itemCollectionMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("ConsumedCapacity", CONSUMED_CAPACITY_FIELD);
        map.put("ItemCollectionMetrics", ITEM_COLLECTION_METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateItemResponse, T> g) {
        return obj -> g.apply((UpdateItemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateItemResponse> {
        /**
         * <p>
         * A map of attribute values as they appear before or after the <code>UpdateItem</code> operation, as determined
         * by the <code>ReturnValues</code> parameter.
         * </p>
         * <p>
         * The <code>Attributes</code> map is only present if the update was successful and <code>ReturnValues</code>
         * was specified as something other than <code>NONE</code> in the request. Each element represents one
         * attribute.
         * </p>
         * 
         * @param attributes
         *        A map of attribute values as they appear before or after the <code>UpdateItem</code> operation, as
         *        determined by the <code>ReturnValues</code> parameter.</p>
         *        <p>
         *        The <code>Attributes</code> map is only present if the update was successful and
         *        <code>ReturnValues</code> was specified as something other than <code>NONE</code> in the request. Each
         *        element represents one attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, AttributeValue> attributes);

        /**
         * <p>
         * The capacity units consumed by the <code>UpdateItem</code> operation. The data returned includes the total
         * provisioned throughput consumed, along with statistics for the table and any indexes involved in the
         * operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code>
         * parameter was specified. For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/read-write-operations.html#write-operation-consumption"
         * >Capacity unity consumption for write operations</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param consumedCapacity
         *        The capacity units consumed by the <code>UpdateItem</code> operation. The data returned includes the
         *        total provisioned throughput consumed, along with statistics for the table and any indexes involved in
         *        the operation. <code>ConsumedCapacity</code> is only returned if the
         *        <code>ReturnConsumedCapacity</code> parameter was specified. For more information, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/read-write-operations.html#write-operation-consumption"
         *        >Capacity unity consumption for write operations</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedCapacity(ConsumedCapacity consumedCapacity);

        /**
         * <p>
         * The capacity units consumed by the <code>UpdateItem</code> operation. The data returned includes the total
         * provisioned throughput consumed, along with statistics for the table and any indexes involved in the
         * operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code>
         * parameter was specified. For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/read-write-operations.html#write-operation-consumption"
         * >Capacity unity consumption for write operations</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConsumedCapacity.Builder} avoiding the
         * need to create one manually via {@link ConsumedCapacity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConsumedCapacity.Builder#build()} is called immediately and its
         * result is passed to {@link #consumedCapacity(ConsumedCapacity)}.
         * 
         * @param consumedCapacity
         *        a consumer that will call methods on {@link ConsumedCapacity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumedCapacity(ConsumedCapacity)
         */
        default Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> consumedCapacity) {
            return consumedCapacity(ConsumedCapacity.builder().applyMutation(consumedCapacity).build());
        }

        /**
         * <p>
         * Information about item collections, if any, that were affected by the <code>UpdateItem</code> operation.
         * <code>ItemCollectionMetrics</code> is only returned if the <code>ReturnItemCollectionMetrics</code> parameter
         * was specified. If the table does not have any local secondary indexes, this information is not returned in
         * the response.
         * </p>
         * <p>
         * Each <code>ItemCollectionMetrics</code> element consists of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the
         * partition key value of the item itself.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SizeEstimateRangeGB</code> - An estimate of item collection size, in gigabytes. This value is a
         * two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the
         * size of all the items in the table, plus the size of all attributes projected into all of the local secondary
         * indexes on that table. Use this estimate to measure whether a local secondary index is approaching its size
         * limit.
         * </p>
         * <p>
         * The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the
         * estimate.
         * </p>
         * </li>
         * </ul>
         * 
         * @param itemCollectionMetrics
         *        Information about item collections, if any, that were affected by the <code>UpdateItem</code>
         *        operation. <code>ItemCollectionMetrics</code> is only returned if the
         *        <code>ReturnItemCollectionMetrics</code> parameter was specified. If the table does not have any local
         *        secondary indexes, this information is not returned in the response.</p>
         *        <p>
         *        Each <code>ItemCollectionMetrics</code> element consists of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as
         *        the partition key value of the item itself.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SizeEstimateRangeGB</code> - An estimate of item collection size, in gigabytes. This value is a
         *        two-element array containing a lower bound and an upper bound for the estimate. The estimate includes
         *        the size of all the items in the table, plus the size of all attributes projected into all of the
         *        local secondary indexes on that table. Use this estimate to measure whether a local secondary index is
         *        approaching its size limit.
         *        </p>
         *        <p>
         *        The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of
         *        the estimate.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemCollectionMetrics(ItemCollectionMetrics itemCollectionMetrics);

        /**
         * <p>
         * Information about item collections, if any, that were affected by the <code>UpdateItem</code> operation.
         * <code>ItemCollectionMetrics</code> is only returned if the <code>ReturnItemCollectionMetrics</code> parameter
         * was specified. If the table does not have any local secondary indexes, this information is not returned in
         * the response.
         * </p>
         * <p>
         * Each <code>ItemCollectionMetrics</code> element consists of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the
         * partition key value of the item itself.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SizeEstimateRangeGB</code> - An estimate of item collection size, in gigabytes. This value is a
         * two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the
         * size of all the items in the table, plus the size of all attributes projected into all of the local secondary
         * indexes on that table. Use this estimate to measure whether a local secondary index is approaching its size
         * limit.
         * </p>
         * <p>
         * The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the
         * estimate.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link ItemCollectionMetrics.Builder} avoiding
         * the need to create one manually via {@link ItemCollectionMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ItemCollectionMetrics.Builder#build()} is called immediately and
         * its result is passed to {@link #itemCollectionMetrics(ItemCollectionMetrics)}.
         * 
         * @param itemCollectionMetrics
         *        a consumer that will call methods on {@link ItemCollectionMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #itemCollectionMetrics(ItemCollectionMetrics)
         */
        default Builder itemCollectionMetrics(Consumer<ItemCollectionMetrics.Builder> itemCollectionMetrics) {
            return itemCollectionMetrics(ItemCollectionMetrics.builder().applyMutation(itemCollectionMetrics).build());
        }
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private Map<String, AttributeValue> attributes = DefaultSdkAutoConstructMap.getInstance();

        private ConsumedCapacity consumedCapacity;

        private ItemCollectionMetrics itemCollectionMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateItemResponse model) {
            super(model);
            attributes(model.attributes);
            consumedCapacity(model.consumedCapacity);
            itemCollectionMetrics(model.itemCollectionMetrics);
        }

        public final Map<String, AttributeValue.Builder> getAttributes() {
            Map<String, AttributeValue.Builder> result = AttributeMapCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Map<String, AttributeValue.BuilderImpl> attributes) {
            this.attributes = AttributeMapCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Map<String, AttributeValue> attributes) {
            this.attributes = AttributeMapCopier.copy(attributes);
            return this;
        }

        public final ConsumedCapacity.Builder getConsumedCapacity() {
            return consumedCapacity != null ? consumedCapacity.toBuilder() : null;
        }

        public final void setConsumedCapacity(ConsumedCapacity.BuilderImpl consumedCapacity) {
            this.consumedCapacity = consumedCapacity != null ? consumedCapacity.build() : null;
        }

        @Override
        public final Builder consumedCapacity(ConsumedCapacity consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
            return this;
        }

        public final ItemCollectionMetrics.Builder getItemCollectionMetrics() {
            return itemCollectionMetrics != null ? itemCollectionMetrics.toBuilder() : null;
        }

        public final void setItemCollectionMetrics(ItemCollectionMetrics.BuilderImpl itemCollectionMetrics) {
            this.itemCollectionMetrics = itemCollectionMetrics != null ? itemCollectionMetrics.build() : null;
        }

        @Override
        public final Builder itemCollectionMetrics(ItemCollectionMetrics itemCollectionMetrics) {
            this.itemCollectionMetrics = itemCollectionMetrics;
            return this;
        }

        @Override
        public UpdateItemResponse build() {
            return new UpdateItemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
